/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twlthemeeditor.gui;

import de.matthiasmann.twl.DialogLayout;
import de.matthiasmann.twl.Widget;
import de.matthiasmann.twl.model.BooleanModel;
import de.matthiasmann.twl.model.Property;
import de.matthiasmann.twl.model.SimpleBooleanModel;
import de.matthiasmann.twlthemeeditor.gui.CollapsiblePanel;
import de.matthiasmann.twlthemeeditor.gui.PropertyAccessor;
import de.matthiasmann.twlthemeeditor.gui.PropertyEditorFactory;
import de.matthiasmann.twlthemeeditor.gui.PropertyFactories;
import de.matthiasmann.twlthemeeditor.gui.SpecialPropertyEditorFactory;
import java.util.Collection;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PropertyPanel
extends DialogLayout {
    private final PropertyFactories factories;
    private final HashMap<String, PropertyAccessor<?, ?>> propertyAccessors;

    public PropertyPanel(PropertyFactories propertyFactories) {
        this.factories = propertyFactories;
        this.propertyAccessors = new HashMap();
        this.setHorizontalGroup(this.createParallelGroup());
        this.setVerticalGroup(this.createSequentialGroup());
    }

    public PropertyPanel(PropertyFactories propertyFactories, Property<?>[] propertyArray) {
        this(propertyFactories);
        for (Property<?> property : propertyArray) {
            this.addProperty(property);
        }
    }

    public PropertyPanel(PropertyFactories propertyFactories, Collection<Property<?>> collection) {
        this(propertyFactories);
        for (Property<?> property : collection) {
            this.addProperty(property);
        }
    }

    public PropertyAccessor<?, ?> getPropertyAccessor(String string) {
        return this.propertyAccessors.get(string);
    }

    protected <T> void addProperty(Property<T> property) {
        boolean bl = property.canBeNull();
        PropertyEditorFactory<?, ?> propertyEditorFactory = this.factories.getFactory(property);
        if (!bl && propertyEditorFactory instanceof SpecialPropertyEditorFactory && ((SpecialPropertyEditorFactory)((Object)propertyEditorFactory)).createSpecial(this.getHorizontalGroup(), this.getVerticalGroup(), property)) {
            return;
        }
        if (propertyEditorFactory != null) {
            SimpleBooleanModel simpleBooleanModel = null;
            if (bl) {
                simpleBooleanModel = new SimpleBooleanModel();
            }
            PropertyAccessor propertyAccessor = new PropertyAccessor(property, (BooleanModel)simpleBooleanModel);
            Widget widget = propertyEditorFactory.create(propertyAccessor);
            this.propertyAccessors.put(property.getName(), propertyAccessor);
            CollapsiblePanel collapsiblePanel = new CollapsiblePanel(CollapsiblePanel.Direction.VERTICAL, property.getName(), widget, (BooleanModel)simpleBooleanModel);
            this.getVerticalGroup().addWidget((Widget)collapsiblePanel);
            this.getHorizontalGroup().addWidget((Widget)collapsiblePanel);
        } else {
            System.out.println("No factory for property " + property.getName() + " type " + property.getClass() + "<" + property.getType() + ">");
        }
    }
}

