/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twlthemeeditor.gui;

import de.matthiasmann.twl.Button;
import de.matthiasmann.twl.ColorSelector;
import de.matthiasmann.twl.EditField;
import de.matthiasmann.twl.GUI;
import de.matthiasmann.twl.Menu;
import de.matthiasmann.twl.MenuCheckbox;
import de.matthiasmann.twl.MenuElement;
import de.matthiasmann.twl.Scrollbar;
import de.matthiasmann.twl.ToggleButton;
import de.matthiasmann.twl.ValueAdjusterFloat;
import de.matthiasmann.twl.Widget;
import de.matthiasmann.twl.model.BooleanModel;
import de.matthiasmann.twl.model.ColorSpaceHSL;
import de.matthiasmann.twl.model.HasCallback;
import de.matthiasmann.twl.utils.XMLParser;
import de.matthiasmann.twlthemeeditor.gui.MainUI;
import de.matthiasmann.twlthemeeditor.gui.MessageLog;
import de.matthiasmann.twlthemeeditor.gui.ProgressDialog;
import de.matthiasmann.twlthemeeditor.gui.TestWidgetFactory;
import de.matthiasmann.twlthemeeditor.gui.testwidgets.PreviewWidgets;
import de.matthiasmann.twlthemeeditor.gui.testwidgets.TestComboBox;
import de.matthiasmann.twlthemeeditor.gui.testwidgets.TestFormular;
import de.matthiasmann.twlthemeeditor.gui.testwidgets.TestFrameWithWidgets;
import de.matthiasmann.twlthemeeditor.gui.testwidgets.TestLabel;
import de.matthiasmann.twlthemeeditor.gui.testwidgets.TestListBox;
import de.matthiasmann.twlthemeeditor.gui.testwidgets.TestScrollPane;
import de.matthiasmann.twlthemeeditor.gui.testwidgets.TestScrollbar;
import de.matthiasmann.twlthemeeditor.util.SolidFileClassLoader;
import de.matthiasmann.twlthemeeditor.util.SolidFileInspector;
import de.matthiasmann.twlthemeeditor.util.SolidFileWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.xmlpull.v1.XmlPullParserException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestWidgetManager {
    private static final MessageLog.Category CAT_ERROR = new MessageLog.Category("Test widgets", MessageLog.CombineMode.NONE, 1);
    private static final MessageLog.Category CAT_WARNING = new MessageLog.Category("Test widgets", MessageLog.CombineMode.NONE, 2);
    private static final MessageLog.Category CAT_INFO = new MessageLog.Category("Test widgets", MessageLog.CombineMode.NONE, 0);
    private final MessageLog messageLog;
    private final ArrayList<TestWidgetFactory> builtinWidgets;
    private final HashMap<ArrayList<String>, LoadedUserWidgets> userWidgets;
    private Callback callback;
    private TestWidgetFactory demoModeTestWidgetFactory;
    private TestWidgetFactory currentTestWidgetFactory;
    private LoadedUserWidgets currentUserWidgets;
    private ProgressDialog progressDialog;

    public TestWidgetManager(MessageLog messageLog) {
        this.messageLog = messageLog;
        this.builtinWidgets = new ArrayList();
        this.userWidgets = new LinkedHashMap<ArrayList<String>, LoadedUserWidgets>();
        this.builtinWidgets.add(new TestWidgetFactory(Widget.class, "Widget", new Object[0]));
        this.builtinWidgets.add(new TestWidgetFactory(TestLabel.class, "Label", new Object[0]));
        this.builtinWidgets.add(new TestWidgetFactory(Button.class, "Button", "Press me !"));
        this.builtinWidgets.add(new TestWidgetFactory(ToggleButton.class, "ToggleButton", "Toggle me !"));
        this.builtinWidgets.add(new TestWidgetFactory(EditField.class, "EditField", new Object[0]));
        this.builtinWidgets.add(new TestWidgetFactory(ValueAdjusterFloat.class, "ValueAdjusterFloat", new Object[0]));
        this.builtinWidgets.add(new TestWidgetFactory(TestScrollbar.class, "HScrollbar", Scrollbar.Orientation.HORIZONTAL));
        this.builtinWidgets.add(new TestWidgetFactory(TestScrollbar.class, "VScrollbar", Scrollbar.Orientation.VERTICAL));
        this.builtinWidgets.add(new TestWidgetFactory(TestListBox.class, "ListBox", new Object[0]));
        this.builtinWidgets.add(new TestWidgetFactory(TestComboBox.class, "ComboBox", new Object[0]));
        this.builtinWidgets.add(new TestWidgetFactory(PreviewWidgets.class, "Widgets", new Object[0]));
        this.builtinWidgets.add(new TestWidgetFactory(TestFormular.class, "Example formular", new Object[0]));
        this.builtinWidgets.add(new TestWidgetFactory(TestFrameWithWidgets.class, "Frame with Widgets", new Object[0]));
        this.builtinWidgets.add(new TestWidgetFactory(TestScrollPane.class, "TextArea", new Object[0]));
        this.builtinWidgets.add(new TestWidgetFactory(ColorSelector.class, "ColorSelector", new ColorSpaceHSL()));
        this.currentTestWidgetFactory = this.builtinWidgets.get(0);
    }

    public void setCallback(Callback callback) {
        this.callback = callback;
    }

    public void setProgressDialog(ProgressDialog progressDialog) {
        this.progressDialog = progressDialog;
    }

    public TestWidgetFactory getCurrentTestWidgetFactory() {
        return this.currentTestWidgetFactory;
    }

    public void setDemoMode(boolean bl) {
        if (bl) {
            this.demoModeTestWidgetFactory = new TestWidgetFactory(MainUI.class, "Theme Editor", new Object[0]);
            this.setCurrentTestWidgetFactory(this.demoModeTestWidgetFactory, null);
        } else {
            if (this.currentTestWidgetFactory == this.demoModeTestWidgetFactory) {
                this.setCurrentTestWidgetFactory(null, null);
            }
            this.demoModeTestWidgetFactory = null;
        }
        this.callback.newWidgetsLoaded();
    }

    public void clearCache() {
        this.clearCache(this.builtinWidgets);
        for (LoadedUserWidgets loadedUserWidgets : this.userWidgets.values()) {
            this.clearCache(loadedUserWidgets.factories);
        }
    }

    public void reloadCurrentWidget() {
        final LoadedUserWidgets loadedUserWidgets = this.currentUserWidgets;
        if (loadedUserWidgets != null) {
            final String string = this.currentTestWidgetFactory.getClazz().getName();
            this.loadUserWidgets(loadedUserWidgets.toScan, loadedUserWidgets.dependencies, new Runnable(){

                public void run() {
                    TestWidgetManager.this.callback.newWidgetsLoaded();
                    LoadedUserWidgets loadedUserWidgets2 = (LoadedUserWidgets)TestWidgetManager.this.userWidgets.get(loadedUserWidgets.key);
                    TestWidgetFactory testWidgetFactory = loadedUserWidgets2 == null ? null : loadedUserWidgets2.findFactory(string);
                    if (testWidgetFactory != null) {
                        TestWidgetManager.this.setCurrentTestWidgetFactory(testWidgetFactory, loadedUserWidgets2);
                    } else {
                        TestWidgetManager.this.setCurrentTestWidgetFactory(null, null);
                    }
                }
            });
        } else if (this.currentTestWidgetFactory != null) {
            this.currentTestWidgetFactory.clearCache();
            this.callback.testWidgetChanged();
        }
    }

    private void clearCache(ArrayList<TestWidgetFactory> arrayList) {
        for (TestWidgetFactory testWidgetFactory : arrayList) {
            testWidgetFactory.clearCache();
        }
    }

    public boolean loadUserWidgets(File file) {
        try {
            URI uRI = file.getParentFile().toURI();
            XMLParser xMLParser = new XMLParser(file.toURI().toURL());
            xMLParser.nextTag();
            xMLParser.require(2, null, "classpath");
            xMLParser.nextTag();
            ArrayList<URI> arrayList = this.readEntries(xMLParser, uRI, "entriesToScan");
            xMLParser.nextTag();
            ArrayList<URI> arrayList2 = this.readEntries(xMLParser, uRI, "entriesDependencies");
            xMLParser.nextTag();
            xMLParser.require(3, null, "classpath");
            if (arrayList.size() > 0) {
                this.loadUserWidgets(arrayList, arrayList2, new Runnable(){

                    public void run() {
                        TestWidgetManager.this.callback.newWidgetsLoaded();
                    }
                });
                return true;
            }
        }
        catch (Exception exception) {
            this.messageLog.add(new MessageLog.Entry(CAT_ERROR, "Can't load class path", null, exception, new MessageLog.EntryAction[0]));
        }
        return false;
    }

    private ArrayList<URI> readEntries(XMLParser xMLParser, URI uRI, String string) throws XmlPullParserException, IOException {
        ArrayList<URI> arrayList = new ArrayList<URI>();
        xMLParser.require(2, null, string);
        xMLParser.nextTag();
        while (!xMLParser.isEndTag()) {
            xMLParser.require(2, null, "entry");
            arrayList.add(uRI.resolve(xMLParser.nextText()));
            xMLParser.require(3, null, "entry");
            xMLParser.nextTag();
        }
        xMLParser.require(3, null, string);
        return arrayList;
    }

    public void updateMenu(Menu menu) {
        this.addMenu(menu, "Built-in widgets", this.builtinWidgets, null);
        if (this.demoModeTestWidgetFactory != null) {
            this.addMenu(menu, "Demo mode", Collections.singletonList(this.demoModeTestWidgetFactory), null);
        }
        for (Map.Entry<ArrayList<String>, LoadedUserWidgets> entry : this.userWidgets.entrySet()) {
            String string = entry.getKey().get(0);
            if (!string.endsWith("/")) {
                string = string.substring(string.lastIndexOf(47) + 1);
            }
            LoadedUserWidgets loadedUserWidgets = entry.getValue();
            this.addMenu(menu, string, loadedUserWidgets.factories, loadedUserWidgets);
        }
    }

    void setCurrentTestWidgetFactory(TestWidgetFactory testWidgetFactory, LoadedUserWidgets loadedUserWidgets) {
        this.currentTestWidgetFactory = testWidgetFactory;
        this.currentUserWidgets = loadedUserWidgets;
        this.callback.testWidgetChanged();
    }

    private void addMenu(Menu menu, String string, List<TestWidgetFactory> list, LoadedUserWidgets loadedUserWidgets) {
        Menu menu2 = new Menu(string);
        for (TestWidgetFactory testWidgetFactory : list) {
            this.addMenuItem(menu2, testWidgetFactory, loadedUserWidgets);
        }
        menu.add((MenuElement)menu2);
    }

    private void addMenuItem(Menu menu, TestWidgetFactory testWidgetFactory, LoadedUserWidgets loadedUserWidgets) {
        menu.add(new MenuCheckbox(testWidgetFactory.getName(), (BooleanModel)new SelectedWidgetModel(testWidgetFactory, loadedUserWidgets)).setTheme("radiobtn"));
    }

    private void loadUserWidgets(ArrayList<URI> arrayList, ArrayList<URI> arrayList2, final Runnable runnable) {
        this.progressDialog.setTitle("Scanning class files");
        this.progressDialog.setMessage("");
        this.progressDialog.setIndeterminate("");
        this.progressDialog.openPopupCentered();
        final Inspector inspector = new Inspector(arrayList, arrayList2, this.progressDialog, this.getClass().getClassLoader());
        GUI.AsyncCompletionListener<LoadedUserWidgets> asyncCompletionListener = new GUI.AsyncCompletionListener<LoadedUserWidgets>(){

            public void completed(LoadedUserWidgets loadedUserWidgets) {
                TestWidgetManager.this.progressDialog.closePopup();
                if (loadedUserWidgets != null) {
                    LoadedUserWidgets loadedUserWidgets2 = TestWidgetManager.this.userWidgets.put(inspector.key, loadedUserWidgets);
                    if (loadedUserWidgets2 != null) {
                        loadedUserWidgets2.classLoader.close();
                    }
                    TestWidgetManager.this.messageLog.add(new MessageLog.Entry(inspector.foundCriticalClasses ? CAT_WARNING : CAT_INFO, "Loaded " + loadedUserWidgets.factories.size() + " user widgets", inspector.infoMsg.toString(), null, new MessageLog.EntryAction[0]));
                    if (runnable != null) {
                        runnable.run();
                    }
                } else {
                    TestWidgetManager.this.messageLog.add(new MessageLog.Entry(CAT_WARNING, "Could not loaded any user widget", inspector.infoMsg.toString(), null, new MessageLog.EntryAction[0]));
                }
            }

            public void failed(Exception exception) {
                TestWidgetManager.this.progressDialog.closePopup();
                TestWidgetManager.this.messageLog.add(new MessageLog.Entry(CAT_ERROR, "Can't load user classes", null, exception, new MessageLog.EntryAction[0]));
            }
        };
        if (this.progressDialog.isOpen()) {
            this.progressDialog.getGUI().invokeAsync((Callable)inspector, (GUI.AsyncCompletionListener)asyncCompletionListener);
        } else {
            try {
                asyncCompletionListener.completed((Object)inspector.call());
            }
            catch (Exception exception) {
                asyncCompletionListener.failed(exception);
            }
        }
    }

    public static interface Callback {
        public void testWidgetChanged();

        public void newWidgetsLoaded();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum FailReason {
        NOT_PUBLIC(" : not public"),
        NO_DEFAULT_CONSTRUCTOR(" : no default constructor"),
        DEFAULT_CONSTRUCTOR_NOT_PUBLIC(" : non public default constructor"),
        ABSTRACT(" : is abstract");

        final String msg;

        private FailReason(String string2) {
            this.msg = string2;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Inspector
    implements Callable<LoadedUserWidgets>,
    SolidFileInspector,
    ClassVisitor {
        final ArrayList<URI> toScan;
        final ArrayList<URI> dependencies;
        final ProgressDialog progressDialog;
        final ClassLoader parentClassLoader;
        final ArrayList<String> key;
        final HashMap<String, Object> superClassMap;
        final HashSet<String> subClassSet;
        final TreeMap<String, FailReason> failedMap;
        final ArrayList<String> candidates;
        final StringBuilder infoMsg;
        String curClassName;
        boolean isPublic;
        boolean isAbstract;
        boolean foundDefaultConstructor;
        boolean isCandidate;
        boolean isInnerClass;
        boolean foundLWJGLclasses;
        boolean foundTWLclasses;
        boolean foundXPPclasses;
        boolean foundCriticalClasses;
        byte[] buffer;

        public Inspector(ArrayList<URI> arrayList, ArrayList<URI> arrayList2, ProgressDialog progressDialog, ClassLoader classLoader) {
            this.toScan = arrayList;
            this.dependencies = arrayList2;
            this.progressDialog = progressDialog;
            this.parentClassLoader = classLoader;
            this.key = new ArrayList();
            this.superClassMap = new HashMap();
            this.subClassSet = new HashSet();
            this.failedMap = new TreeMap();
            this.candidates = new ArrayList();
            this.buffer = new byte[4096];
            this.infoMsg = new StringBuilder();
        }

        @Override
        public LoadedUserWidgets call() throws Exception {
            Object object;
            Comparable<URI> comparable;
            int n;
            this.infoMsg.append("Loaded from the following class path:\n");
            File[] fileArray = new File[this.toScan.size() + this.dependencies.size()];
            int n2 = this.toScan.size();
            for (n = 0; n < n2; ++n) {
                comparable = this.toScan.get(n);
                object = new File((URI)comparable);
                fileArray[n] = object;
                String entry = ((File)object).toString();
                this.key.add(entry);
                this.infoMsg.append(entry).append("\n");
            }
            if (!this.dependencies.isEmpty()) {
                this.infoMsg.append("Additional class path:\n");
                n2 = this.dependencies.size();
                for (n = 0; n < n2; ++n) {
                    comparable = this.dependencies.get(n);
                    fileArray[n + this.toScan.size()] = object = new File((URI)comparable);
                    this.infoMsg.append(((File)object).getPath()).append("\n");
                }
            }
            ArrayList<TestWidgetFactory> arrayList = new ArrayList<TestWidgetFactory>();
            SolidFileClassLoader solidFileClassLoader = SolidFileClassLoader.create(this.parentClassLoader, this, fileArray);
            comparable = new StringBuilder();
            if (this.foundLWJGLclasses) {
                this.infoMsg.append("\nCRITICAL: LWJGL classes (org.lwjgl.*) found on class path");
                this.foundCriticalClasses = true;
            }
            if (this.foundTWLclasses) {
                this.infoMsg.append("\nCRITICAL: TWL classes (de.matthiasmann.twl.*) found on class path");
                this.foundCriticalClasses = true;
            }
            if (this.foundXPPclasses) {
                this.infoMsg.append("\nCRITICAL: XPP classes (org.xmlpull.v1.*) found on class path");
                this.foundCriticalClasses = true;
            }
            if (this.foundCriticalClasses) {
                this.infoMsg.append("\nIncluding classes from these package in the user widget class path may cause class loading issues and random failures\n");
            }
            for (String string : this.candidates) {
                if (!this.checkSuperClass(string)) continue;
                String string2 = string.replace('/', '.');
                try {
                    Class<?> clazz;
                    Class<?> clazz2 = clazz = Class.forName(string2, false, solidFileClassLoader);
                    arrayList.add(new TestWidgetFactory(clazz2, clazz2.getSimpleName(), new Object[0]));
                }
                catch (Exception exception) {
                    ((StringBuilder)comparable).append(string2).append(" : can't load class: ").append(exception.getMessage()).append("\n");
                }
            }
            this.failedMap.keySet().removeAll(this.subClassSet);
            for (Map.Entry<String, FailReason> entry : this.failedMap.entrySet()) {
                if (!this.checkSuperClass(entry.getKey())) continue;
                ((StringBuilder)comparable).append(entry.getKey().replace('/', '.')).append(entry.getValue().msg).append("\n");
            }
            if (!arrayList.isEmpty()) {
                object = new LoadedUserWidgets(this.toScan, this.dependencies, this.key, arrayList, solidFileClassLoader);
                this.infoMsg.append("\nThe following classes have been loaded:\n");
                for (TestWidgetFactory testWidgetFactory : arrayList) {
                    this.infoMsg.append(testWidgetFactory.getClazz().getName()).append("\n");
                }
            } else {
                object = null;
                solidFileClassLoader.close();
            }
            if (((StringBuilder)comparable).length() > 0) {
                this.infoMsg.append("\nThe following class could not be loaded:\n").append((CharSequence)((Object)comparable));
            }
            return object;
        }

        @Override
        public void processingRoot(File file) {
            if (this.progressDialog != null) {
                this.progressDialog.setMessage(file.toString());
            }
        }

        @Override
        public boolean shouldInspectFile(String string) {
            if (!string.endsWith(".class")) {
                return false;
            }
            if (string.startsWith("de/matthiasmann/twl/")) {
                this.foundTWLclasses = true;
                return false;
            }
            if (string.startsWith("org/lwjgl/")) {
                this.foundLWJGLclasses = true;
                return false;
            }
            if (string.startsWith("org/xmlpull/v1/")) {
                this.foundXPPclasses = true;
                return false;
            }
            return true;
        }

        @Override
        public void inspectFile(SolidFileWriter solidFileWriter, String string, InputStream inputStream) throws IOException {
            int n = this.readFile(inputStream);
            solidFileWriter.addEntry(string, this.buffer, 0, n);
            ClassReader classReader = new ClassReader(this.buffer, 0, n);
            classReader.accept((ClassVisitor)this, 7);
        }

        public void visit(int n, int n2, String string, String string2, String string3, String[] stringArray) {
            this.superClassMap.put(string, string3);
            this.subClassSet.add(string3);
            this.curClassName = string;
            this.isPublic = (n2 & 1) == 1;
            this.isAbstract = (n2 & 0x400) == 1024;
            this.isCandidate = false;
            this.isInnerClass = false;
            this.foundDefaultConstructor = false;
        }

        public void visitSource(String string, String string2) {
        }

        public void visitOuterClass(String string, String string2, String string3) {
            this.isInnerClass = true;
        }

        public AnnotationVisitor visitAnnotation(String string, boolean bl) {
            return null;
        }

        public void visitAttribute(Attribute attribute) {
        }

        public void visitInnerClass(String string, String string2, String string3, int n) {
            if (!this.isInnerClass && this.curClassName.equals(string)) {
                this.isInnerClass = true;
            }
        }

        public FieldVisitor visitField(int n, String string, String string2, String string3, Object object) {
            return null;
        }

        public MethodVisitor visitMethod(int n, String string, String string2, String string3, String[] stringArray) {
            if (this.isPublic && !this.isAbstract && "<init>".equals(string) && "()V".equals(string2)) {
                this.foundDefaultConstructor = true;
                if ((n & 1) == 1) {
                    this.candidates.add(this.curClassName);
                    this.isCandidate = true;
                }
            }
            return null;
        }

        public void visitEnd() {
            if (!this.isCandidate && !this.isInnerClass) {
                FailReason failReason = !this.isPublic ? FailReason.NOT_PUBLIC : (this.isAbstract ? FailReason.ABSTRACT : (this.foundDefaultConstructor ? FailReason.DEFAULT_CONSTRUCTOR_NOT_PUBLIC : FailReason.NO_DEFAULT_CONSTRUCTOR));
                this.failedMap.put(this.curClassName, failReason);
            }
            this.curClassName = null;
        }

        private int readFile(InputStream inputStream) throws IOException {
            int n;
            int n2 = 0;
            while ((n = inputStream.read(this.buffer, n2, this.buffer.length - n2)) > 0) {
                if ((n2 += n) != this.buffer.length) continue;
                this.buffer = Arrays.copyOf(this.buffer, n2 * 2);
            }
            return n2;
        }

        private boolean checkSuperClass(String string) {
            Object object = this.superClassMap.get(string);
            if (object instanceof Boolean) {
                return (Boolean)object;
            }
            boolean bl = object == null ? this.checkTWLWidget(string) : this.checkSuperClass((String)object);
            this.superClassMap.put(string, bl);
            return bl;
        }

        private boolean checkTWLWidget(String string) {
            if (string.startsWith("de/matthiasmann/twl/")) {
                string = string.replace('/', '.');
                try {
                    return Widget.class.isAssignableFrom(Class.forName(string, false, Widget.class.getClassLoader()));
                }
                catch (ClassNotFoundException classNotFoundException) {
                    return false;
                }
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class LoadedUserWidgets {
        final ArrayList<URI> toScan;
        final ArrayList<URI> dependencies;
        final ArrayList<String> key;
        final ArrayList<TestWidgetFactory> factories;
        final SolidFileClassLoader classLoader;

        public LoadedUserWidgets(ArrayList<URI> arrayList, ArrayList<URI> arrayList2, ArrayList<String> arrayList3, ArrayList<TestWidgetFactory> arrayList4, SolidFileClassLoader solidFileClassLoader) {
            this.toScan = arrayList;
            this.dependencies = arrayList2;
            this.key = arrayList3;
            this.factories = arrayList4;
            this.classLoader = solidFileClassLoader;
        }

        TestWidgetFactory findFactory(String string) {
            for (TestWidgetFactory testWidgetFactory : this.factories) {
                if (!string.equals(testWidgetFactory.getClazz().getName())) continue;
                return testWidgetFactory;
            }
            return null;
        }
    }

    class SelectedWidgetModel
    extends HasCallback
    implements BooleanModel {
        private final TestWidgetFactory factory;
        private final LoadedUserWidgets userWidgets;

        public SelectedWidgetModel(TestWidgetFactory testWidgetFactory, LoadedUserWidgets loadedUserWidgets) {
            this.factory = testWidgetFactory;
            this.userWidgets = loadedUserWidgets;
        }

        public boolean getValue() {
            return TestWidgetManager.this.currentTestWidgetFactory == this.factory;
        }

        public void setValue(boolean bl) {
            if (bl && TestWidgetManager.this.currentTestWidgetFactory != this.factory) {
                TestWidgetManager.this.setCurrentTestWidgetFactory(this.factory, this.userWidgets);
                this.doCallback();
            }
        }
    }
}

