/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twlthemeeditor.gui;

import de.matthiasmann.twl.Color;
import de.matthiasmann.twl.DialogLayout;
import de.matthiasmann.twl.DraggableButton;
import de.matthiasmann.twl.GUI;
import de.matthiasmann.twl.Label;
import de.matthiasmann.twl.Menu;
import de.matthiasmann.twl.Rect;
import de.matthiasmann.twl.ScrollPane;
import de.matthiasmann.twl.ToggleButton;
import de.matthiasmann.twl.ValueAdjusterFloat;
import de.matthiasmann.twl.Widget;
import de.matthiasmann.twl.model.BooleanModel;
import de.matthiasmann.twl.model.FloatModel;
import de.matthiasmann.twl.model.PersistentBooleanModel;
import de.matthiasmann.twl.model.SimpleBooleanModel;
import de.matthiasmann.twl.model.SimpleFloatModel;
import de.matthiasmann.twl.renderer.AnimationState;
import de.matthiasmann.twl.renderer.Image;
import de.matthiasmann.twlthemeeditor.gui.TextureViewer;
import java.io.IOException;
import java.net.URL;
import java.util.prefs.Preferences;

public class TextureViewerPane
extends DialogLayout {
    public static final AnimationState.StateKey STATE_ERROR = AnimationState.StateKey.get((String)"error");
    public static final AnimationState.StateKey STATE_ANIMATED_POSITION_BARS = AnimationState.StateKey.get((String)"animatedPositionBars");
    private final TextureViewer textureViewer;
    private final ScrollPane scrollPane;
    private final Label labelErrorDisplay;
    private final ToggleButton btnShowCompleteTexture;
    private final ToggleButton btnShowSplitPositions;
    private final Label mousePositionDisplay;
    private final SimpleFloatModel zoomFactorX;
    private final SimpleFloatModel zoomFactorY;
    private final SimpleBooleanModel linkZoomFactors;
    private final SimpleBooleanModel showCompleteTexture;
    private final SimpleBooleanModel showSplitPositions;
    private final PersistentBooleanModel animatedPositionBars;
    private static final int[] EMPTY_INT_ARRAY = new int[0];
    private Rect rect;
    private int[] splitPositionsX = EMPTY_INT_ARRAY;
    private int[] splitPositionsY = EMPTY_INT_ARRAY;
    private boolean showMousePosition;
    private Listener listener;

    public TextureViewerPane() {
        this.textureViewer = new TextureViewer();
        this.scrollPane = new ScrollPane((Widget)this.textureViewer);
        this.labelErrorDisplay = new Label();
        this.mousePositionDisplay = new Label();
        this.mousePositionDisplay.setTheme("mousePositionDisplay");
        this.zoomFactorX = new SimpleFloatModel(0.1f, 20.0f, 1.0f);
        this.zoomFactorY = new SimpleFloatModel(0.1f, 20.0f, 1.0f);
        this.linkZoomFactors = new SimpleBooleanModel(true);
        this.showCompleteTexture = new SimpleBooleanModel(false);
        this.showSplitPositions = new SimpleBooleanModel(true);
        this.animatedPositionBars = new PersistentBooleanModel(Preferences.userNodeForPackage(TextureViewerPane.class), "animated-positionbars", true);
        ZoomAdjuster zoomAdjuster = new ZoomAdjuster((FloatModel)this.zoomFactorX);
        zoomAdjuster.setDisplayPrefix("X: ");
        zoomAdjuster.setFormat("%2.1f");
        ZoomAdjuster zoomAdjuster2 = new ZoomAdjuster((FloatModel)this.zoomFactorY);
        zoomAdjuster2.setDisplayPrefix("Y: ");
        zoomAdjuster2.setFormat("%2.1f");
        ToggleButton toggleButton = new ToggleButton((BooleanModel)this.linkZoomFactors);
        toggleButton.setTheme("linkZoomFactors");
        this.btnShowCompleteTexture = new ToggleButton((BooleanModel)this.showCompleteTexture);
        this.btnShowCompleteTexture.setTheme("showCompleteTexture");
        this.btnShowSplitPositions = new ToggleButton((BooleanModel)this.showSplitPositions);
        this.btnShowSplitPositions.setTheme("showSplitPositions");
        DialogLayout.Group group = this.createSequentialGroup().addWidget((Widget)this.mousePositionDisplay).addGap().addWidgets(new Widget[]{zoomAdjuster, toggleButton, zoomAdjuster2}).addGap().addWidget((Widget)this.btnShowCompleteTexture).addWidget((Widget)this.btnShowSplitPositions).addGap();
        DialogLayout.Group group2 = this.createParallelGroup(new Widget[]{this.mousePositionDisplay, zoomAdjuster, toggleButton, zoomAdjuster2, this.btnShowCompleteTexture, this.btnShowSplitPositions});
        this.setClip(true);
        this.setHorizontalGroup(this.createParallelGroup().addWidget((Widget)this.scrollPane).addGroup(group).addWidget((Widget)this.labelErrorDisplay));
        this.setVerticalGroup(this.createSequentialGroup().addWidget((Widget)this.scrollPane).addGroup(group2).addWidget((Widget)this.labelErrorDisplay));
        this.zoomFactorX.addCallback(new Runnable(){

            public void run() {
                if (TextureViewerPane.this.linkZoomFactors.getValue()) {
                    TextureViewerPane.this.zoomFactorY.setValue(TextureViewerPane.this.zoomFactorX.getValue());
                }
                TextureViewerPane.this.updateZoom();
            }
        });
        this.zoomFactorY.addCallback(new Runnable(){

            public void run() {
                if (TextureViewerPane.this.linkZoomFactors.getValue()) {
                    TextureViewerPane.this.zoomFactorX.setValue(TextureViewerPane.this.zoomFactorY.getValue());
                }
                TextureViewerPane.this.updateZoom();
            }
        });
        this.showCompleteTexture.addCallback(new Runnable(){

            public void run() {
                TextureViewerPane.this.updateRect();
                TextureViewerPane.this.scrollToRect();
            }
        });
        this.showSplitPositions.addCallback(new Runnable(){

            public void run() {
                TextureViewerPane.this.updateRect();
            }
        });
        this.textureViewer.addExceptionCallback(new Runnable(){

            public void run() {
                IOException iOException = TextureViewerPane.this.textureViewer.getLoadException();
                TextureViewerPane.this.labelErrorDisplay.setText(iOException != null ? iOException.getMessage() : "");
                TextureViewerPane.this.labelErrorDisplay.getAnimationState().setAnimationState(STATE_ERROR, iOException != null);
            }
        });
        this.textureViewer.setImageDragListener(new DraggableButton.DragListener(){
            int scrollStartX;
            int scrollStartY;

            public void dragStarted() {
                this.scrollStartX = TextureViewerPane.this.scrollPane.getScrollPositionX();
                this.scrollStartY = TextureViewerPane.this.scrollPane.getScrollPositionY();
            }

            public void dragged(int n, int n2) {
                TextureViewerPane.this.scrollPane.setScrollPositionX(this.scrollStartX - n);
                TextureViewerPane.this.scrollPane.setScrollPositionY(this.scrollStartY - n2);
            }

            public void dragStopped() {
            }
        });
        this.textureViewer.setPositionBarDragListener(new PositionBarDragHandler());
        this.textureViewer.setMouseOverListener(new TextureViewer.MouseOverListener(){

            public void mousePosition(int n, int n2) {
                if (TextureViewerPane.this.showMousePosition) {
                    TextureViewerPane.this.mousePositionDisplay.setText("X:" + n + " Y:" + n2);
                }
            }

            public void mouseExited() {
                if (TextureViewerPane.this.showMousePosition) {
                    TextureViewerPane.this.mousePositionDisplay.setText("");
                }
            }
        });
        this.animatedPositionBars.addCallback(new Runnable(){

            public void run() {
                TextureViewerPane.this.updateAnimatedPositionBars();
            }
        });
        this.updateZoom();
        this.updateAnimatedPositionBars();
    }

    public void setListener(Listener listener) {
        this.listener = listener;
    }

    public void addSettingsMenuItems(Menu menu) {
        menu.add("Animate split positions", (BooleanModel)this.animatedPositionBars);
    }

    public void setUrl(URL uRL) {
        this.textureViewer.setUrl(uRL);
    }

    public void setTextureLoadedListener(TextureViewer.TextureLoadedListener textureLoadedListener) {
        this.textureViewer.setTextureLoadedListener(textureLoadedListener);
    }

    public void setRect(Rect rect) {
        this.rect = rect;
        this.showMousePosition = true;
        this.btnShowCompleteTexture.setEnabled(rect != null);
        this.mousePositionDisplay.setText("");
        this.updateRect();
    }

    public void scrollToRect() {
        if (this.rect != null && this.showCompleteTexture.getValue()) {
            this.textureViewer.validateImage();
            this.scrollPane.validateLayout();
            this.scrollPane.setScrollPositionX((int)((float)this.rect.getCenterX() * this.zoomFactorX.getValue()) + this.textureViewer.getBorderLeft() - this.scrollPane.getInnerWidth() / 2);
            this.scrollPane.setScrollPositionY((int)((float)this.rect.getCenterY() * this.zoomFactorY.getValue()) + this.textureViewer.getBorderTop() - this.scrollPane.getInnerHeight() / 2);
        }
    }

    public void setSplitPositionsX(int[] nArray) {
        this.splitPositionsX = nArray == null ? EMPTY_INT_ARRAY : nArray;
        this.updateRect();
    }

    public void setSplitPositionsY(int[] nArray) {
        this.splitPositionsY = nArray == null ? EMPTY_INT_ARRAY : nArray;
        this.updateRect();
    }

    public void setImage(Image image) {
        this.rect = null;
        this.showMousePosition = false;
        this.textureViewer.setImage(image);
        this.btnShowCompleteTexture.setEnabled(false);
        this.mousePositionDisplay.setText("Preview");
        this.updateRect();
    }

    public void setTintColor(Color color) {
        this.textureViewer.setTintColor(color);
    }

    void updateZoom() {
        this.textureViewer.setZoom(this.zoomFactorX.getValue(), this.zoomFactorY.getValue());
    }

    void updateRect() {
        this.textureViewer.setRect(this.showCompleteTexture.getValue() ? null : this.rect);
        if (this.rect != null && this.showSplitPositions.getValue()) {
            if (this.showCompleteTexture.getValue()) {
                this.textureViewer.setPositionBarsVert(this.addEdges(this.splitPositionsX, this.rect.getX(), this.rect.getRight()));
                this.textureViewer.setPositionBarsHorz(this.addEdges(this.splitPositionsY, this.rect.getY(), this.rect.getBottom()));
            } else {
                this.textureViewer.setPositionBarsVert(this.splitPositionsX);
                this.textureViewer.setPositionBarsHorz(this.splitPositionsY);
            }
        } else if (this.rect != null && this.showCompleteTexture.getValue()) {
            this.textureViewer.setPositionBarsVert(new int[]{this.rect.getX(), this.rect.getRight()});
            this.textureViewer.setPositionBarsHorz(new int[]{this.rect.getY(), this.rect.getBottom()});
        } else {
            this.textureViewer.setPositionBarsVert(null);
            this.textureViewer.setPositionBarsHorz(null);
        }
    }

    private int[] addEdges(int[] nArray, int n, int n2) {
        int[] nArray2 = new int[nArray.length + 2];
        nArray2[0] = n;
        for (int i = 0; i < nArray.length; ++i) {
            nArray2[i + 1] = n + nArray[i];
        }
        nArray2[nArray2.length - 1] = n2;
        return nArray2;
    }

    void updateAnimatedPositionBars() {
        this.textureViewer.getAnimationState().setAnimationState(STATE_ANIMATED_POSITION_BARS, this.animatedPositionBars.getValue());
    }

    protected void paint(GUI gUI) {
        super.paint(gUI);
    }

    static abstract class DragHandlerAxis {
        int start;

        DragHandlerAxis() {
        }

        abstract void drag(int var1);
    }

    class DragHandlerBottom
    extends DragHandlerAxis {
        public DragHandlerBottom() {
            this.start = TextureViewerPane.this.rect.getBottom();
        }

        void drag(int n) {
            TextureViewerPane.this.listener.dragEdgeBottom(n);
        }
    }

    class DragHandlerLeft
    extends DragHandlerAxis {
        public DragHandlerLeft() {
            this.start = TextureViewerPane.this.rect.getX();
        }

        void drag(int n) {
            TextureViewerPane.this.listener.dragEdgeLeft(n);
        }
    }

    class DragHandlerRight
    extends DragHandlerAxis {
        public DragHandlerRight() {
            this.start = TextureViewerPane.this.rect.getRight();
        }

        void drag(int n) {
            TextureViewerPane.this.listener.dragEdgeRight(n);
        }
    }

    class DragHandlerSplitX
    extends DragHandlerAxis {
        final int idx;

        public DragHandlerSplitX(int n) {
            this.idx = n;
            this.start = TextureViewerPane.this.splitPositionsX[n];
        }

        void drag(int n) {
            TextureViewerPane.this.listener.dragSplitX(this.idx, n);
        }
    }

    class DragHandlerSplitY
    extends DragHandlerAxis {
        final int idx;

        public DragHandlerSplitY(int n) {
            this.idx = n;
            this.start = TextureViewerPane.this.splitPositionsY[n];
        }

        void drag(int n) {
            TextureViewerPane.this.listener.dragSplitY(this.idx, n);
        }
    }

    class DragHandlerTop
    extends DragHandlerAxis {
        public DragHandlerTop() {
            this.start = TextureViewerPane.this.rect.getY();
        }

        void drag(int n) {
            TextureViewerPane.this.listener.dragEdgeTop(n);
        }
    }

    public static interface Listener {
        public void dragEdgeTop(int var1);

        public void dragEdgeLeft(int var1);

        public void dragEdgeRight(int var1);

        public void dragEdgeBottom(int var1);

        public void dragSplitX(int var1, int var2);

        public void dragSplitY(int var1, int var2);
    }

    class PositionBarDragHandler
    implements TextureViewer.PositionBarDragListener {
        DragHandlerAxis axisX;
        DragHandlerAxis axisY;

        PositionBarDragHandler() {
        }

        public void dragStarted(int n, int n2) {
            if (TextureViewerPane.this.rect != null) {
                boolean bl = TextureViewerPane.this.showCompleteTexture.getValue();
                boolean bl2 = TextureViewerPane.this.showSplitPositions.getValue();
                this.axisX = null;
                this.axisY = null;
                if (bl) {
                    if (bl2) {
                        if (n2 == 0) {
                            this.axisX = new DragHandlerLeft();
                        } else if (n2 == TextureViewerPane.this.splitPositionsX.length + 1) {
                            this.axisX = new DragHandlerRight();
                        } else if (n2 > 0) {
                            this.axisX = new DragHandlerSplitX(n2 - 1);
                        }
                        if (n == 0) {
                            this.axisY = new DragHandlerTop();
                        } else if (n == TextureViewerPane.this.splitPositionsY.length + 1) {
                            this.axisY = new DragHandlerBottom();
                        } else if (n > 0) {
                            this.axisY = new DragHandlerSplitY(n - 1);
                        }
                    } else {
                        if (n2 == 0) {
                            this.axisX = new DragHandlerLeft();
                        } else if (n2 == 1) {
                            this.axisX = new DragHandlerRight();
                        }
                        if (n == 0) {
                            this.axisY = new DragHandlerTop();
                        } else if (n == 1) {
                            this.axisY = new DragHandlerBottom();
                        }
                    }
                } else if (bl2) {
                    if (n2 >= 0) {
                        this.axisX = new DragHandlerSplitX(n2);
                    }
                    if (n >= 0) {
                        this.axisY = new DragHandlerSplitY(n);
                    }
                }
            }
        }

        public void dragged(int n, int n2) {
            if (TextureViewerPane.this.listener != null) {
                if (this.axisX != null) {
                    this.axisX.drag(this.axisX.start + n);
                }
                if (this.axisY != null) {
                    this.axisY.drag(this.axisY.start + n2);
                }
            }
        }

        public void dragStopped() {
        }
    }

    static class ZoomAdjuster
    extends ValueAdjusterFloat {
        public ZoomAdjuster(FloatModel floatModel) {
            super(floatModel);
        }

        protected void doDecrement() {
            float f = this.getValue();
            float f2 = f > 1.0f ? 1.0f : 0.1f;
            float f3 = (float)Math.floor(f / f2) * f2;
            this.setValue(f3 < f ? f3 : f3 - f2);
        }

        protected void doIncrement() {
            float f = this.getValue();
            float f2 = f < 1.0f ? 0.1f : 1.0f;
            float f3 = (float)Math.ceil(f / f2) * f2;
            this.setValue(f3 > f ? f3 : f3 + f2);
        }
    }
}

