/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twlthemeeditor.gui;

import de.matthiasmann.twl.GUI;
import de.matthiasmann.twl.Widget;
import de.matthiasmann.twl.model.AbstractTreeTableModel;
import de.matthiasmann.twl.model.AbstractTreeTableNode;
import de.matthiasmann.twl.model.TreeTableNode;
import de.matthiasmann.twlthemeeditor.datamodel.DecoratedText;
import de.matthiasmann.twlthemeeditor.gui.Context;
import de.matthiasmann.twlthemeeditor.gui.TestWidgetContainer;
import de.matthiasmann.twlthemeeditor.gui.WidgetTreeNode;

public class WidgetTreeModel
extends AbstractTreeTableModel
implements WidgetTreeNode {
    Context ctx;
    GUI gui;
    private static final String[] COLUMN_NAMES = new String[]{"Theme", "Class"};

    public String getColumnHeaderText(int n) {
        return COLUMN_NAMES[n];
    }

    public int getNumColumns() {
        return COLUMN_NAMES.length;
    }

    public void createTreeFromWidget(Context context, GUI gUI) {
        this.ctx = context;
        this.gui = gUI;
        this.checkChildren(this);
    }

    public void refreshTree() {
        this.checkChildren(this);
    }

    public Widget getWidget() {
        return this.gui;
    }

    public Widget getWidget(TreeTableNode treeTableNode) {
        if (treeTableNode instanceof Node) {
            return ((Node)treeTableNode).widget;
        }
        return null;
    }

    public Node getNodeForWidget(Widget widget) {
        if (widget != null) {
            WidgetTreeNode widgetTreeNode;
            Widget widget2 = widget.getParent();
            if (WidgetTreeModel.isTestWidgetContainer(widget2)) {
                widget2 = widget2.getParent();
            }
            if ((widgetTreeNode = widget2 == this.gui ? this : this.getNodeForWidget(widget2)) != null) {
                int n = widgetTreeNode.getNumChildren();
                for (int i = 0; i < n; ++i) {
                    Node node = (Node)widgetTreeNode.getChild(i);
                    if (node.widget != widget) continue;
                    return node;
                }
            }
        }
        return null;
    }

    public void removeAllChildren() {
        super.removeAllChildren();
    }

    public void add(TreeTableNode treeTableNode) {
        this.insertChild(treeTableNode, this.getNumChildren());
    }

    public void setLeaf() {
    }

    private void addChildren(WidgetTreeNode widgetTreeNode) {
        widgetTreeNode.removeAllChildren();
        Widget widget = widgetTreeNode.getWidget();
        int n = widget.getNumChildren();
        for (int i = 0; i < n; ++i) {
            Widget widget2 = WidgetTreeModel.getChildWidget(widget, i);
            Node node = new Node(widgetTreeNode, this.ctx, widget2);
            this.addChildren(node);
            widgetTreeNode.add(node);
        }
        widgetTreeNode.setLeaf();
    }

    private void checkChildren(WidgetTreeNode widgetTreeNode) {
        Widget widget = widgetTreeNode.getWidget();
        int n = widgetTreeNode.getNumChildren();
        if (n != widget.getNumChildren()) {
            this.addChildren(widgetTreeNode);
        } else {
            Node node;
            int n2;
            for (n2 = 0; n2 < n; ++n2) {
                node = (Node)widgetTreeNode.getChild(n2);
                if (WidgetTreeModel.getChildWidget(widget, n2) == node.widget) continue;
                this.addChildren(widgetTreeNode);
                return;
            }
            for (n2 = 0; n2 < n; ++n2) {
                node = (Node)widgetTreeNode.getChild(n2);
                this.checkChildren(node);
            }
        }
    }

    private static boolean isTestWidgetContainer(Widget widget) {
        return widget instanceof TestWidgetContainer && widget.getNumChildren() == 1;
    }

    private static Widget getChildWidget(Widget widget, int n) {
        Widget widget2 = widget.getChild(n);
        if (WidgetTreeModel.isTestWidgetContainer(widget2)) {
            widget2 = widget2.getChild(0);
        }
        return widget2;
    }

    public static class Node
    extends AbstractTreeTableNode
    implements WidgetTreeNode {
        final Context ctx;
        final Widget widget;
        final String className;

        public Node(TreeTableNode treeTableNode, Context context, Widget widget) {
            super(treeTableNode);
            this.ctx = context;
            this.widget = widget;
            this.className = widget.getClass().getSimpleName();
        }

        public Object getData(int n) {
            switch (n) {
                case 0: {
                    String string = this.widget.getTheme();
                    if (string.length() == 0) {
                        string = "<EMPTY>";
                    }
                    if (this.ctx != null) {
                        return DecoratedText.apply(string, this.ctx.getWidgetFlags(this.widget));
                    }
                    return string;
                }
                case 1: {
                    return this.className;
                }
            }
            return "";
        }

        public Widget getWidget() {
            return this.widget;
        }

        public Object getTooltipContent(int n) {
            if (this.ctx != null) {
                return this.ctx.getTooltipForWidget(this.widget);
            }
            return null;
        }

        public void add(TreeTableNode treeTableNode) {
            this.insertChild(treeTableNode, this.getNumChildren());
        }

        public void removeAllChildren() {
            super.removeAllChildren();
        }

        public void setLeaf() {
            super.setLeaf(this.getNumChildren() == 0);
        }
    }
}

