/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twlthemeeditor.gui.editors;

import de.matthiasmann.twl.DialogLayout;
import de.matthiasmann.twl.ToggleButton;
import de.matthiasmann.twl.Widget;
import de.matthiasmann.twl.model.BooleanModel;
import de.matthiasmann.twl.model.Property;
import de.matthiasmann.twlthemeeditor.gui.PropertyAccessor;
import de.matthiasmann.twlthemeeditor.gui.PropertyEditorFactory;
import de.matthiasmann.twlthemeeditor.gui.SpecialPropertyEditorFactory;
import de.matthiasmann.twlthemeeditor.properties.HasTooltip;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BooleanEditorFactory
implements PropertyEditorFactory<Boolean, Property<Boolean>>,
SpecialPropertyEditorFactory<Boolean> {
    @Override
    public Widget create(PropertyAccessor<Boolean, Property<Boolean>> propertyAccessor) {
        Property<Boolean> property = propertyAccessor.getProperty();
        return this.createToggleButton(property, "boolean");
    }

    @Override
    public boolean createSpecial(DialogLayout.Group group, DialogLayout.Group group2, Property<Boolean> property) {
        ToggleButton toggleButton = this.createToggleButton(property, "checkbox");
        group.addWidget((Widget)toggleButton);
        group2.addWidget((Widget)toggleButton);
        return true;
    }

    private ToggleButton createToggleButton(Property<Boolean> property, String string) {
        ToggleButton toggleButton = new ToggleButton((BooleanModel)(property instanceof BooleanModel ? (BooleanModel)property : new PropertyBooleanModel(property)));
        toggleButton.setText(property.getName());
        toggleButton.setTheme(string);
        if (property instanceof HasTooltip) {
            toggleButton.setTooltipContent((Object)((HasTooltip)property).getTooltip());
        }
        return toggleButton;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class PropertyBooleanModel
    implements BooleanModel {
        final Property<Boolean> property;

        public PropertyBooleanModel(Property<Boolean> property) {
            this.property = property;
        }

        public void addCallback(Runnable runnable) {
            this.property.addValueChangedCallback(runnable);
        }

        public void removeCallback(Runnable runnable) {
            this.property.removeValueChangedCallback(runnable);
        }

        public boolean getValue() {
            return (Boolean)this.property.getPropertyValue();
        }

        public void setValue(boolean bl) {
            this.property.setPropertyValue((Object)bl);
        }
    }
}

