/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twlthemeeditor.gui.editors;

import de.matthiasmann.twl.DialogLayout;
import de.matthiasmann.twl.EditField;
import de.matthiasmann.twl.ToggleButton;
import de.matthiasmann.twl.Widget;
import de.matthiasmann.twl.model.BooleanModel;
import de.matthiasmann.twl.model.HasCallback;
import de.matthiasmann.twl.model.SimpleBooleanModel;
import de.matthiasmann.twl.utils.StateExpression;
import de.matthiasmann.twlthemeeditor.datamodel.Condition;
import de.matthiasmann.twlthemeeditor.gui.Context;
import de.matthiasmann.twlthemeeditor.gui.PropertyAccessor;
import de.matthiasmann.twlthemeeditor.gui.PropertyEditorFactory;
import de.matthiasmann.twlthemeeditor.gui.StateEditField;
import de.matthiasmann.twlthemeeditor.properties.ConditionProperty;
import java.text.ParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConditionEditorFactory
implements PropertyEditorFactory<Condition, ConditionProperty> {
    final Context ctx;

    public ConditionEditorFactory(Context context) {
        this.ctx = context;
    }

    @Override
    public Widget create(PropertyAccessor<Condition, ConditionProperty> propertyAccessor) {
        ConditionModifier conditionModifier;
        ConditionModifier conditionModifier2 = conditionModifier = new ConditionModifier(this.ctx, propertyAccessor);
        ((Object)((Object)conditionModifier2)).getClass();
        ToggleButton toggleButton = new ToggleButton((BooleanModel)conditionModifier2.new ConditionModifier.TypeBooleanModel(Condition.Type.NONE));
        toggleButton.setTheme("condition-none");
        ConditionModifier conditionModifier3 = conditionModifier;
        ((Object)((Object)conditionModifier3)).getClass();
        ToggleButton toggleButton2 = new ToggleButton((BooleanModel)conditionModifier3.new ConditionModifier.TypeBooleanModel(Condition.Type.IF));
        toggleButton2.setTheme("condition-if");
        ConditionModifier conditionModifier4 = conditionModifier;
        ((Object)((Object)conditionModifier4)).getClass();
        ToggleButton toggleButton3 = new ToggleButton((BooleanModel)conditionModifier4.new ConditionModifier.TypeBooleanModel(Condition.Type.UNLESS));
        toggleButton3.setTheme("condition-unless");
        DialogLayout dialogLayout = new DialogLayout();
        dialogLayout.setTheme("conditioneditor");
        DialogLayout.Group group = dialogLayout.createSequentialGroup().addWidgetsWithGap("radiobutton", new Widget[]{toggleButton, toggleButton2, toggleButton3}).addGap();
        dialogLayout.setHorizontalGroup(dialogLayout.createParallelGroup().addGroup(group).addWidget((Widget)conditionModifier.ef));
        dialogLayout.setVerticalGroup(dialogLayout.createSequentialGroup().addGroup(dialogLayout.createParallelGroup(new Widget[]{toggleButton, toggleButton2, toggleButton3})).addWidget((Widget)conditionModifier.ef));
        return dialogLayout;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ConditionModifier
    extends HasCallback
    implements EditField.Callback {
        final PropertyAccessor<Condition, ConditionProperty> pa;
        final EditField ef;
        Condition.Type conditionType;

        protected ConditionModifier(Context context, PropertyAccessor<Condition, ConditionProperty> propertyAccessor) {
            this.pa = propertyAccessor;
            Condition condition = propertyAccessor.getValue(Condition.NONE);
            this.conditionType = condition.getType();
            this.ef = new StateEditField();
            this.ef.setText(condition.getCondition());
            this.ef.addCallback((EditField.Callback)this);
            this.ef.setAutoCompletion(context.collectAllStates());
            this.setEnable();
        }

        boolean setCondition() {
            this.doCallback();
            this.setEnable();
            String string = this.ef.getText();
            if (this.ef.isLocallyEnabled()) {
                try {
                    StateExpression.parse((String)string, (boolean)false);
                }
                catch (ParseException parseException) {
                    this.ef.setErrorMessage((Object)parseException.getMessage());
                    return false;
                }
            }
            this.ef.setErrorMessage(null);
            this.pa.setValue(new Condition(this.conditionType, string));
            return true;
        }

        private void setEnable() {
            this.ef.setEnabled(this.conditionType != Condition.Type.NONE);
        }

        public void callback(int n) {
            if (this.setCondition() && n == 28) {
                this.ef.getAutoCompletionWindow().closeInfo();
            }
        }

        class TypeBooleanModel
        extends SimpleBooleanModel
        implements Runnable {
            private final Condition.Type type;

            public TypeBooleanModel(Condition.Type type) {
                this.type = type;
                this.run();
                ConditionModifier.this.addCallback(this);
            }

            public void setValue(boolean bl) {
                if (bl) {
                    ConditionModifier.this.conditionType = this.type;
                    ConditionModifier.this.setCondition();
                }
            }

            public final void run() {
                super.setValue(ConditionModifier.this.conditionType == this.type);
            }
        }
    }
}

