/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twlthemeeditor.gui.editors;

import de.matthiasmann.twl.DialogLayout;
import de.matthiasmann.twl.Dimension;
import de.matthiasmann.twl.ValueAdjusterInt;
import de.matthiasmann.twl.Widget;
import de.matthiasmann.twl.model.IntegerModel;
import de.matthiasmann.twl.model.SimpleIntegerModel;
import de.matthiasmann.twlthemeeditor.gui.PropertyAccessor;
import de.matthiasmann.twlthemeeditor.gui.PropertyEditorFactory;
import de.matthiasmann.twlthemeeditor.properties.DimensionProperty;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DimensionEditorFactory
implements PropertyEditorFactory<Dimension, DimensionProperty> {
    @Override
    public Widget create(PropertyAccessor<Dimension, DimensionProperty> propertyAccessor) {
        return new DimensionEditor(propertyAccessor);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class DimensionEditor
    extends DialogLayout
    implements Runnable {
        private static final Dimension DEFAULT_DIM = new Dimension(0, 0);
        private final PropertyAccessor<Dimension, DimensionProperty> pa;
        private final SimpleIntegerModel modelX;
        private final SimpleIntegerModel modelY;

        public DimensionEditor(PropertyAccessor<Dimension, DimensionProperty> propertyAccessor) {
            this.pa = propertyAccessor;
            Dimension dimension = propertyAccessor.getValue(DEFAULT_DIM);
            this.modelX = new SimpleIntegerModel(0, Short.MAX_VALUE, dimension.getX());
            this.modelY = new SimpleIntegerModel(0, Short.MAX_VALUE, dimension.getY());
            this.modelX.addCallback((Runnable)this);
            this.modelY.addCallback((Runnable)this);
            ValueAdjusterInt[] valueAdjusterIntArray = new ValueAdjusterInt[]{new ValueAdjusterInt((IntegerModel)this.modelX), new ValueAdjusterInt((IntegerModel)this.modelY)};
            valueAdjusterIntArray[0].setDisplayPrefix("X: ");
            valueAdjusterIntArray[1].setDisplayPrefix("Y: ");
            this.setHorizontalGroup(this.createParallelGroup((Widget[])valueAdjusterIntArray));
            this.setVerticalGroup(this.createSequentialGroup().addWidgetsWithGap("adjuster", (Widget[])valueAdjusterIntArray));
        }

        @Override
        public void run() {
            Dimension dimension = new Dimension(this.modelX.getValue(), this.modelY.getValue());
            this.pa.setValue(dimension);
        }
    }
}

