/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twlthemeeditor.gui.editors;

import de.matthiasmann.twl.ValueAdjusterFloat;
import de.matthiasmann.twl.Widget;
import de.matthiasmann.twl.model.FloatModel;
import de.matthiasmann.twl.model.Property;
import de.matthiasmann.twlthemeeditor.gui.PropertyAccessor;
import de.matthiasmann.twlthemeeditor.gui.PropertyEditorFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FloatEditorFactory
implements PropertyEditorFactory<Float, Property<Float>> {
    @Override
    public Widget create(PropertyAccessor<Float, Property<Float>> propertyAccessor) {
        Property<Float> property = propertyAccessor.getProperty();
        ValueAdjusterFloat valueAdjusterFloat = new ValueAdjusterFloat((FloatModel)(property instanceof FloatModel ? (FloatModel)property : new PropertyFloatModel(property)));
        propertyAccessor.setWidgetsToEnable(new Widget[]{valueAdjusterFloat});
        return valueAdjusterFloat;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class PropertyFloatModel
    implements FloatModel {
        final Property<Float> property;

        public PropertyFloatModel(Property<Float> property) {
            this.property = property;
        }

        public void addCallback(Runnable runnable) {
            this.property.addValueChangedCallback(runnable);
        }

        public void removeCallback(Runnable runnable) {
            this.property.removeValueChangedCallback(runnable);
        }

        public float getValue() {
            return ((Float)this.property.getPropertyValue()).floatValue();
        }

        public void setValue(float f) {
            this.property.setPropertyValue((Object)Float.valueOf(f));
        }

        public float getMaxValue() {
            return 32767.0f;
        }

        public float getMinValue() {
            return -32768.0f;
        }
    }
}

