/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twlthemeeditor.gui.editors;

import de.matthiasmann.twl.DialogLayout;
import de.matthiasmann.twl.ValueAdjusterInt;
import de.matthiasmann.twl.Widget;
import de.matthiasmann.twl.model.AbstractIntegerModel;
import de.matthiasmann.twl.model.IntegerModel;
import de.matthiasmann.twlthemeeditor.gui.PropertyAccessor;
import de.matthiasmann.twlthemeeditor.gui.PropertyEditorFactory;
import de.matthiasmann.twlthemeeditor.properties.GapProperty;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GapEditorFactory
implements PropertyEditorFactory<DialogLayout.Gap, GapProperty> {
    @Override
    public Widget create(PropertyAccessor<DialogLayout.Gap, GapProperty> propertyAccessor) {
        return new GapEditor(propertyAccessor);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class GapEditor
    extends DialogLayout {
        private static final DialogLayout.Gap DEFAULT_GAP_VALUE = new DialogLayout.Gap();
        private final PropertyAccessor<DialogLayout.Gap, GapProperty> pa;
        private final GapIntegerModel modelMin;
        private final GapIntegerModel modelPref;
        private final GapIntegerModel modelMax;
        private DialogLayout.Gap gap;

        public GapEditor(PropertyAccessor<DialogLayout.Gap, GapProperty> propertyAccessor) {
            this.pa = propertyAccessor;
            this.gap = propertyAccessor.getValue(DEFAULT_GAP_VALUE);
            this.modelMin = new GapIntegerModel(){

                public int getValue() {
                    return ((GapEditor)GapEditor.this).gap.min;
                }

                public void setValue(int n) {
                    GapEditor.this.setGap(n, Math.max(n, ((GapEditor)GapEditor.this).gap.preferred), Math.max(n, ((GapEditor)GapEditor.this).gap.max));
                }
            };
            this.modelPref = new GapIntegerModel(){

                public int getValue() {
                    return ((GapEditor)GapEditor.this).gap.preferred;
                }

                public void setValue(int n) {
                    GapEditor.this.setGap(Math.min(n, ((GapEditor)GapEditor.this).gap.min), n, Math.max(n, ((GapEditor)GapEditor.this).gap.max));
                }
            };
            this.modelMax = new GapIntegerModel(){

                public int getValue() {
                    return ((GapEditor)GapEditor.this).gap.max;
                }

                public void setValue(int n) {
                    GapEditor.this.setGap(Math.min(n, ((GapEditor)GapEditor.this).gap.min), Math.min(n, ((GapEditor)GapEditor.this).gap.preferred), n);
                }
            };
            ValueAdjusterInt[] valueAdjusterIntArray = new ValueAdjusterInt[]{new ValueAdjusterInt((IntegerModel)this.modelMin), new ValueAdjusterInt((IntegerModel)this.modelPref), new ValueAdjusterInt((IntegerModel)this.modelMax)};
            valueAdjusterIntArray[0].setDisplayPrefix("Min: ");
            valueAdjusterIntArray[1].setDisplayPrefix("Pref: ");
            valueAdjusterIntArray[2].setDisplayPrefix("Max: ");
            this.setHorizontalGroup(this.createParallelGroup((Widget[])valueAdjusterIntArray));
            this.setVerticalGroup(this.createSequentialGroup().addWidgetsWithGap("adjuster", (Widget[])valueAdjusterIntArray));
        }

        void setGap(int n, int n2, int n3) {
            this.gap = new DialogLayout.Gap(n, n2, n3);
            this.pa.setValue(this.gap);
            this.modelMin.fireCallback();
            this.modelPref.fireCallback();
            this.modelMax.fireCallback();
        }

        abstract class GapIntegerModel
        extends AbstractIntegerModel {
            GapIntegerModel() {
            }

            public int getMaxValue() {
                return Short.MAX_VALUE;
            }

            public int getMinValue() {
                return 0;
            }

            void fireCallback() {
                this.doCallback();
            }
        }
    }
}

