/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twlthemeeditor.gui.editors;

import de.matthiasmann.twl.DialogLayout;
import de.matthiasmann.twl.Dimension;
import de.matthiasmann.twl.ValueAdjusterInt;
import de.matthiasmann.twl.Widget;
import de.matthiasmann.twl.model.AbstractIntegerModel;
import de.matthiasmann.twl.model.IntegerModel;
import de.matthiasmann.twlthemeeditor.datamodel.HotSpot;
import de.matthiasmann.twlthemeeditor.gui.PropertyAccessor;
import de.matthiasmann.twlthemeeditor.gui.PropertyEditorFactory;
import de.matthiasmann.twlthemeeditor.properties.HotSpotProperty;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HotSpotEditorFactory
implements PropertyEditorFactory<HotSpot, HotSpotProperty> {
    private static final HotSpot NULL_HOTSPOT = new HotSpot(0, 0);

    @Override
    public Widget create(PropertyAccessor<HotSpot, HotSpotProperty> propertyAccessor) {
        return new HotSpotEditor(propertyAccessor);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class HotSpotEditor
    extends DialogLayout {
        private final PropertyAccessor<HotSpot, HotSpotProperty> pa;
        private HotSpot hotspot;

        public HotSpotEditor(PropertyAccessor<HotSpot, HotSpotProperty> propertyAccessor) {
            this.pa = propertyAccessor;
            this.hotspot = propertyAccessor.getValue(NULL_HOTSPOT);
            ValueAdjusterInt valueAdjusterInt = new ValueAdjusterInt((IntegerModel)new AbstractIntegerModel(){

                public int getMaxValue() {
                    return HotSpotEditor.this.getLimit().getX();
                }

                public int getMinValue() {
                    return 0;
                }

                public int getValue() {
                    return HotSpotEditor.this.hotspot.getX();
                }

                public void setValue(int n) {
                    HotSpotEditor.this.setHotSpot(new HotSpot(n, HotSpotEditor.this.hotspot.getY()));
                }
            });
            valueAdjusterInt.setDisplayPrefix("X: ");
            ValueAdjusterInt valueAdjusterInt2 = new ValueAdjusterInt((IntegerModel)new AbstractIntegerModel(){

                public int getMaxValue() {
                    return HotSpotEditor.this.getLimit().getY();
                }

                public int getMinValue() {
                    return 0;
                }

                public int getValue() {
                    return HotSpotEditor.this.hotspot.getY();
                }

                public void setValue(int n) {
                    HotSpotEditor.this.setHotSpot(new HotSpot(HotSpotEditor.this.hotspot.getX(), n));
                }
            });
            valueAdjusterInt2.setDisplayPrefix("Y: ");
            this.setHorizontalGroup(this.createParallelGroup(new Widget[]{valueAdjusterInt, valueAdjusterInt2}));
            this.setVerticalGroup(this.createSequentialGroup().addWidgetsWithGap("adjuster", new Widget[]{valueAdjusterInt, valueAdjusterInt2}));
        }

        Dimension getLimit() {
            return this.pa.getProperty().getLimit();
        }

        void setHotSpot(HotSpot hotSpot) {
            this.hotspot = hotSpot;
            this.pa.setValue(hotSpot);
        }
    }
}

