/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twlthemeeditor.gui.editors;

import de.matthiasmann.twl.DialogLayout;
import de.matthiasmann.twl.Label;
import de.matthiasmann.twl.ValueAdjusterInt;
import de.matthiasmann.twl.Widget;
import de.matthiasmann.twl.model.IntegerModel;
import de.matthiasmann.twl.model.Property;
import de.matthiasmann.twlthemeeditor.gui.PropertyAccessor;
import de.matthiasmann.twlthemeeditor.gui.PropertyEditorFactory;
import de.matthiasmann.twlthemeeditor.gui.SpecialPropertyEditorFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntegerEditorFactory
implements PropertyEditorFactory<Integer, Property<Integer>>,
SpecialPropertyEditorFactory<Integer> {
    @Override
    public Widget create(PropertyAccessor<Integer, Property<Integer>> propertyAccessor) {
        Property<Integer> property = propertyAccessor.getProperty();
        ValueAdjusterInt valueAdjusterInt = new ValueAdjusterInt(IntegerEditorFactory.asIntegerModel(property));
        propertyAccessor.setWidgetsToEnable(new Widget[]{valueAdjusterInt});
        return valueAdjusterInt;
    }

    @Override
    public boolean createSpecial(DialogLayout.Group group, DialogLayout.Group group2, Property<Integer> property) {
        if (property.isReadOnly()) {
            final IntegerModel integerModel = IntegerEditorFactory.asIntegerModel(property);
            final Label label = new Label();
            Runnable runnable = new Runnable(){

                public void run() {
                    label.setText(Integer.toString(integerModel.getValue()));
                }
            };
            integerModel.addCallback(runnable);
            label.setTheme("value");
            runnable.run();
            Label label2 = new Label(property.getName());
            label2.setLabelFor((Widget)label);
            DialogLayout dialogLayout = new DialogLayout();
            dialogLayout.setTheme("readOnlyInteger");
            dialogLayout.setHorizontalGroup(dialogLayout.createSequentialGroup().addWidget((Widget)label2).addGap().addWidget((Widget)label));
            dialogLayout.setVerticalGroup(dialogLayout.createParallelGroup().addWidget((Widget)label2).addWidget((Widget)label));
            group.addWidget((Widget)dialogLayout);
            group2.addWidget((Widget)dialogLayout);
            return true;
        }
        return false;
    }

    private static IntegerModel asIntegerModel(Property<Integer> property) {
        return property instanceof IntegerModel ? (IntegerModel)property : new PropertyIntegerModel(property);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class PropertyIntegerModel
    implements IntegerModel {
        final Property<Integer> property;

        public PropertyIntegerModel(Property<Integer> property) {
            this.property = property;
        }

        public void addCallback(Runnable runnable) {
            this.property.addValueChangedCallback(runnable);
        }

        public void removeCallback(Runnable runnable) {
            this.property.removeValueChangedCallback(runnable);
        }

        public int getValue() {
            return (Integer)this.property.getPropertyValue();
        }

        public void setValue(int n) {
            this.property.setPropertyValue((Object)n);
        }

        public int getMaxValue() {
            return Short.MAX_VALUE;
        }

        public int getMinValue() {
            return Short.MIN_VALUE;
        }
    }
}

