/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twlthemeeditor.gui.editors;

import de.matthiasmann.twl.DialogLayout;
import de.matthiasmann.twl.EditField;
import de.matthiasmann.twl.ToggleButton;
import de.matthiasmann.twl.ValueAdjusterInt;
import de.matthiasmann.twl.Widget;
import de.matthiasmann.twl.model.BooleanModel;
import de.matthiasmann.twl.model.IntegerModel;
import de.matthiasmann.twl.model.Property;
import de.matthiasmann.twl.model.SimpleBooleanModel;
import de.matthiasmann.twl.model.SimpleIntegerModel;
import de.matthiasmann.twlthemeeditor.datamodel.IntegerFormula;
import de.matthiasmann.twlthemeeditor.datamodel.Utils;
import de.matthiasmann.twlthemeeditor.gui.PropertyAccessor;
import de.matthiasmann.twlthemeeditor.gui.PropertyEditorFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntegerFormulaEditorFactory
implements PropertyEditorFactory<IntegerFormula, Property<IntegerFormula>> {
    @Override
    public Widget create(PropertyAccessor<IntegerFormula, Property<IntegerFormula>> propertyAccessor) {
        return new IntegerEditor(propertyAccessor);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class IntegerEditor
    extends DialogLayout
    implements Runnable,
    EditField.Callback {
        private final PropertyAccessor<IntegerFormula, Property<IntegerFormula>> pa;
        private final SimpleBooleanModel useFormula;
        private final EditField efFormula;
        private final SimpleIntegerModel model;
        private final ValueAdjusterInt adjuster;
        boolean inSetProperty;

        public IntegerEditor(PropertyAccessor<IntegerFormula, Property<IntegerFormula>> propertyAccessor) {
            Object object;
            this.pa = propertyAccessor;
            Property<IntegerFormula> property = propertyAccessor.getProperty();
            int n = Integer.MIN_VALUE;
            int n2 = Integer.MAX_VALUE;
            if (property instanceof IntegerModel) {
                object = (IntegerModel)property;
                n = object.getMinValue();
                n2 = object.getMaxValue();
            }
            propertyAccessor.setWidgetsToEnable(new Widget[]{this});
            object = propertyAccessor.getValue(new IntegerFormula(n < 0 && n2 >= 0 ? 0 : n));
            this.model = new SimpleIntegerModel(n, n2, ((IntegerFormula)object).getValue());
            this.model.addCallback((Runnable)this);
            this.adjuster = new ValueAdjusterInt((IntegerModel)this.model);
            this.useFormula = new SimpleBooleanModel(((IntegerFormula)object).hasFormula());
            this.useFormula.addCallback(new Runnable(){

                public void run() {
                    IntegerEditor.this.setEnabled();
                    IntegerEditor.this.setProperty();
                }
            });
            ToggleButton toggleButton = new ToggleButton((BooleanModel)this.useFormula);
            toggleButton.setTheme("btnUseFormula");
            this.efFormula = new EditField();
            this.efFormula.setText(((IntegerFormula)object).toString());
            this.efFormula.addCallback((EditField.Callback)this);
            this.setHorizontalGroup(this.createParallelGroup().addGroup(this.createSequentialGroup().addWidget((Widget)toggleButton).addWidget((Widget)this.efFormula)).addWidget((Widget)this.adjuster));
            this.setVerticalGroup(this.createSequentialGroup().addGroup(this.createParallelGroup().addWidget((Widget)toggleButton).addWidget((Widget)this.efFormula)).addWidget((Widget)this.adjuster));
            this.setEnabled();
        }

        @Override
        public void run() {
            this.setProperty();
        }

        public void callback(int n) {
            if (!this.inSetProperty) {
                this.setProperty();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void setProperty() {
            try {
                IntegerFormula integerFormula;
                this.inSetProperty = true;
                if (this.useFormula.getValue()) {
                    String string = this.efFormula.getText();
                    try {
                        int n = Utils.parseInt(string);
                        this.model.setValue(n);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    integerFormula = new IntegerFormula(this.model.getValue(), string);
                } else {
                    integerFormula = new IntegerFormula(this.model.getValue());
                    try {
                        Utils.parseInt(this.efFormula.getText());
                        this.efFormula.setText(integerFormula.toString());
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                this.pa.setValue(integerFormula);
            }
            finally {
                this.inSetProperty = false;
            }
        }

        void setEnabled() {
            this.efFormula.setEnabled(this.useFormula.getValue());
            this.adjuster.setEnabled(!this.useFormula.getValue());
        }
    }
}

