/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twlthemeeditor.gui.editors;

import de.matthiasmann.twl.Button;
import de.matthiasmann.twl.DialogLayout;
import de.matthiasmann.twl.Rect;
import de.matthiasmann.twl.ToggleButton;
import de.matthiasmann.twl.ValueAdjusterInt;
import de.matthiasmann.twl.Widget;
import de.matthiasmann.twl.model.BooleanModel;
import de.matthiasmann.twlthemeeditor.gui.PropertyAccessor;
import de.matthiasmann.twlthemeeditor.gui.PropertyEditorFactory;
import de.matthiasmann.twlthemeeditor.properties.RectProperty;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RectEditorFactory
implements PropertyEditorFactory<Rect, RectProperty> {
    @Override
    public Widget create(PropertyAccessor<Rect, RectProperty> propertyAccessor) {
        return new RectEditor(propertyAccessor);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class RectEditor
    extends DialogLayout {
        private final BooleanModel wholeAreaModel;
        private final ToggleButton toggleWholeArea;
        private final ValueAdjusterInt adjusterX;
        private final ValueAdjusterInt adjusterY;
        private final ValueAdjusterInt adjusterW;
        private final ValueAdjusterInt adjusterH;

        public RectEditor(PropertyAccessor<Rect, RectProperty> propertyAccessor) {
            this.adjusterX = new ValueAdjusterInt(propertyAccessor.getProperty().getXProperty());
            this.adjusterY = new ValueAdjusterInt(propertyAccessor.getProperty().getYProperty());
            this.adjusterW = new ValueAdjusterInt(propertyAccessor.getProperty().getWidthProperty());
            this.adjusterH = new ValueAdjusterInt(propertyAccessor.getProperty().getHeightProperty());
            this.adjusterX.setTooltipContent((Object)"X position");
            this.adjusterY.setTooltipContent((Object)"Y position");
            this.adjusterW.setTooltipContent((Object)"Width");
            this.adjusterH.setTooltipContent((Object)"Height");
            this.adjusterX.setDisplayPrefix("X: ");
            this.adjusterY.setDisplayPrefix("Y: ");
            this.adjusterW.setDisplayPrefix("W: ");
            this.adjusterH.setDisplayPrefix("H: ");
            DialogLayout.Group group = this.createParallelGroup();
            DialogLayout.Group group2 = this.createSequentialGroup();
            this.wholeAreaModel = propertyAccessor.getProperty().getWholeAreaModel();
            if (this.wholeAreaModel != null) {
                this.toggleWholeArea = new ToggleButton(this.wholeAreaModel);
                this.toggleWholeArea.setTheme("btnWholeArea");
                group.addWidget((Widget)this.toggleWholeArea);
                group2.addWidget((Widget)this.toggleWholeArea);
            } else {
                this.toggleWholeArea = null;
            }
            group.addWidgets(new Widget[]{this.adjusterX, this.adjusterY, this.adjusterW, this.adjusterH});
            group2.addWidgetsWithGap("adjuster", new Widget[]{this.adjusterX, this.adjusterY, this.adjusterW, this.adjusterH});
            RectProperty.AbstractAction[] abstractActionArray = propertyAccessor.getProperty().getActions();
            if (abstractActionArray.length > 0) {
                DialogLayout.Group group3 = this.createSequentialGroup();
                DialogLayout.Group group4 = this.createParallelGroup();
                for (RectProperty.AbstractAction abstractAction : abstractActionArray) {
                    Button button = new Button(abstractAction.getName());
                    button.setTheme("actionButton");
                    button.setTooltipContent((Object)abstractAction.getTooltip());
                    button.addCallback((Runnable)abstractAction);
                    group3.addWidget((Widget)button);
                    group4.addWidget((Widget)button);
                }
                group3.addGap();
                group.addGroup(group3);
                group2.addGroup(group4);
            }
            this.setHorizontalGroup(group);
            this.setVerticalGroup(group2);
        }
    }
}

