/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twlthemeeditor.gui.editors;

import de.matthiasmann.twl.Button;
import de.matthiasmann.twl.ComboBox;
import de.matthiasmann.twl.DialogLayout;
import de.matthiasmann.twl.EditField;
import de.matthiasmann.twl.Widget;
import de.matthiasmann.twl.model.ListModel;
import de.matthiasmann.twlthemeeditor.datamodel.Utils;
import de.matthiasmann.twlthemeeditor.gui.Context;
import de.matthiasmann.twlthemeeditor.gui.PropertyAccessor;
import de.matthiasmann.twlthemeeditor.gui.PropertyEditorFactory;
import de.matthiasmann.twlthemeeditor.properties.WidgetThemeProperty;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WidgetThemeEditorFactory
implements PropertyEditorFactory<String, WidgetThemeProperty> {
    private final Context ctx;

    public WidgetThemeEditorFactory(Context context) {
        this.ctx = context;
    }

    @Override
    public Widget create(final PropertyAccessor<String, WidgetThemeProperty> propertyAccessor) {
        final WidgetThemeProperty widgetThemeProperty = propertyAccessor.getProperty();
        final ListModel<String> listModel = this.ctx.getRefableThemes(widgetThemeProperty.getThemePathElements(1));
        final ComboBox comboBox = new ComboBox(listModel);
        Button button = new Button();
        final EditField editField = new EditField();
        final Runnable runnable = new Runnable(){

            public void run() {
                editField.setText(widgetThemeProperty.getThemePath());
            }
        };
        comboBox.setSelected(Utils.find(listModel, widgetThemeProperty.getPropertyValue()));
        comboBox.addCallback(new Runnable(){

            public void run() {
                int n = comboBox.getSelected();
                if (n >= 0) {
                    propertyAccessor.setValue(listModel.getEntry(n));
                    runnable.run();
                }
            }
        });
        button.setTheme("jumpbutton");
        button.addCallback(new Runnable(){

            public void run() {
                WidgetThemeEditorFactory.this.ctx.selectTheme(widgetThemeProperty.getThemePathElements(0));
            }
        });
        editField.setTheme("themepath");
        editField.setReadOnly(true);
        runnable.run();
        DialogLayout dialogLayout = new DialogLayout();
        dialogLayout.setTheme("widgetthemeeditor");
        dialogLayout.setHorizontalGroup(dialogLayout.createParallelGroup().addGroup(dialogLayout.createSequentialGroup(new Widget[]{comboBox, button})).addWidget((Widget)editField));
        dialogLayout.setVerticalGroup(dialogLayout.createSequentialGroup().addGroup(dialogLayout.createParallelGroup(new Widget[]{comboBox, button})).addWidget((Widget)editField));
        return dialogLayout;
    }
}

