/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twlthemeeditor.properties;

import de.matthiasmann.twl.model.AbstractProperty;
import de.matthiasmann.twl.model.StringModel;
import de.matthiasmann.twlthemeeditor.datamodel.Utils;
import org.jdom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributeProperty
extends AbstractProperty<String>
implements StringModel {
    private final Element element;
    private final String attribute;
    private final String name;
    private final boolean canBeNull;

    public AttributeProperty(Element element, String string) {
        this.element = element;
        this.attribute = string;
        this.name = Utils.capitalize(string);
        this.canBeNull = false;
    }

    public AttributeProperty(Element element, String string, String string2, boolean bl) {
        this.element = element;
        this.attribute = string;
        this.name = string2;
        this.canBeNull = bl;
    }

    public String getName() {
        return this.name;
    }

    public boolean isReadOnly() {
        return false;
    }

    public boolean canBeNull() {
        return this.canBeNull;
    }

    public Class<String> getType() {
        return String.class;
    }

    public String getValue() {
        return this.element.getAttributeValue(this.attribute);
    }

    public void setValue(String string) throws IllegalArgumentException {
        if (!this.canBeNull && string == null) {
            throw new NullPointerException("value");
        }
        String string2 = this.element.getAttributeValue(this.attribute);
        if (!Utils.equals(string2, string)) {
            if (string == null) {
                this.element.removeAttribute(this.attribute);
            } else {
                this.element.setAttribute(this.attribute, string);
            }
            this.fireValueChangedCallback();
        }
    }

    public String getPropertyValue() {
        return this.getValue();
    }

    public void setPropertyValue(String string) throws IllegalArgumentException {
        this.setValue(string);
    }

    public void addCallback(Runnable runnable) {
        this.addValueChangedCallback(runnable);
    }

    public void removeCallback(Runnable runnable) {
        this.removeValueChangedCallback(runnable);
    }
}

