/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twlthemeeditor.properties;

import de.matthiasmann.twl.Border;
import de.matthiasmann.twl.model.Property;
import de.matthiasmann.twlthemeeditor.datamodel.BorderFormula;
import de.matthiasmann.twlthemeeditor.datamodel.Utils;
import de.matthiasmann.twlthemeeditor.properties.DerivedProperty;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BorderProperty
extends DerivedProperty<Border> {
    private final int minValue;
    private final boolean allowFormula;

    public BorderProperty(Property<String> property, int n, boolean bl) {
        super(property, Border.class);
        this.minValue = n;
        this.allowFormula = bl;
    }

    public Border getPropertyValue() {
        String string = (String)this.base.getPropertyValue();
        if (string == null && this.canBeNull()) {
            return null;
        }
        try {
            return Utils.parseBorder(string);
        }
        catch (NumberFormatException numberFormatException) {
            if (this.allowFormula) {
                return new BorderFormula(string);
            }
            throw numberFormatException;
        }
    }

    public void setPropertyValue(Border border) throws IllegalArgumentException {
        this.base.setPropertyValue((Object)Utils.toString(border, this.canBeNull()));
    }

    public int getMinValue() {
        return this.minValue;
    }

    public boolean isAllowFormula() {
        return this.allowFormula;
    }
}

