/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twlthemeeditor.properties;

import de.matthiasmann.twl.model.AbstractProperty;
import de.matthiasmann.twl.utils.ClassUtils;
import de.matthiasmann.twlthemeeditor.datamodel.Utils;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BoundProperty<T>
extends AbstractProperty<T> {
    private final Object bean;
    private final String name;
    private final Method readMethod;
    private final Method writeMethod;
    private final Class<T> type;
    private boolean gotPropertyChangeEvent;

    public BoundProperty(Object object, String string, Method method, Method method2, Class<T> clazz) {
        Object object2;
        this.bean = object;
        this.name = string;
        this.readMethod = method;
        this.writeMethod = method2;
        this.type = clazz;
        if (clazz.isPrimitive()) {
            throw new IllegalArgumentException("Call with wrapper class");
        }
        if (method == null) {
            throw new NullPointerException("readMethod");
        }
        if (method.getParameterTypes().length > 0) {
            throw new IllegalArgumentException("readMethod has parameters");
        }
        if (!clazz.isAssignableFrom(ClassUtils.mapPrimitiveToWrapper(method.getReturnType()))) {
            throw new IllegalArgumentException("Incompatible return type of readMethod");
        }
        if (!(method2 == null || ((Class<?>[])(object2 = method2.getParameterTypes())).length == 1 && ClassUtils.mapPrimitiveToWrapper(object2[0]).isAssignableFrom(clazz))) {
            throw new IllegalArgumentException("Incompatible parameter type of writeMethod");
        }
        try {
            object2 = object.getClass().getMethod("addPropertyChangeListener", String.class, PropertyChangeListener.class);
            ((Method)object2).invoke(object, string, new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    BoundProperty.this.propertyChanged();
                }
            });
        }
        catch (Exception exception) {
            Logger.getLogger(BoundProperty.class.getName()).log(Level.SEVERE, "Can't bind property: " + string, exception);
        }
    }

    public BoundProperty(Object object, String string, Class<T> clazz) {
        this(object, string, BoundProperty.getReadMethod(object, string, clazz), BoundProperty.getWriteMethod(object, string, clazz), clazz);
    }

    public BoundProperty(Object object, String string, String string2, Class<T> clazz) {
        this(object, string, BoundProperty.getReadMethod(object, string2, clazz), BoundProperty.getWriteMethod(object, string2, clazz), clazz);
    }

    public BoundProperty(Object object, PropertyDescriptor propertyDescriptor, Class<T> clazz) {
        this(object, propertyDescriptor.getName(), propertyDescriptor.getReadMethod(), propertyDescriptor.getWriteMethod(), clazz);
    }

    public boolean canBeNull() {
        return false;
    }

    public String getName() {
        return this.name;
    }

    public Class<T> getType() {
        return this.type;
    }

    public boolean isReadOnly() {
        return this.writeMethod == null;
    }

    public T getPropertyValue() {
        try {
            return this.type.cast(this.readMethod.invoke(this.bean, new Object[0]));
        }
        catch (Exception exception) {
            throw new RuntimeException("Can't invoke readMethod", exception);
        }
    }

    public void setPropertyValue(T t) throws IllegalArgumentException {
        if (this.writeMethod == null) {
            throw new UnsupportedOperationException("read only");
        }
        try {
            this.gotPropertyChangeEvent = false;
            this.writeMethod.invoke(this.bean, t);
            if (!this.gotPropertyChangeEvent) {
                this.propertyChanged();
            }
        }
        catch (Exception exception) {
            Logger.getLogger(BoundProperty.class.getName()).log(Level.SEVERE, "Can't invoke writeMethod", exception);
        }
    }

    protected void propertyChanged() {
        this.gotPropertyChangeEvent = true;
        this.fireValueChangedCallback();
    }

    public static Method getReadMethod(Object object, String string, Class<?> clazz) {
        try {
            String string2 = clazz == Boolean.class ? "is" : "get";
            return object.getClass().getMethod(string2.concat(Utils.capitalize(string)), new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
        catch (SecurityException securityException) {
            return null;
        }
    }

    public static Method getWriteMethod(Object object, String string, Class<?> clazz) {
        try {
            return object.getClass().getMethod("set".concat(Utils.capitalize(string)), clazz);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
        catch (SecurityException securityException) {
            return null;
        }
    }
}

