/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twlthemeeditor.properties;

import de.matthiasmann.twl.model.FloatModel;
import de.matthiasmann.twl.model.Property;
import de.matthiasmann.twlthemeeditor.properties.DerivedProperty;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FloatProperty
extends DerivedProperty<Float>
implements FloatModel {
    private final float minValue;
    private final float maxValue;
    private final float defaultValue;
    private float prevValue;

    public FloatProperty(Property<String> property, float f, float f2, float f3) {
        super(property, Float.class);
        this.minValue = f;
        this.maxValue = f2;
        this.defaultValue = f3;
        this.prevValue = f3;
    }

    public Float getPropertyValue() {
        String string = (String)this.base.getPropertyValue();
        if (string == null && this.canBeNull()) {
            return null;
        }
        try {
            return Float.valueOf(string);
        }
        catch (Throwable throwable) {
            Logger.getLogger(FloatProperty.class.getName()).log(Level.SEVERE, "Can't parse value of propterty '" + this.getName() + "': " + string, throwable);
            return Float.valueOf(this.prevValue);
        }
    }

    public void setPropertyValue(Float f) throws IllegalArgumentException {
        if (this.canBeNull() && (f == null || f.floatValue() == this.defaultValue)) {
            if (f != null) {
                this.prevValue = this.defaultValue;
            }
            this.base.setPropertyValue(null);
        } else {
            this.prevValue = f.floatValue();
            this.base.setPropertyValue((Object)f.toString());
        }
    }

    public float getMaxValue() {
        return this.maxValue;
    }

    public float getMinValue() {
        return this.minValue;
    }

    public float getDefaultValue() {
        return this.defaultValue;
    }

    public void setValue(float f) {
        this.setPropertyValue(Float.valueOf(f));
    }

    public float getValue() {
        Float f = this.getPropertyValue();
        return f != null ? f.floatValue() : this.prevValue;
    }
}

