/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twlthemeeditor.properties;

import de.matthiasmann.twl.model.IntegerModel;
import de.matthiasmann.twl.model.Property;
import de.matthiasmann.twlthemeeditor.properties.DerivedProperty;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntegerProperty
extends DerivedProperty<Integer>
implements IntegerModel {
    private final int minValue;
    private final int maxValue;
    private int prevValue;

    public IntegerProperty(Property<String> property, int n, int n2) {
        super(property, Integer.class);
        this.minValue = n;
        this.maxValue = n2;
        this.prevValue = n < 0 && n2 >= 0 ? 0 : n;
    }

    public Integer getPropertyValue() {
        String string = (String)this.base.getPropertyValue();
        if (string == null && this.canBeNull()) {
            return null;
        }
        try {
            if (string.startsWith("0x")) {
                return Integer.valueOf(string.substring(2), 16);
            }
            return Integer.valueOf(string, 10);
        }
        catch (Throwable throwable) {
            Logger.getLogger(IntegerProperty.class.getName()).log(Level.SEVERE, "Can't parse value of propterty '" + this.getName() + "': " + string, throwable);
            return this.prevValue;
        }
    }

    public void setPropertyValue(Integer n) throws IllegalArgumentException {
        if (this.canBeNull() && n == null) {
            this.base.setPropertyValue(null);
        } else {
            this.prevValue = n;
            this.base.setPropertyValue((Object)n.toString());
        }
    }

    public int getMaxValue() {
        return this.maxValue;
    }

    public int getMinValue() {
        return this.minValue;
    }

    public void setValue(int n) {
        this.setPropertyValue(n);
    }

    public int getValue() {
        Integer n = this.getPropertyValue();
        return n != null ? n : this.prevValue;
    }
}

