/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twlthemeeditor.properties;

import de.matthiasmann.twl.Dimension;
import de.matthiasmann.twl.Rect;
import de.matthiasmann.twl.model.BooleanModel;
import de.matthiasmann.twl.model.IntegerModel;
import de.matthiasmann.twl.model.Property;
import de.matthiasmann.twlthemeeditor.datamodel.Utils;
import de.matthiasmann.twlthemeeditor.properties.DerivedProperty;
import de.matthiasmann.twlthemeeditor.properties.IntegerProperty;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RectProperty
implements Property<Rect> {
    private final BooleanModel wholeArea;
    private final IntegerModel baseX;
    private final IntegerModel baseY;
    private final IntegerModel baseW;
    private final IntegerModel baseH;
    private final String name;
    protected static final AbstractAction[] NO_ACTIONS = new AbstractAction[0];

    public RectProperty(Property<String> property, String string) {
        this.wholeArea = new WholeAreaModel(property);
        this.baseX = new RectPartProperty((Property)property, 0){

            public void setValue(int n) {
                if (this.getValue() != n) {
                    super.setValue(n);
                    RectProperty.this.baseW.setValue(Math.min(RectProperty.this.getLimit().getX() - n, RectProperty.this.baseW.getValue()));
                }
            }
        };
        this.baseY = new RectPartProperty((Property)property, 1){

            public void setValue(int n) {
                if (this.getValue() != n) {
                    super.setValue(n);
                    RectProperty.this.baseH.setValue(Math.min(RectProperty.this.getLimit().getY() - n, RectProperty.this.baseH.getValue()));
                }
            }
        };
        this.baseW = new RectPartProperty((Property)property, 2){

            public void setValue(int n) {
                if (this.getValue() != n) {
                    super.setValue(n);
                    RectProperty.this.baseX.setValue(Math.min(RectProperty.this.getLimit().getX() - n, RectProperty.this.baseX.getValue()));
                }
            }
        };
        this.baseH = new RectPartProperty((Property)property, 3){

            public void setValue(int n) {
                if (this.getValue() != n) {
                    super.setValue(n);
                    RectProperty.this.baseY.setValue(Math.min(RectProperty.this.getLimit().getY() - n, RectProperty.this.baseY.getValue()));
                }
            }
        };
        this.name = string;
    }

    public RectProperty(IntegerModel integerModel, IntegerModel integerModel2, IntegerModel integerModel3, IntegerModel integerModel4, String string) {
        this.wholeArea = null;
        this.baseX = integerModel;
        this.baseY = integerModel2;
        this.baseW = integerModel3;
        this.baseH = integerModel4;
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public Class<Rect> getType() {
        return Rect.class;
    }

    public boolean canBeNull() {
        return false;
    }

    public boolean isReadOnly() {
        return false;
    }

    public Rect getPropertyValue() {
        return new Rect(this.baseX.getValue(), this.baseY.getValue(), this.baseW.getValue(), this.baseH.getValue());
    }

    public void setPropertyValue(Rect rect) throws IllegalArgumentException {
        this.baseX.setValue(rect.getX());
        this.baseY.setValue(rect.getY());
        this.baseW.setValue(rect.getWidth());
        this.baseH.setValue(rect.getHeight());
    }

    public void addValueChangedCallback(Runnable runnable) {
        this.baseX.addCallback(runnable);
        this.baseY.addCallback(runnable);
        this.baseW.addCallback(runnable);
        this.baseH.addCallback(runnable);
    }

    public void removeValueChangedCallback(Runnable runnable) {
        this.baseX.removeCallback(runnable);
        this.baseY.removeCallback(runnable);
        this.baseW.removeCallback(runnable);
        this.baseH.removeCallback(runnable);
    }

    public BooleanModel getWholeAreaModel() {
        return this.wholeArea;
    }

    public AbstractAction[] getActions() {
        return NO_ACTIONS;
    }

    public IntegerModel getXProperty() {
        return this.baseX;
    }

    public IntegerModel getYProperty() {
        return this.baseY;
    }

    public IntegerModel getWidthProperty() {
        return this.baseW;
    }

    public IntegerModel getHeightProperty() {
        return this.baseH;
    }

    public abstract Dimension getLimit();

    int[] parseXYWH(String string) {
        if ("*".equals(string)) {
            Dimension dimension = this.getLimit();
            return new int[]{0, 0, dimension.getX(), dimension.getY()};
        }
        return Utils.parseInts(string);
    }

    public abstract class AbstractAction
    implements Runnable {
        private final String name;
        private final String tooltip;

        public AbstractAction(String string) {
            this.name = string;
            this.tooltip = null;
        }

        public AbstractAction(String string, String string2) {
            this.name = string;
            this.tooltip = string2;
        }

        public String getName() {
            return this.name;
        }

        public String getTooltip() {
            return this.tooltip;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    abstract class RectPartProperty
    extends DerivedProperty<Integer>
    implements IntegerModel {
        private final int part;

        public RectPartProperty(Property<String> property, int n) {
            super(property, Integer.class);
            this.part = n;
        }

        public Integer getPropertyValue() {
            return this.getValue();
        }

        public void setPropertyValue(Integer n) throws IllegalArgumentException {
            this.setValue(n);
        }

        public int getMinValue() {
            return 0;
        }

        public int getMaxValue() {
            switch (this.part) {
                case 0: 
                case 2: {
                    return RectProperty.this.getLimit().getX();
                }
                case 1: 
                case 3: {
                    return RectProperty.this.getLimit().getY();
                }
            }
            throw new AssertionError();
        }

        public void setValue(int n) {
            String string = (String)this.base.getPropertyValue();
            try {
                int[] nArray = RectProperty.this.parseXYWH(string);
                nArray[this.part] = n;
                this.base.setPropertyValue((Object)Utils.toString(nArray));
            }
            catch (Throwable throwable) {
                Logger.getLogger(IntegerProperty.class.getName()).log(Level.SEVERE, "Can't parse value of propterty '" + this.getName() + "': " + string, throwable);
            }
        }

        public int getValue() {
            String string = (String)this.base.getPropertyValue();
            try {
                return RectProperty.this.parseXYWH(string)[this.part];
            }
            catch (Throwable throwable) {
                Logger.getLogger(IntegerProperty.class.getName()).log(Level.SEVERE, "Can't parse value of propterty '" + this.getName() + "': " + string, throwable);
                return 0;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class WholeAreaModel
    extends DerivedProperty<Boolean>
    implements BooleanModel {
        public WholeAreaModel(Property<String> property) {
            super(property, Boolean.class);
        }

        public boolean getValue() {
            return "*".equals(this.base.getPropertyValue());
        }

        public void setValue(boolean bl) {
            if (bl) {
                this.base.setPropertyValue((Object)"*");
            } else {
                Rect rect = RectProperty.this.getPropertyValue();
                this.base.setPropertyValue((Object)(rect.getX() + "," + rect.getY() + "," + rect.getWidth() + "," + rect.getHeight()));
            }
        }

        public Boolean getPropertyValue() {
            return this.getValue();
        }

        public void setPropertyValue(Boolean bl) throws IllegalArgumentException {
            this.setValue(bl);
        }
    }
}

