/*
 * Decompiled with CFR 0.152.
 */
package aurelienribon.ui.components;

import aurelienribon.ui.utils.PaintUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.RenderingHints;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.border.Border;

public class GroupBorder
implements Border {
    private final JLabel label = new JLabel();
    private Paint stroke = Color.GRAY;
    private Insets thickness = new Insets(1, 1, 1, 1);
    private Paint headerStroke = Color.GRAY;
    private Insets headerThickness = new Insets(1, 1, 0, 1);
    private Paint headerFill = Color.LIGHT_GRAY;
    private String title = "";
    private Icon titleIcon = null;
    private Font titleFont = null;
    private Color titleForeground = Color.BLACK;
    private Insets titleMargin = new Insets(0, 0, 0, 0);
    private int titleHorizontalAlignment = 2;
    private int titleVerticalAlignment = 0;

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        int gap;
        Graphics2D gg = (Graphics2D)g.create();
        gg.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        gg.translate(x, y);
        int hh = this.getHeaderHeight(c);
        if (this.headerFill != null && this.headerStroke != null) {
            int fx = this.headerThickness.left;
            int fy = this.headerThickness.top;
            int fw = width - this.headerThickness.left - this.headerThickness.right;
            int fh = hh - this.headerThickness.top - this.headerThickness.bottom;
            gg.setPaint(PaintUtils.buildPaint(this.headerFill, fx, fy, fw, fh));
            gg.fillRect(fx, fy, fw, fh);
        } else if (this.headerFill != null) {
            gg.setPaint(PaintUtils.buildPaint(this.headerFill, 0.0, 0.0, width, hh));
            gg.fillRect(0, 0, width, hh);
        }
        if (this.headerStroke != null) {
            gg.setPaint(PaintUtils.buildPaint(this.headerStroke, 0.0, 0.0, width, hh));
            if (this.headerThickness.top > 0) {
                gap = this.headerThickness.top / 2;
                gg.setStroke(new BasicStroke(this.headerThickness.top, 0, 0));
                gg.drawLine(0, gap, width - 1, gap);
            }
            if (this.headerThickness.left > 0) {
                gap = this.headerThickness.left / 2;
                gg.setStroke(new BasicStroke(this.headerThickness.left, 0, 0));
                gg.drawLine(gap, 0, gap, hh - 1);
            }
            if (this.headerThickness.bottom > 0) {
                gap = this.headerThickness.bottom / 2;
                gg.setStroke(new BasicStroke(this.headerThickness.bottom, 0, 0));
                gg.drawLine(0, gap + hh - 1, width - 1, gap + hh - 1);
            }
            if (this.headerThickness.right > 0) {
                gap = this.headerThickness.right / 2;
                gg.setStroke(new BasicStroke(this.headerThickness.right, 0, 0));
                gg.drawLine(gap + width - 1, 0, gap + width - 1, hh - 1);
            }
        }
        if (this.stroke != null) {
            gg.setPaint(PaintUtils.buildPaint(this.stroke, 0.0, hh, width, height - hh));
            if (this.thickness.top > 0) {
                gap = this.thickness.top / 2;
                gg.setStroke(new BasicStroke(this.thickness.top, 0, 0));
                gg.drawLine(0, hh + gap, width - 1, hh + gap);
            }
            if (this.thickness.left > 0) {
                gap = this.thickness.left / 2;
                gg.setStroke(new BasicStroke(this.thickness.left, 0, 0));
                gg.drawLine(gap, hh, gap, height - 1);
            }
            if (this.thickness.bottom > 0) {
                gap = this.thickness.bottom / 2;
                gg.setStroke(new BasicStroke(this.thickness.bottom, 0, 0));
                gg.drawLine(0, gap + height - 1, width - 1, gap + height - 1);
            }
            if (this.thickness.right > 0) {
                gap = this.thickness.right / 2;
                gg.setStroke(new BasicStroke(this.thickness.right, 0, 0));
                gg.drawLine(gap + width - 1, hh, gap + width - 1, height - 1);
            }
        }
        int labelW = width - this.titleMargin.left - this.titleMargin.right;
        int labelH = hh - this.titleMargin.top - this.titleMargin.bottom;
        if (this.headerStroke != null) {
            labelW -= this.headerThickness.left + this.headerThickness.right;
        }
        if (this.headerStroke != null) {
            labelH -= this.headerThickness.top + this.headerThickness.bottom;
        }
        if (this.headerStroke != null) {
            gg.translate(this.headerThickness.left + this.titleMargin.left, this.headerThickness.top + this.titleMargin.top);
        } else {
            gg.translate(this.titleMargin.left, this.titleMargin.top);
        }
        this.label.setSize(labelW, labelH);
        this.label.paint(gg);
        gg.dispose();
    }

    @Override
    public Insets getBorderInsets(Component c) {
        Insets insets = new Insets(this.getHeaderHeight(c), 0, 0, 0);
        if (this.stroke != null) {
            insets.top += this.thickness.top;
            insets.left += this.thickness.left;
            insets.bottom += this.thickness.bottom;
            insets.right += this.thickness.right;
        }
        return insets;
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }

    public Paint getStroke() {
        return this.stroke;
    }

    public Insets getThickness() {
        return this.thickness;
    }

    public Paint getHeaderStroke() {
        return this.headerStroke;
    }

    public Insets getHeaderThickness() {
        return this.headerThickness;
    }

    public Paint getHeaderFill() {
        return this.headerFill;
    }

    public String getTitle() {
        return this.title;
    }

    public Icon getTitleIcon() {
        return this.titleIcon;
    }

    public Font getTitleFont() {
        return this.titleFont;
    }

    public Color getTitleForeground() {
        return this.titleForeground;
    }

    public Insets getTitleMargin() {
        return this.titleMargin;
    }

    public int getTitleHorizontalAlignment() {
        return this.titleHorizontalAlignment;
    }

    public int getTitleVerticalAlignment() {
        return this.titleVerticalAlignment;
    }

    public void setStroke(Paint stroke) {
        this.stroke = stroke;
    }

    public void setThickness(Insets thickness) {
        this.thickness = thickness;
    }

    public void setHeaderStroke(Paint headerStroke) {
        this.headerStroke = headerStroke;
    }

    public void setHeaderThickness(Insets headerThickness) {
        this.headerThickness = headerThickness;
    }

    public void setHeaderFill(Paint headerFill) {
        this.headerFill = headerFill;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setTitleIcon(Icon titleIcon) {
        this.titleIcon = titleIcon;
    }

    public void setTitleFont(Font titleFont) {
        this.titleFont = titleFont;
    }

    public void setTitleForeground(Color titleForeground) {
        this.titleForeground = titleForeground;
    }

    public void setTitleMargin(Insets titleMargin) {
        this.titleMargin = titleMargin;
    }

    public void setTitleHorizontalAlignment(int titleHorizontalAlignment) {
        this.titleHorizontalAlignment = titleHorizontalAlignment;
    }

    public void setTitleVerticalAlignment(int titleVerticalAlignment) {
        this.titleVerticalAlignment = titleVerticalAlignment;
    }

    private int getHeaderHeight(Component c) {
        int h = 0;
        if (this.headerStroke != null) {
            h += this.headerThickness.top + this.headerThickness.bottom;
        }
        h += this.titleMargin.top + this.titleMargin.bottom;
        return h += this.getLabel((Component)c).getPreferredSize().height;
    }

    private JLabel getLabel(Component c) {
        this.label.setText(this.title);
        this.label.setIcon(this.titleIcon);
        this.label.setForeground(this.titleForeground != null ? this.titleForeground : c.getForeground());
        this.label.setFont(this.titleFont != null ? this.titleFont : c.getFont());
        this.label.setHorizontalAlignment(this.titleHorizontalAlignment);
        this.label.setVerticalAlignment(this.titleVerticalAlignment);
        return this.label;
    }
}

