/*
 * Decompiled with CFR 0.152.
 */
package aurelienribon.ui.components;

import aurelienribon.ui.components.ArProperties;
import aurelienribon.ui.components.TabPanelModel;
import aurelienribon.ui.css.DeclarationSet;
import aurelienribon.ui.css.DeclarationSetProcessor;
import aurelienribon.ui.css.Property;
import aurelienribon.ui.utils.PaintUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;

class TabPanelHeaderSubPanel
extends JComponent {
    private static final ImageIcon IC_CROSS1 = new ImageIcon(TabPanelHeaderSubPanel.class.getResource("ic_cross1_dark.png"));
    private static final ImageIcon IC_CROSS2 = new ImageIcon(TabPanelHeaderSubPanel.class.getResource("ic_cross2_dark.png"));
    private final TabPanelModel.TabModel model;
    private final Callback callback;
    private final JLabel descLabel = new JLabel();
    private final JLabel crossLabel = new JLabel(IC_CROSS1);
    private Paint stroke = Color.RED;
    private Paint fill = Color.RED;
    private final MouseAdapter mouseAdapter = new MouseAdapter(){

        @Override
        public void mousePressed(MouseEvent e) {
            if (SwingUtilities.isLeftMouseButton(e)) {
                if (e.getX() < TabPanelHeaderSubPanel.this.getWidth() - TabPanelHeaderSubPanel.this.crossLabel.getWidth()) {
                    TabPanelHeaderSubPanel.this.callback.selectRequested(TabPanelHeaderSubPanel.this.model);
                } else {
                    TabPanelHeaderSubPanel.this.callback.closeRequested(TabPanelHeaderSubPanel.this.model);
                }
            } else if (SwingUtilities.isMiddleMouseButton(e)) {
                TabPanelHeaderSubPanel.this.callback.closeRequested(TabPanelHeaderSubPanel.this.model);
            }
            if (e.isPopupTrigger()) {
                new PopupMenu().show(TabPanelHeaderSubPanel.this, e.getX(), e.getY());
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (e.isPopupTrigger()) {
                new PopupMenu().show(TabPanelHeaderSubPanel.this, e.getX(), e.getY());
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            if (e.getX() < TabPanelHeaderSubPanel.this.getWidth() - TabPanelHeaderSubPanel.this.crossLabel.getWidth()) {
                TabPanelHeaderSubPanel.this.crossLabel.setIcon(IC_CROSS1);
            } else {
                TabPanelHeaderSubPanel.this.crossLabel.setIcon(IC_CROSS2);
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            TabPanelHeaderSubPanel.this.crossLabel.setIcon(IC_CROSS1);
        }
    };

    public TabPanelHeaderSubPanel(TabPanelModel.TabModel model, Callback callback) {
        this.model = model;
        this.callback = callback;
        this.addMouseListener(this.mouseAdapter);
        this.addMouseMotionListener(this.mouseAdapter);
        JPanel p = new JPanel(new BorderLayout());
        p.setOpaque(false);
        p.add(Box.createHorizontalStrut(12), "West");
        p.add((Component)this.crossLabel, "Center");
        this.setLayout(new BorderLayout());
        this.add(Box.createHorizontalStrut(6), "West");
        this.add((Component)this.descLabel, "Center");
        this.add((Component)p, "East");
    }

    public TabPanelModel.TabModel getModel() {
        return this.model;
    }

    public Paint getStroke() {
        return this.stroke;
    }

    public Paint getFill() {
        return this.fill;
    }

    public void setStroke(Paint stroke) {
        this.stroke = stroke;
        this.repaint();
    }

    public void setFill(Paint fill) {
        this.fill = fill;
        this.repaint();
    }

    @Override
    protected void paintComponent(Graphics g) {
        Graphics2D gg = (Graphics2D)g.create();
        gg.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int w = this.getWidth();
        int h = this.getHeight();
        if (this.fill != null) {
            gg.setPaint(PaintUtils.buildPaint(this.fill, 0.0, 0.0, w, h));
            gg.fillRect(0, 0, w, h);
        }
        if (this.stroke != null) {
            gg.setPaint(PaintUtils.buildPaint(this.stroke, 0.0, 0.0, w, h));
            gg.drawLine(0, 0, w - 1, 0);
            gg.drawLine(0, 0, 0, h - 1);
            gg.drawLine(w - 1, 0, w - 1, h - 1);
        }
        this.updateLabels();
        gg.dispose();
    }

    private void updateLabels() {
        this.descLabel.setForeground(this.getForeground());
        this.descLabel.setFont(this.getFont());
        this.descLabel.setText(this.model.title);
        this.descLabel.setIcon(this.model.icon);
        this.descLabel.setIconTextGap(6);
        this.crossLabel.setVisible(this.model.closable);
    }

    public static class Processor
    implements DeclarationSetProcessor<TabPanelHeaderSubPanel>,
    ArProperties {
        @Override
        public void process(TabPanelHeaderSubPanel target, DeclarationSet rs) {
            Property p = stroke;
            if (rs.contains(p)) {
                target.setStroke(rs.getValue(p, Paint.class));
            }
            if (rs.contains(p = fill)) {
                target.setFill(rs.getValue(p, Paint.class));
            }
        }
    }

    private class PopupMenu
    extends JPopupMenu {
        private final Action closeAction = new AbstractAction("Close"){

            @Override
            public void actionPerformed(ActionEvent e) {
                TabPanelHeaderSubPanel.this.callback.closeRequested(TabPanelHeaderSubPanel.this.model);
            }
        };
        private final Action closeAllAction = new AbstractAction("Close all"){

            @Override
            public void actionPerformed(ActionEvent e) {
                TabPanelHeaderSubPanel.this.callback.closeAllRequested();
            }
        };
        private final Action closeOthersAction = new AbstractAction("Close others"){

            @Override
            public void actionPerformed(ActionEvent e) {
                TabPanelHeaderSubPanel.this.callback.closeOthersRequested(TabPanelHeaderSubPanel.this.model);
            }
        };

        public PopupMenu() {
            this.add(this.closeAction);
            this.add(this.closeAllAction);
            this.add(this.closeOthersAction);
        }
    }

    public static interface Callback {
        public void selectRequested(TabPanelModel.TabModel var1);

        public void closeRequested(TabPanelModel.TabModel var1);

        public void closeAllRequested();

        public void closeOthersRequested(TabPanelModel.TabModel var1);
    }
}

