/*
 * Decompiled with CFR 0.152.
 */
package aurelienribon.ui.css;

import aurelienribon.ui.css.ChildrenAccessor;
import aurelienribon.ui.css.Container;
import aurelienribon.ui.css.DeclarationSet;
import aurelienribon.ui.css.DeclarationSetManager;
import aurelienribon.ui.css.DeclarationSetProcessor;
import aurelienribon.ui.css.Function;
import aurelienribon.ui.css.ParamConverter;
import aurelienribon.ui.css.Parameterized;
import aurelienribon.ui.css.Property;
import aurelienribon.ui.css.Rule;
import aurelienribon.ui.css.Selector;
import aurelienribon.ui.css.StyleException;
import aurelienribon.ui.css.antlr.CssLexer;
import aurelienribon.ui.css.antlr.CssParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;

public class Style {
    private static final Map<String, Property> registeredProperties = new LinkedHashMap<String, Property>();
    private static final Map<String, Function> registeredFunctions = new LinkedHashMap<String, Function>();
    private static final Map<Class<?>, List<DeclarationSetProcessor<?>>> registeredProcessors = new LinkedHashMap();
    private static final Map<Object, List<String>> registeredTargets = new LinkedHashMap<Object, List<String>>();
    private static final Map<Class<?>, ChildrenAccessor<?>> registeredChildrenAccessors = new HashMap();
    private static final Map<Class<?>, DeclarationSetManager<?>> registeredDeclarationSetManagers = new HashMap();
    private static ParamConverter converter;
    private static List<Selector.Atom> lastStack;
    private final String styleSheet;
    private final List<Rule> rules = new ArrayList<Rule>();

    public static void registerProperty(Property property) {
        if (registeredProperties.containsKey(property.getName())) {
            throw new RuntimeException("Property already registered");
        }
        registeredProperties.put(property.getName(), property);
    }

    public static void registerFunction(Function function) {
        if (registeredFunctions.containsKey(function.getName())) {
            throw new RuntimeException("Function already registered");
        }
        registeredFunctions.put(function.getName(), function);
    }

    public static void registerProcessor(Class<?> clazz, DeclarationSetProcessor<?> processor) {
        List<DeclarationSetProcessor<?>> list = registeredProcessors.get(clazz);
        if (list == null) {
            list = new ArrayList();
            registeredProcessors.put(clazz, list);
        }
        if (!list.contains(processor)) {
            list.add(processor);
        }
    }

    public static void registerCssClasses(Object target, String ... classes) {
        if (!registeredTargets.containsKey(target)) {
            registeredTargets.put(target, new ArrayList());
        }
        for (String name : classes) {
            if (name.startsWith("#")) {
                for (List<String> names : registeredTargets.values()) {
                    if (!names.contains(name)) continue;
                    throw new RuntimeException("ID " + name + " has already been registered.");
                }
            }
            if (name.startsWith("#") || name.startsWith(".")) {
                String clazz = name.substring(1);
                List<String> regClasses = registeredTargets.get(target);
                if (regClasses.contains(clazz)) continue;
                regClasses.add(clazz);
                continue;
            }
            throw new RuntimeException("Names have to start with a '.' for classes or a '#' for ids");
        }
    }

    public static void registerChildrenAccessor(Class<?> parentClass, ChildrenAccessor<?> accessor) {
        registeredChildrenAccessors.put(parentClass, accessor);
    }

    public static void registerDeclarationSetManager(Class<?> parentClass, DeclarationSetManager<?> manager) {
        registeredDeclarationSetManagers.put(parentClass, manager);
    }

    public static void unregisterCssClasses(Object target, String ... classes) {
        List<String> regClasses = registeredTargets.get(target);
        if (regClasses != null) {
            return;
        }
        for (String clazz : classes) {
            if (!clazz.startsWith("#") && !clazz.startsWith(".")) {
                throw new RuntimeException("Names have to start with a '.' for classes or a '#' for ids");
            }
            regClasses.remove(clazz);
        }
    }

    public static void unregisterAllCssClasses(Object target) {
        registeredTargets.remove(target);
    }

    public static void apply(Object target, Style style) {
        Style.applyImpl(target, style, new ArrayList<Selector.Atom>());
    }

    public static void apply(Object target, Style style, List<Selector.Atom> stack) {
        Style.applyImpl(target, style, stack);
    }

    public static void apply(Object target, DeclarationSet ds) {
        for (Class<?> clazz : registeredProcessors.keySet()) {
            if (!clazz.isInstance(target)) continue;
            List<DeclarationSetProcessor<?>> processors = registeredProcessors.get(clazz);
            for (DeclarationSetProcessor<?> proc : processors) {
                proc.process(target, ds);
            }
        }
    }

    public static void setParamConverter(ParamConverter converter) {
        Style.converter = converter;
    }

    public static List<String> getRegisteredPropertiesNames() {
        return Collections.unmodifiableList(new ArrayList<String>(registeredProperties.keySet()));
    }

    public static Property getRegisteredProperty(String name) {
        return registeredProperties.get(name);
    }

    public static List<String> getRegisteredFunctionsNames() {
        return Collections.unmodifiableList(new ArrayList<String>(registeredFunctions.keySet()));
    }

    public static Function getRegisteredFunction(String name) {
        return registeredFunctions.get(name);
    }

    public static List<Object> getRegisteredTargets() {
        return Collections.unmodifiableList(new ArrayList<Object>(registeredTargets.keySet()));
    }

    public static List<String> getRegisteredTargetClassNames(Object target) {
        List<String> classes = registeredTargets.get(target);
        if (classes != null) {
            return classes;
        }
        return new ArrayList<String>();
    }

    public static String getPropertiesManual() {
        return Style.generatePropertiesManual();
    }

    public static String getFunctionsManual() {
        return Style.generateFunctionsManual();
    }

    public static List<Selector.Atom> getLastStack() {
        return lastStack;
    }

    public Style(URL styleSheetUrl) {
        this.styleSheet = this.getStyleSheet(styleSheetUrl);
        this.parse(this.styleSheet);
    }

    public Style(String styleSheet) {
        this.styleSheet = styleSheet;
        this.parse(styleSheet);
    }

    public String getStyleSheet() {
        return this.styleSheet;
    }

    public List<Rule> getRules() {
        return Collections.unmodifiableList(this.rules);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getStyleSheet(URL styleSheetUrl) {
        if (styleSheetUrl == null) {
            throw new NullPointerException("styleSheetUrl");
        }
        BufferedReader reader = null;
        try {
            int len;
            reader = new BufferedReader(new InputStreamReader(styleSheetUrl.openStream()));
            StringBuilder sb = new StringBuilder();
            char[] buffer = new char[4096];
            while ((len = reader.read(buffer)) > -1) {
                sb.append(buffer, 0, len);
            }
            String string = sb.toString();
            return string;
        }
        catch (IOException ex) {
            String string = null;
            return string;
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException ex) {}
        }
    }

    private void parse(String styleSheet) throws StyleException {
        ANTLRStringStream cs = new ANTLRStringStream(styleSheet);
        CssLexer lexer = new CssLexer(cs);
        CommonTokenStream tokens = new CommonTokenStream();
        tokens.setTokenSource(lexer);
        CssParser parser = new CssParser(tokens);
        try {
            parser.stylesheet();
        }
        catch (RecognitionException ex) {
            throw new StyleException(ex.getMessage());
        }
        for (CssParser.Rule parserRule : parser.rules) {
            ArrayList<Property> properties = new ArrayList<Property>();
            HashMap<Property, List<Object>> propertiesValues = new HashMap<Property, List<Object>>();
            for (String name : parserRule.declarations.keySet()) {
                Property property = registeredProperties.get(name);
                if (property == null) {
                    throw StyleException.forProperty(name);
                }
                List<Object> params = parserRule.declarations.get(name);
                if (!this.checkParams(property, params)) {
                    throw StyleException.forPropertyParams(property);
                }
                properties.add(property);
                propertiesValues.put(property, params);
            }
            for (CssParser.Selector rawSelector : parserRule.selectors) {
                Selector selector = new Selector(rawSelector.str);
                DeclarationSet ds = new DeclarationSet(this, properties, propertiesValues);
                this.rules.add(new Rule(selector, ds));
            }
        }
    }

    private boolean checkParams(Parameterized call, List<Object> params) {
        boolean valid = false;
        for (Class[] classes : call.getParams()) {
            if (!this.isMatch(params, classes)) continue;
            valid = true;
            break;
        }
        return valid;
    }

    private boolean isMatch(List<Object> params, Class[] classes) {
        if (params.size() != classes.length) {
            return false;
        }
        for (int i = 0; i < params.size(); ++i) {
            Object param = params.get(i);
            Class<?> paramClass = this.getParamClass(param);
            if (param == null || classes[i].isAssignableFrom(paramClass)) continue;
            return false;
        }
        return true;
    }

    private Class<?> getParamClass(Object param) {
        if (param == null) {
            return null;
        }
        if (param instanceof CssParser.Function) {
            CssParser.Function parserFunction = (CssParser.Function)param;
            Function function = registeredFunctions.get(parserFunction.name);
            if (function == null) {
                throw StyleException.forFunction(parserFunction.name);
            }
            List<Object> functionParams = parserFunction.params;
            if (!this.checkParams(function, functionParams)) {
                throw StyleException.forFunctionParams(function);
            }
            return function.getReturn();
        }
        if (param instanceof CssParser.Color && converter != null) {
            return converter.getColorClass();
        }
        return param.getClass();
    }

    private static void applyImpl(Object target, Style style, List<Selector.Atom> stack) {
        block8: {
            block7: {
                Map<String, DeclarationSet> dss = DeclarationSet.dss(style, target, stack);
                for (DeclarationSet ds : dss.values()) {
                    for (Property property : ds.getProperties()) {
                        for (int i = 0; i < ds.getValue(property).size(); ++i) {
                            Object param = ds.getValue(property).get(i);
                            ds.replaceValueParam(property, i, Style.evaluateParam(param));
                        }
                    }
                }
                Selector.Atom atom = new Selector.Atom(target.getClass(), Style.getRegisteredTargetClassNames(target));
                stack = new ArrayList<Selector.Atom>(stack);
                stack.add(atom);
                lastStack = Collections.unmodifiableList(stack);
                for (Class<?> clazz : registeredDeclarationSetManagers.keySet()) {
                    if (!clazz.isInstance(target)) continue;
                    DeclarationSetManager<?> manager = registeredDeclarationSetManagers.get(clazz);
                    manager.manage(target, dss);
                }
                if (!(target instanceof Container)) break block7;
                Container parent = (Container)target;
                if (parent.getChildren() == null) break block8;
                for (Object child : parent.getChildren()) {
                    Style.apply(child, style, stack);
                }
                break block8;
            }
            for (Class<?> clazz : registeredChildrenAccessors.keySet()) {
                ChildrenAccessor<?> accessor;
                if (!clazz.isInstance(target) || (accessor = registeredChildrenAccessors.get(clazz)).getChildren(target) == null) continue;
                for (Object child : accessor.getChildren(target)) {
                    Style.apply(child, style, stack);
                }
            }
        }
    }

    private static Object evaluateParam(Object param) throws StyleException {
        if (param instanceof CssParser.Color) {
            CssParser.Color c = (CssParser.Color)param;
            if (converter != null) {
                return converter.convertColor(Style.parseColor(c.str));
            }
        }
        if (param instanceof CssParser.Function) {
            CssParser.Function parserFunction = (CssParser.Function)param;
            Function function = registeredFunctions.get(parserFunction.name);
            ArrayList<Object> params = new ArrayList<Object>(parserFunction.params);
            for (int i = 0; i < params.size(); ++i) {
                params.set(i, Style.evaluateParam(params.get(i)));
            }
            return function.process(params);
        }
        return param;
    }

    private static String generatePropertiesManual() {
        String str = "";
        for (Property property : registeredProperties.values()) {
            str = str + property.getName() + "\n";
            for (int i = 0; i < property.getParams().length; ++i) {
                str = str + "    ";
                for (int ii = 0; ii < property.getParams()[i].length; ++ii) {
                    String clazz = property.getParams()[i][ii].getSimpleName();
                    String name = property.getParamsNames()[i][ii];
                    if (ii > 0) {
                        str = str + ", ";
                    }
                    str = str + Style.prettify(clazz) + " " + name;
                }
                str = str + "\n";
            }
            str = str + "\n";
        }
        return str.trim();
    }

    private static String generateFunctionsManual() {
        String str = "";
        for (Function function : registeredFunctions.values()) {
            str = str + function.getName() + Style.getReturnStatement(function) + "\n";
            for (int i = 0; i < function.getParams().length; ++i) {
                str = str + "    ";
                for (int ii = 0; ii < function.getParams()[i].length; ++ii) {
                    String clazz = function.getParams()[i][ii].getSimpleName();
                    String name = function.getParamsNames()[i][ii];
                    if (ii > 0) {
                        str = str + ", ";
                    }
                    str = str + Style.prettify(clazz) + " " + name;
                }
                str = str + "\n";
            }
            str = str + "\n";
        }
        return str.trim();
    }

    private static String prettify(String clazz) {
        clazz = clazz.replace("Integer", "int");
        clazz = clazz.replace("Float", "float");
        clazz = clazz.replace("Number", "float");
        clazz = clazz.replace("Boolean", "boolean");
        return clazz;
    }

    private static String getReturnStatement(Function function) {
        return " [returns " + Style.prettify(function.getReturn().getSimpleName()) + "]";
    }

    private static int parseColor(String s) {
        int incr = s.length() == 9 || s.length() == 7 ? 2 : 1;
        boolean alpha = s.length() == 9 || s.length() == 5;
        int i = 1;
        int a = alpha ? Style.hex(s.substring(i, i += incr)) : 255;
        int r = Style.hex(s.substring(i, i += incr));
        int g = Style.hex(s.substring(i, i += incr));
        int b = Style.hex(s.substring(i, i += incr));
        return a << 24 | r << 16 | g << 8 | b;
    }

    private static int hex(String s) {
        if (s.length() == 1) {
            s = s.concat(s);
        }
        return Integer.parseInt(s, 16);
    }
}

