/*
 * Decompiled with CFR 0.152.
 */
package aurelienribon.ui.css.swing;

import aurelienribon.ui.css.DeclarationSet;
import aurelienribon.ui.css.DeclarationSetManager;
import aurelienribon.ui.css.Style;
import java.awt.Component;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.EventListener;
import java.util.LinkedHashMap;
import java.util.Map;

public class SwingDeclarationSetManager
implements DeclarationSetManager<Component> {
    @Override
    public void manage(Component target, Map<String, DeclarationSet> dss) {
        this.clearListeners(target);
        if (dss.isEmpty()) {
            return;
        }
        if (dss.containsKey("") && dss.size() > 1 || !dss.containsKey("") && !dss.isEmpty()) {
            TargetManager.manage(target, dss);
        } else if (dss.containsKey("")) {
            Style.apply((Object)target, dss.get(""));
        }
    }

    private void clearListeners(Component target) {
        EventListener lst;
        int i;
        for (i = target.getMouseListeners().length - 1; i >= 0; --i) {
            lst = target.getMouseListeners()[i];
            if (lst instanceof TargetManager.HoverListener) {
                target.removeMouseListener((MouseListener)lst);
            }
            if (!(lst instanceof TargetManager.ActiveListener)) continue;
            target.removeMouseListener((MouseListener)lst);
        }
        for (i = target.getFocusListeners().length - 1; i >= 0; --i) {
            lst = target.getFocusListeners()[i];
            if (!(lst instanceof TargetManager.FocusListener)) continue;
            target.removeFocusListener((FocusListener)lst);
        }
        for (i = target.getPropertyChangeListeners().length - 1; i >= 0; --i) {
            lst = target.getPropertyChangeListeners()[i];
            if (!(lst instanceof TargetManager.PropertyListener)) continue;
            target.removePropertyChangeListener((PropertyChangeListener)lst);
        }
    }

    public static class TargetManager {
        private final Component target;
        private final Map<String, DeclarationSet> dss;
        private final Map<String, Boolean> states;

        public static void manage(Component target, Map<String, DeclarationSet> dss) {
            TargetManager tm = new TargetManager(target, dss);
            tm.apply();
        }

        private TargetManager(Component target, Map<String, DeclarationSet> dss) {
            this.target = target;
            this.dss = dss;
            this.states = new LinkedHashMap<String, Boolean>(dss.size());
            for (String pseudoClass : dss.keySet()) {
                if (!pseudoClass.equals(":disabled")) {
                    this.states.put(pseudoClass, Boolean.FALSE);
                }
                if (pseudoClass.equals(":focus")) {
                    this.states.put(pseudoClass, target.isFocusOwner());
                }
                if (pseudoClass.equals(":hover")) {
                    target.addMouseListener(new HoverListener());
                    continue;
                }
                if (pseudoClass.equals(":active")) {
                    target.addMouseListener(new ActiveListener());
                    continue;
                }
                if (pseudoClass.equals(":focus")) {
                    target.addFocusListener(new FocusListener());
                    continue;
                }
                if (pseudoClass.equals(":disabled")) {
                    target.addPropertyChangeListener("enabled", new DisabledListener());
                    continue;
                }
                if (pseudoClass.equals("")) continue;
                assert (pseudoClass.startsWith(":"));
                assert (pseudoClass.length() > 1);
                String prop = pseudoClass.substring(1);
                target.addPropertyChangeListener(prop, new PropertyListener(pseudoClass));
            }
        }

        private void apply() {
            if (this.dss.containsKey("")) {
                Style.apply((Object)this.target, this.dss.get(""));
            }
            if (this.target.isEnabled()) {
                for (String pseudoClass : this.states.keySet()) {
                    if (!this.states.get(pseudoClass).booleanValue()) continue;
                    Style.apply((Object)this.target, this.dss.get(pseudoClass));
                }
            } else if (this.dss.containsKey(":disabled")) {
                Style.apply((Object)this.target, this.dss.get(":disabled"));
            }
        }

        public class PropertyListener
        implements PropertyChangeListener {
            private final String pseudoClass;

            public PropertyListener(String pseudoClass) {
                this.pseudoClass = pseudoClass;
            }

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                TargetManager.this.states.put(this.pseudoClass, (Boolean)e.getNewValue());
                TargetManager.this.apply();
            }
        }

        public class DisabledListener
        implements PropertyChangeListener {
            @Override
            public void propertyChange(PropertyChangeEvent e) {
                TargetManager.this.apply();
            }
        }

        public class FocusListener
        extends FocusAdapter {
            @Override
            public void focusGained(FocusEvent e) {
                TargetManager.this.states.put(":focus", Boolean.TRUE);
                TargetManager.this.apply();
            }

            @Override
            public void focusLost(FocusEvent e) {
                TargetManager.this.states.put(":focus", Boolean.FALSE);
                TargetManager.this.apply();
            }
        }

        public class ActiveListener
        extends MouseAdapter {
            @Override
            public void mousePressed(MouseEvent e) {
                TargetManager.this.states.put(":active", Boolean.TRUE);
                TargetManager.this.apply();
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                TargetManager.this.states.put(":active", Boolean.FALSE);
                TargetManager.this.apply();
            }
        }

        public class HoverListener
        extends MouseAdapter {
            @Override
            public void mouseEntered(MouseEvent e) {
                TargetManager.this.states.put(":hover", Boolean.TRUE);
                TargetManager.this.apply();
            }

            @Override
            public void mouseExited(MouseEvent e) {
                TargetManager.this.states.put(":hover", Boolean.FALSE);
                TargetManager.this.apply();
            }
        }
    }
}

