/*
 * Decompiled with CFR 0.152.
 */
package org.xmlpull.mxp1;

import java.io.Reader;
import org.xmlpull.mxp1.MXParser;
import org.xmlpull.v1.XmlPullParserException;

public class MXParserCachingStrings
extends MXParser
implements Cloneable {
    protected static final boolean CACHE_STATISTICS = false;
    protected static final boolean TRACE_SIZING = false;
    protected static final int INITIAL_CAPACITY = 13;
    protected int cacheStatCalls;
    protected int cacheStatWalks;
    protected int cacheStatResets;
    protected int cacheStatRehash;
    protected static final int CACHE_LOAD = 77;
    protected int cacheEntriesCount;
    protected int cacheEntriesThreshold;
    protected char[][] keys;
    protected String[] values;

    public Object clone() throws CloneNotSupportedException {
        if (this.reader != null && !(this.reader instanceof Cloneable)) {
            throw new CloneNotSupportedException("reader used in parser must implement Cloneable!");
        }
        MXParserCachingStrings mXParserCachingStrings = (MXParserCachingStrings)super.clone();
        if (this.reader != null) {
            try {
                Object object = this.reader.getClass().getMethod("clone", null).invoke((Object)this.reader, null);
                mXParserCachingStrings.reader = (Reader)object;
            }
            catch (Exception exception) {
                CloneNotSupportedException cloneNotSupportedException = new CloneNotSupportedException("failed to call clone() on reader " + this.reader + ":" + exception);
                cloneNotSupportedException.initCause(exception);
                throw cloneNotSupportedException;
            }
        }
        if (this.keys != null) {
            mXParserCachingStrings.keys = (char[][])this.keys.clone();
        }
        if (this.values != null) {
            mXParserCachingStrings.values = (String[])this.values.clone();
        }
        if (this.elRawName != null) {
            mXParserCachingStrings.elRawName = this.cloneCCArr(this.elRawName);
        }
        if (this.elRawNameEnd != null) {
            mXParserCachingStrings.elRawNameEnd = (int[])this.elRawNameEnd.clone();
        }
        if (this.elRawNameLine != null) {
            mXParserCachingStrings.elRawNameLine = (int[])this.elRawNameLine.clone();
        }
        if (this.elName != null) {
            mXParserCachingStrings.elName = (String[])this.elName.clone();
        }
        if (this.elPrefix != null) {
            mXParserCachingStrings.elPrefix = (String[])this.elPrefix.clone();
        }
        if (this.elUri != null) {
            mXParserCachingStrings.elUri = (String[])this.elUri.clone();
        }
        if (this.elNamespaceCount != null) {
            mXParserCachingStrings.elNamespaceCount = (int[])this.elNamespaceCount.clone();
        }
        if (this.attributeName != null) {
            mXParserCachingStrings.attributeName = (String[])this.attributeName.clone();
        }
        if (this.attributeNameHash != null) {
            mXParserCachingStrings.attributeNameHash = (int[])this.attributeNameHash.clone();
        }
        if (this.attributePrefix != null) {
            mXParserCachingStrings.attributePrefix = (String[])this.attributePrefix.clone();
        }
        if (this.attributeUri != null) {
            mXParserCachingStrings.attributeUri = (String[])this.attributeUri.clone();
        }
        if (this.attributeValue != null) {
            mXParserCachingStrings.attributeValue = (String[])this.attributeValue.clone();
        }
        if (this.namespacePrefix != null) {
            mXParserCachingStrings.namespacePrefix = (String[])this.namespacePrefix.clone();
        }
        if (this.namespacePrefixHash != null) {
            mXParserCachingStrings.namespacePrefixHash = (int[])this.namespacePrefixHash.clone();
        }
        if (this.namespaceUri != null) {
            mXParserCachingStrings.namespaceUri = (String[])this.namespaceUri.clone();
        }
        if (this.entityName != null) {
            mXParserCachingStrings.entityName = (String[])this.entityName.clone();
        }
        if (this.entityNameBuf != null) {
            mXParserCachingStrings.entityNameBuf = this.cloneCCArr(this.entityNameBuf);
        }
        if (this.entityNameHash != null) {
            mXParserCachingStrings.entityNameHash = (int[])this.entityNameHash.clone();
        }
        if (this.entityReplacementBuf != null) {
            mXParserCachingStrings.entityReplacementBuf = this.cloneCCArr(this.entityReplacementBuf);
        }
        if (this.entityReplacement != null) {
            mXParserCachingStrings.entityReplacement = (String[])this.entityReplacement.clone();
        }
        if (this.buf != null) {
            mXParserCachingStrings.buf = (char[])this.buf.clone();
        }
        if (this.pc != null) {
            mXParserCachingStrings.pc = (char[])this.pc.clone();
        }
        if (this.charRefOneCharBuf != null) {
            mXParserCachingStrings.charRefOneCharBuf = (char[])this.charRefOneCharBuf.clone();
        }
        return mXParserCachingStrings;
    }

    private char[][] cloneCCArr(char[][] cArray) {
        char[][] cArray2 = (char[][])cArray.clone();
        for (int i = 0; i < cArray2.length; ++i) {
            if (cArray2[i] == null) continue;
            cArray2[i] = (char[])cArray2[i].clone();
        }
        return cArray2;
    }

    public MXParserCachingStrings() {
        this.allStringsInterned = true;
        this.initStringCache();
    }

    public void setFeature(String string, boolean bl) throws XmlPullParserException {
        if ("http://xmlpull.org/v1/doc/features.html#names-interned".equals(string)) {
            if (this.eventType != 0) {
                throw new XmlPullParserException("interning names feature can only be changed before parsing", this, null);
            }
            this.allStringsInterned = bl;
            if (!bl && this.keys != null) {
                this.resetStringCache();
            }
        } else {
            super.setFeature(string, bl);
        }
    }

    public boolean getFeature(String string) {
        if ("http://xmlpull.org/v1/doc/features.html#names-interned".equals(string)) {
            return this.allStringsInterned;
        }
        return super.getFeature(string);
    }

    public void finalize() {
    }

    protected String newString(char[] cArray, int n, int n2) {
        if (this.allStringsInterned) {
            return this.newStringIntern(cArray, n, n2);
        }
        return super.newString(cArray, n, n2);
    }

    protected String newStringIntern(char[] cArray, int n, int n2) {
        if (this.cacheEntriesCount >= this.cacheEntriesThreshold) {
            this.rehash();
        }
        int n3 = MXParser.fastHash(cArray, n, n2) % this.keys.length;
        char[] cArray2 = null;
        while ((cArray2 = this.keys[n3]) != null && !MXParserCachingStrings.keysAreEqual(cArray2, 0, cArray2.length, cArray, n, n2)) {
            n3 = (n3 + 1) % this.keys.length;
        }
        if (cArray2 != null) {
            return this.values[n3];
        }
        cArray2 = new char[n2];
        System.arraycopy(cArray, n, cArray2, 0, n2);
        String string = new String(cArray2).intern();
        this.keys[n3] = cArray2;
        this.values[n3] = string;
        ++this.cacheEntriesCount;
        return string;
    }

    protected void initStringCache() {
        if (this.keys == null) {
            this.cacheEntriesThreshold = 10;
            if (this.cacheEntriesThreshold >= 13) {
                throw new RuntimeException("internal error: threshold must be less than capacity: 13");
            }
            this.keys = new char[13][];
            this.values = new String[13];
            this.cacheEntriesCount = 0;
        }
    }

    protected void resetStringCache() {
        this.initStringCache();
    }

    private void rehash() {
        int n = 2 * this.keys.length + 1;
        this.cacheEntriesThreshold = n * 77 / 100;
        if (this.cacheEntriesThreshold >= n) {
            throw new RuntimeException("internal error: threshold must be less than capacity: " + n);
        }
        char[][] cArrayArray = new char[n][];
        String[] stringArray = new String[n];
        for (int i = 0; i < this.keys.length; ++i) {
            char[] cArray = this.keys[i];
            this.keys[i] = null;
            String string = this.values[i];
            this.values[i] = null;
            if (cArray == null) continue;
            int n2 = MXParser.fastHash(cArray, 0, cArray.length) % n;
            char[] cArray2 = null;
            while ((cArray2 = cArrayArray[n2]) != null) {
                if (MXParserCachingStrings.keysAreEqual(cArray2, 0, cArray2.length, cArray, 0, cArray.length)) {
                    throw new RuntimeException("internal cache error: duplicated keys: " + new String(cArray2) + " and " + new String(cArray));
                }
                n2 = (n2 + 1) % n;
            }
            cArrayArray[n2] = cArray;
            stringArray[n2] = string;
        }
        this.keys = cArrayArray;
        this.values = stringArray;
    }

    private static final boolean keysAreEqual(char[] cArray, int n, int n2, char[] cArray2, int n3, int n4) {
        if (n2 != n4) {
            return false;
        }
        for (int i = 0; i < n2; ++i) {
            if (cArray[n + i] == cArray2[n3 + i]) continue;
            return false;
        }
        return true;
    }
}

