/*
 * Decompiled with CFR 0.152.
 */
package org.xmlpull.v1.builder;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;
import org.xmlpull.v1.XmlSerializer;
import org.xmlpull.v1.builder.XmlBuilderException;
import org.xmlpull.v1.builder.XmlDocument;
import org.xmlpull.v1.builder.XmlElement;
import org.xmlpull.v1.builder.XmlNamespace;
import org.xmlpull.v1.builder.impl.XmlInfosetBuilderImpl;

public abstract class XmlInfosetBuilder {
    protected XmlPullParserFactory factory;

    public static XmlInfosetBuilder newInstance() throws XmlBuilderException {
        XmlInfosetBuilderImpl xmlInfosetBuilderImpl = new XmlInfosetBuilderImpl();
        try {
            xmlInfosetBuilderImpl.factory = XmlPullParserFactory.newInstance(System.getProperty("org.xmlpull.v1.XmlPullParserFactory"), null);
            xmlInfosetBuilderImpl.factory.setNamespaceAware(true);
        }
        catch (XmlPullParserException xmlPullParserException) {
            throw new XmlBuilderException("could not create XmlPull factory:" + xmlPullParserException, xmlPullParserException);
        }
        return xmlInfosetBuilderImpl;
    }

    public static XmlInfosetBuilder newInstance(XmlPullParserFactory xmlPullParserFactory) throws XmlBuilderException {
        if (xmlPullParserFactory == null) {
            throw new IllegalArgumentException();
        }
        XmlInfosetBuilderImpl xmlInfosetBuilderImpl = new XmlInfosetBuilderImpl();
        xmlInfosetBuilderImpl.factory = xmlPullParserFactory;
        xmlInfosetBuilderImpl.factory.setNamespaceAware(true);
        return xmlInfosetBuilderImpl;
    }

    public XmlPullParserFactory getFactory() throws XmlBuilderException {
        return this.factory;
    }

    public XmlDocument newDocument() throws XmlBuilderException {
        return this.newDocument(null, null, null);
    }

    public abstract XmlDocument newDocument(String var1, Boolean var2, String var3) throws XmlBuilderException;

    public abstract XmlElement newFragment(String var1) throws XmlBuilderException;

    public abstract XmlElement newFragment(String var1, String var2) throws XmlBuilderException;

    public abstract XmlElement newFragment(XmlNamespace var1, String var2) throws XmlBuilderException;

    public abstract XmlNamespace newNamespace(String var1) throws XmlBuilderException;

    public abstract XmlNamespace newNamespace(String var1, String var2) throws XmlBuilderException;

    public abstract XmlDocument parse(XmlPullParser var1) throws XmlBuilderException;

    public abstract Object parseItem(XmlPullParser var1) throws XmlBuilderException;

    public abstract XmlElement parseStartTag(XmlPullParser var1) throws XmlBuilderException;

    public XmlDocument parseInputStream(InputStream inputStream) throws XmlBuilderException {
        XmlPullParser xmlPullParser = null;
        try {
            xmlPullParser = this.factory.newPullParser();
            xmlPullParser.setInput(inputStream, null);
        }
        catch (XmlPullParserException xmlPullParserException) {
            throw new XmlBuilderException("could not start parsing input stream", xmlPullParserException);
        }
        return this.parse(xmlPullParser);
    }

    public XmlDocument parseInputStream(InputStream inputStream, String string) throws XmlBuilderException {
        XmlPullParser xmlPullParser = null;
        try {
            xmlPullParser = this.factory.newPullParser();
            xmlPullParser.setInput(inputStream, string);
        }
        catch (XmlPullParserException xmlPullParserException) {
            throw new XmlBuilderException("could not start parsing input stream (encoding=" + string + ")", xmlPullParserException);
        }
        return this.parse(xmlPullParser);
    }

    public XmlDocument parseReader(Reader reader) throws XmlBuilderException {
        XmlPullParser xmlPullParser = null;
        try {
            xmlPullParser = this.factory.newPullParser();
            xmlPullParser.setInput(reader);
        }
        catch (XmlPullParserException xmlPullParserException) {
            throw new XmlBuilderException("could not start parsing input from reader", xmlPullParserException);
        }
        return this.parse(xmlPullParser);
    }

    public abstract XmlDocument parseLocation(String var1) throws XmlBuilderException;

    public abstract XmlElement parseFragment(XmlPullParser var1) throws XmlBuilderException;

    public XmlElement parseFragmentFromInputStream(InputStream inputStream) throws XmlBuilderException {
        XmlPullParser xmlPullParser = null;
        try {
            xmlPullParser = this.factory.newPullParser();
            xmlPullParser.setInput(inputStream, null);
            try {
                xmlPullParser.nextTag();
            }
            catch (IOException iOException) {
                throw new XmlBuilderException("IO error when starting to parse input stream", iOException);
            }
        }
        catch (XmlPullParserException xmlPullParserException) {
            throw new XmlBuilderException("could not start parsing input stream", xmlPullParserException);
        }
        return this.parseFragment(xmlPullParser);
    }

    public XmlElement parseFragementFromInputStream(InputStream inputStream, String string) throws XmlBuilderException {
        XmlPullParser xmlPullParser = null;
        try {
            xmlPullParser = this.factory.newPullParser();
            xmlPullParser.setInput(inputStream, string);
            try {
                xmlPullParser.nextTag();
            }
            catch (IOException iOException) {
                throw new XmlBuilderException("IO error when starting to parse input stream (encoding=" + string + ")", iOException);
            }
        }
        catch (XmlPullParserException xmlPullParserException) {
            throw new XmlBuilderException("could not start parsing input stream (encoding=" + string + ")", xmlPullParserException);
        }
        return this.parseFragment(xmlPullParser);
    }

    public XmlElement parseFragmentFromReader(Reader reader) throws XmlBuilderException {
        XmlPullParser xmlPullParser = null;
        try {
            xmlPullParser = this.factory.newPullParser();
            xmlPullParser.setInput(reader);
            try {
                xmlPullParser.nextTag();
            }
            catch (IOException iOException) {
                throw new XmlBuilderException("IO error when starting to parse from reader", iOException);
            }
        }
        catch (XmlPullParserException xmlPullParserException) {
            throw new XmlBuilderException("could not start parsing input from reader", xmlPullParserException);
        }
        return this.parseFragment(xmlPullParser);
    }

    public void skipSubTree(XmlPullParser xmlPullParser) throws XmlBuilderException {
        try {
            xmlPullParser.require(2, null, null);
            int n = 1;
            while (n > 0) {
                int n2 = xmlPullParser.next();
                if (n2 == 3) {
                    --n;
                    continue;
                }
                if (n2 != 2) continue;
                ++n;
            }
        }
        catch (XmlPullParserException xmlPullParserException) {
            throw new XmlBuilderException("could not skip subtree", xmlPullParserException);
        }
        catch (IOException iOException) {
            throw new XmlBuilderException("IO error when skipping subtree", iOException);
        }
    }

    public abstract void serializeStartTag(XmlElement var1, XmlSerializer var2) throws XmlBuilderException;

    public abstract void serializeEndTag(XmlElement var1, XmlSerializer var2) throws XmlBuilderException;

    public abstract void serialize(Object var1, XmlSerializer var2) throws XmlBuilderException;

    public abstract void serializeItem(Object var1, XmlSerializer var2) throws XmlBuilderException;

    public void serializeToOutputStream(Object object, OutputStream outputStream) throws XmlBuilderException {
        this.serializeToOutputStream(object, outputStream, "UTF8");
    }

    public void serializeToOutputStream(Object object, OutputStream outputStream, String string) throws XmlBuilderException {
        XmlSerializer xmlSerializer = null;
        try {
            xmlSerializer = this.factory.newSerializer();
            xmlSerializer.setOutput(outputStream, string);
        }
        catch (Exception exception) {
            throw new XmlBuilderException("could not serialize node to output stream (encoding=" + string + ")", exception);
        }
        this.serialize(object, xmlSerializer);
        try {
            xmlSerializer.flush();
        }
        catch (IOException iOException) {
            throw new XmlBuilderException("could not flush output", iOException);
        }
    }

    public void serializeToWriter(Object object, Writer writer) throws XmlBuilderException {
        XmlSerializer xmlSerializer = null;
        try {
            xmlSerializer = this.factory.newSerializer();
            xmlSerializer.setOutput(writer);
        }
        catch (Exception exception) {
            throw new XmlBuilderException("could not serialize node to writer", exception);
        }
        this.serialize(object, xmlSerializer);
        try {
            xmlSerializer.flush();
        }
        catch (IOException iOException) {
            throw new XmlBuilderException("could not flush output", iOException);
        }
    }

    public String serializeToString(Object object) throws XmlBuilderException {
        StringWriter stringWriter = new StringWriter();
        this.serializeToWriter(object, stringWriter);
        return stringWriter.toString();
    }
}

