/*
 * Decompiled with CFR 0.152.
 */
package org.xmlpull.v1.wrapper.classic;

import java.io.IOException;
import java.io.StringReader;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;
import org.xmlpull.v1.wrapper.XmlPullParserWrapper;
import org.xmlpull.v1.wrapper.XmlPullWrapperFactory;
import org.xmlpull.v1.wrapper.XmlSerializerWrapper;
import org.xmlpull.v1.wrapper.classic.XmlSerializerDelegate;

public class StaticXmlSerializerWrapper
extends XmlSerializerDelegate
implements XmlSerializerWrapper {
    private static final String PROPERTY_XMLDECL_STANDALONE = "http://xmlpull.org/v1/doc/features.html#xmldecl-standalone";
    private static final boolean TRACE_SIZING = false;
    protected String currentNs;
    protected XmlPullWrapperFactory wf;
    protected XmlPullParserWrapper fragmentParser;
    protected int namespaceEnd = 0;
    protected String[] namespacePrefix = new String[8];
    protected String[] namespaceUri = new String[this.namespacePrefix.length];
    protected int[] namespaceDepth = new int[this.namespacePrefix.length];

    public StaticXmlSerializerWrapper(XmlSerializer xmlSerializer, XmlPullWrapperFactory xmlPullWrapperFactory) {
        super(xmlSerializer);
        this.wf = xmlPullWrapperFactory;
    }

    public String getCurrentNamespaceForElements() {
        return this.currentNs;
    }

    public String setCurrentNamespaceForElements(String string) {
        String string2 = this.currentNs;
        this.currentNs = string;
        return string2;
    }

    public XmlSerializerWrapper attribute(String string, String string2) throws IOException, IllegalArgumentException, IllegalStateException {
        this.xs.attribute(null, string, string2);
        return this;
    }

    public XmlSerializerWrapper startTag(String string) throws IOException, IllegalArgumentException, IllegalStateException {
        this.xs.startTag(this.currentNs, string);
        return this;
    }

    public XmlSerializerWrapper endTag(String string) throws IOException, IllegalArgumentException, IllegalStateException {
        this.endTag(this.currentNs, string);
        return this;
    }

    public XmlSerializerWrapper element(String string, String string2) throws IOException, XmlPullParserException {
        return this.element(this.currentNs, string, string2);
    }

    public XmlSerializerWrapper element(String string, String string2, String string3) throws IOException, XmlPullParserException {
        if (string2 == null) {
            throw new XmlPullParserException("name for element can not be null");
        }
        this.xs.startTag(string, string2);
        if (string3 == null) {
            this.xs.attribute("http://www.w3.org/2001/XMLSchema-instance", "nil", "true");
        } else {
            this.xs.text(string3);
        }
        this.xs.endTag(string, string2);
        return this;
    }

    private void ensureNamespacesCapacity() {
        int n = this.namespaceEnd > 7 ? 2 * this.namespaceEnd : 8;
        String[] stringArray = new String[n];
        String[] stringArray2 = new String[n];
        int[] nArray = new int[n];
        if (this.namespacePrefix != null) {
            System.arraycopy(this.namespacePrefix, 0, stringArray, 0, this.namespaceEnd);
            System.arraycopy(this.namespaceUri, 0, stringArray2, 0, this.namespaceEnd);
            System.arraycopy(this.namespaceDepth, 0, nArray, 0, this.namespaceEnd);
        }
        this.namespacePrefix = stringArray;
        this.namespaceUri = stringArray2;
        this.namespaceDepth = nArray;
    }

    public void setPrefix(String string, String string2) throws IOException, IllegalArgumentException, IllegalStateException {
        this.xs.setPrefix(string, string2);
        int n = this.getDepth();
        for (int i = this.namespaceEnd - 1; i >= 0 && this.namespaceDepth[i] > n; --i) {
            --this.namespaceEnd;
        }
        if (this.namespaceEnd >= this.namespacePrefix.length) {
            this.ensureNamespacesCapacity();
        }
        this.namespacePrefix[this.namespaceEnd] = string;
        this.namespaceUri[this.namespaceEnd] = string2;
        ++this.namespaceEnd;
    }

    public void fragment(String string) throws IOException, IllegalArgumentException, IllegalStateException, XmlPullParserException {
        StringBuffer stringBuffer = new StringBuffer(string.length() + this.namespaceEnd * 30);
        stringBuffer.append("<fragment");
        block0: for (int i = this.namespaceEnd - 1; i >= 0; --i) {
            String string2 = this.namespacePrefix[i];
            for (int j = this.namespaceEnd - 1; j > i; --j) {
                if (string2.equals(this.namespacePrefix[j])) continue block0;
            }
            stringBuffer.append(" xmlns");
            if (string2.length() > 0) {
                stringBuffer.append(':').append(string2);
            }
            stringBuffer.append("='");
            stringBuffer.append(this.escapeAttributeValue(this.namespaceUri[i]));
            stringBuffer.append("'");
        }
        stringBuffer.append(">");
        stringBuffer.append(string);
        stringBuffer.append("</fragment>");
        if (this.fragmentParser == null) {
            this.fragmentParser = this.wf.newPullParserWrapper();
        }
        String string3 = stringBuffer.toString();
        this.fragmentParser.setInput(new StringReader(string3));
        this.fragmentParser.nextTag();
        this.fragmentParser.require(2, null, "fragment");
        while (true) {
            this.fragmentParser.nextToken();
            if (this.fragmentParser.getDepth() == 1 && this.fragmentParser.getEventType() == 3) break;
            this.event(this.fragmentParser);
        }
        this.fragmentParser.require(3, null, "fragment");
    }

    public void event(XmlPullParser xmlPullParser) throws XmlPullParserException, IOException {
        int n = xmlPullParser.getEventType();
        switch (n) {
            case 0: {
                Boolean bl = (Boolean)xmlPullParser.getProperty(PROPERTY_XMLDECL_STANDALONE);
                this.startDocument(xmlPullParser.getInputEncoding(), bl);
                break;
            }
            case 1: {
                this.endDocument();
                break;
            }
            case 2: {
                this.writeStartTag(xmlPullParser);
                break;
            }
            case 3: {
                this.endTag(xmlPullParser.getNamespace(), xmlPullParser.getName());
                break;
            }
            case 7: {
                String string = xmlPullParser.getText();
                this.ignorableWhitespace(string);
                break;
            }
            case 4: {
                if (xmlPullParser.getDepth() > 0) {
                    this.text(xmlPullParser.getText());
                    break;
                }
                this.ignorableWhitespace(xmlPullParser.getText());
                break;
            }
            case 6: {
                this.entityRef(xmlPullParser.getName());
                break;
            }
            case 5: {
                this.cdsect(xmlPullParser.getText());
                break;
            }
            case 8: {
                this.processingInstruction(xmlPullParser.getText());
                break;
            }
            case 9: {
                this.comment(xmlPullParser.getText());
                break;
            }
            case 10: {
                this.docdecl(xmlPullParser.getText());
            }
        }
    }

    private void writeStartTag(XmlPullParser xmlPullParser) throws XmlPullParserException, IOException {
        int n;
        if (!xmlPullParser.getFeature("http://xmlpull.org/v1/doc/features.html#report-namespace-prefixes")) {
            n = xmlPullParser.getNamespaceCount(xmlPullParser.getDepth() - 1);
            int n2 = xmlPullParser.getNamespaceCount(xmlPullParser.getDepth());
            for (int i = n; i < n2; ++i) {
                String string = xmlPullParser.getNamespacePrefix(i);
                String string2 = xmlPullParser.getNamespaceUri(i);
                this.setPrefix(string, string2);
            }
        }
        this.startTag(xmlPullParser.getNamespace(), xmlPullParser.getName());
        for (n = 0; n < xmlPullParser.getAttributeCount(); ++n) {
            this.attribute(xmlPullParser.getAttributeNamespace(n), xmlPullParser.getAttributeName(n), xmlPullParser.getAttributeValue(n));
        }
    }

    public String escapeAttributeValue(String string) {
        int n = string.indexOf(60);
        int n2 = string.indexOf(38);
        int n3 = string.indexOf(34);
        int n4 = string.indexOf(39);
        if (n == -1 && n2 == -1 && n3 == -1 && n4 == -1) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string.length() + 10);
        int n5 = string.length();
        block6: for (int i = 0; i < n5; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '<': {
                    stringBuffer.append("&lt;");
                    continue block6;
                }
                case '&': {
                    stringBuffer.append("&amp;");
                    continue block6;
                }
                case '\'': {
                    stringBuffer.append("&apos;");
                    continue block6;
                }
                case '\"': {
                    stringBuffer.append("&quot;");
                    continue block6;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
        }
        return stringBuffer.toString();
    }

    public String escapeText(String string) {
        int n;
        StringBuffer stringBuffer;
        block5: {
            int n2 = string.indexOf(60);
            int n3 = string.indexOf(38);
            if (n2 == -1 && n3 == -1) {
                return string;
            }
            stringBuffer = new StringBuffer(string.length() + 10);
            n = 0;
            while (true) {
                if (n2 == -1 && n3 == -1) break block5;
                if (n2 == -1 || n2 != -1 && n3 != -1 && n3 < n2) {
                    if (n < n3) {
                        stringBuffer.append(string.substring(n, n3));
                    }
                    stringBuffer.append("&amp;");
                    n = n3 + 1;
                    n3 = string.indexOf(38, n);
                    continue;
                }
                if (n3 != -1 && (n2 == -1 || n3 == -1 || n2 >= n3)) break;
                if (n < n2) {
                    stringBuffer.append(string.substring(n, n2));
                }
                stringBuffer.append("&lt;");
                n = n2 + 1;
                n2 = string.indexOf(60, n);
            }
            throw new IllegalStateException("wrong state posLt=" + n2 + " posAmp=" + n3 + " for " + string);
        }
        stringBuffer.append(string.substring(n));
        return stringBuffer.toString();
    }

    public void writeDouble(double d) throws XmlPullParserException, IOException, IllegalArgumentException {
        if (d == Double.POSITIVE_INFINITY) {
            this.xs.text("INF");
        } else if (d == Double.NEGATIVE_INFINITY) {
            this.xs.text("-INF");
        } else {
            this.xs.text(Double.toString(d));
        }
    }

    public void writeFloat(float f) throws XmlPullParserException, IOException, IllegalArgumentException {
        if (f == Float.POSITIVE_INFINITY) {
            this.xs.text("INF");
        } else if (f == Float.NEGATIVE_INFINITY) {
            this.xs.text("-INF");
        } else {
            this.xs.text(Float.toString(f));
        }
    }

    public void writeInt(int n) throws XmlPullParserException, IOException, IllegalArgumentException {
        this.xs.text(Integer.toString(n));
    }

    public void writeString(String string) throws XmlPullParserException, IOException, IllegalArgumentException {
        if (string == null) {
            throw new IllegalArgumentException("null string can not be written");
        }
        this.xs.text(string);
    }

    public void writeDoubleElement(String string, String string2, double d) throws XmlPullParserException, IOException, IllegalArgumentException {
        this.xs.startTag(string, string2);
        this.writeDouble(d);
        this.xs.endTag(string, string2);
    }

    public void writeFloatElement(String string, String string2, float f) throws XmlPullParserException, IOException, IllegalArgumentException {
        this.xs.startTag(string, string2);
        this.writeFloat(f);
        this.xs.endTag(string, string2);
    }

    public void writeIntElement(String string, String string2, int n) throws XmlPullParserException, IOException, IllegalArgumentException {
        this.xs.startTag(string, string2);
        this.writeInt(n);
        this.xs.endTag(string, string2);
    }

    public void writeStringElement(String string, String string2, String string3) throws XmlPullParserException, IOException, IllegalArgumentException {
        this.xs.startTag(string, string2);
        if (string3 == null) {
            this.xs.attribute("http://www.w3.org/2001/XMLSchema", "nil", "true");
        } else {
            this.writeString(string3);
        }
        this.xs.endTag(string, string2);
    }
}

