/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.javafreetype;

import com.sun.jna.NativeLong;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.IntByReference;
import de.matthiasmann.javafreetype.FT2Helper;
import de.matthiasmann.javafreetype.FreeTypeFont;
import java.io.IOException;
import java.util.NoSuchElementException;

public final class FreeTypeCodePointIterator {
    private final FreeTypeFont font;
    private final Pointer face;
    private final IntByReference glyphIndex;
    private NativeLong codePoint;

    FreeTypeCodePointIterator(FreeTypeFont freeTypeFont) {
        this.font = freeTypeFont;
        this.face = freeTypeFont.face.getPointer();
        this.glyphIndex = new IntByReference();
    }

    public boolean nextCodePoint() throws IOException {
        this.font.ensureOpen();
        if (this.codePoint == null) {
            this.codePoint = FT2Helper.INSTANCE.FT_Get_First_Char(this.face, this.glyphIndex);
        } else {
            if (this.glyphIndex.getValue() == 0) {
                return false;
            }
            this.codePoint = FT2Helper.INSTANCE.FT_Get_Next_Char(this.face, this.codePoint, this.glyphIndex);
        }
        return this.glyphIndex.getValue() != 0;
    }

    public int getGlyphIndex() {
        this.ensureGlyphIndex();
        return this.glyphIndex.getValue();
    }

    public int getCodePoint() {
        this.ensureGlyphIndex();
        return this.codePoint.intValue();
    }

    private void ensureGlyphIndex() {
        if (this.glyphIndex.getValue() == 0) {
            throw new NoSuchElementException();
        }
    }
}

