/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.javafreetype;

import com.sun.jna.NativeLong;
import com.sun.jna.Pointer;
import de.matthiasmann.javafreetype.FT2Helper;
import de.matthiasmann.javafreetype.FT2Library;
import de.matthiasmann.javafreetype.FreeTypeCodePointIterator;
import de.matthiasmann.javafreetype.FreeTypeException;
import de.matthiasmann.javafreetype.FreeTypeGlyphInfo;
import java.awt.Color;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;

public class FreeTypeFont
implements Closeable {
    public static final int MAX_FONT_FILE_SIZE = 0x2000000;
    ByteBuffer fontBuffer;
    Pointer library;
    FT2Library.FT_Face face;

    private FreeTypeFont(Pointer pointer, ByteBuffer byteBuffer) throws FreeTypeException {
        this.fontBuffer = byteBuffer;
        this.library = pointer;
        this.face = FT2Helper.FT_New_Memory_Face(pointer, byteBuffer, 0L);
    }

    public void close() throws IOException {
        this.close0();
    }

    public String getFamilyName() throws IOException {
        this.ensureOpen();
        return this.face.family_name;
    }

    public String getStyleName() throws IOException {
        this.ensureOpen();
        return this.face.style_name;
    }

    public void setCharSize(float f, float f2, int n, int n2) throws IOException {
        this.ensureOpen();
        FT2Helper.checkReturnCode(FT2Helper.INSTANCE.FT_Set_Char_Size(this.face.getPointer(), FT2Helper.to26_6(f), FT2Helper.to26_6(f2), n, n2));
        this.face.read();
    }

    public void setPixelSize(int n, int n2) throws IOException {
        this.ensureOpen();
        FT2Helper.checkReturnCode(FT2Helper.INSTANCE.FT_Set_Pixel_Sizes(this.face.getPointer(), n, n2));
        this.face.read();
    }

    public int getAscent() throws IOException {
        this.ensureOpen();
        if (this.face.isScalable()) {
            return FT2Helper.round26_6(this.face.size.metrics.ascender);
        }
        return this.face.ascender;
    }

    public int getDescent() throws IOException {
        this.ensureOpen();
        if (this.face.isScalable()) {
            return -FT2Helper.round26_6(this.face.size.metrics.descender);
        }
        return -this.face.descender;
    }

    public int getMaxAscent() throws IOException {
        this.ensureOpen();
        return this.roundMaybeScaleY(this.face.bbox.yMax);
    }

    public int getMaxDescent() throws IOException {
        this.ensureOpen();
        return -this.roundMaybeScaleY(this.face.bbox.yMin);
    }

    public int getLineHeight() throws IOException {
        this.ensureOpen();
        if (this.face.isScalable()) {
            return FT2Helper.round26_6(this.face.size.metrics.height);
        }
        return this.face.height;
    }

    public int getLeading() throws IOException {
        this.ensureOpen();
        int n = this.face.isScalable() ? FT2Helper.round26_6(this.face.size.metrics.height) : this.face.height;
        return n - this.roundMaybeScaleY(this.face.bbox.yMax) + this.roundMaybeScaleY(this.face.bbox.yMin);
    }

    public int getUnderlinePosition() throws IOException {
        this.ensureOpen();
        return this.roundMaybeScaleY(this.face.underline_position);
    }

    public int getUnderlineThickness() throws IOException {
        this.ensureOpen();
        return this.roundMaybeScaleY(this.face.underline_thickness);
    }

    public static void setNativeLibraryName(String string) {
        FT2Helper.nativeLibName = string;
    }

    public static boolean isAvailable() {
        return FT2Helper.isAvailable();
    }

    public FreeTypeCodePointIterator iterateCodePoints() throws IOException {
        this.ensureOpen();
        return new FreeTypeCodePointIterator(this);
    }

    public int getGlyphForCodePoint(int n) throws IOException {
        this.ensureOpen();
        return FT2Helper.INSTANCE.FT_Get_Char_Index(this.face.getPointer(), new NativeLong((long)n));
    }

    public boolean hasKerning() throws IOException {
        this.ensureOpen();
        return this.face.hasKerning();
    }

    public Point getKerning(int n, int n2) throws IOException {
        this.ensureOpen();
        if (this.face.hasKerning()) {
            FT2Library.FT_Vector fT_Vector = new FT2Library.FT_Vector();
            fT_Vector.setAutoSynch(false);
            FT2Helper.checkReturnCode(FT2Helper.INSTANCE.FT_Get_Kerning(this.face.getPointer(), n, n2, 0, fT_Vector));
            fT_Vector.read();
            return new Point(FT2Helper.round26_6(fT_Vector.x), FT2Helper.round26_6(fT_Vector.y));
        }
        return new Point();
    }

    public FreeTypeGlyphInfo loadGlyph(int n) throws IOException {
        this.ensureOpen();
        FT2Helper.checkReturnCode(FT2Helper.INSTANCE.FT_Load_Glyph(this.face.getPointer(), n, 4));
        return this.makeGlyphInfo();
    }

    public FreeTypeGlyphInfo loadCodePoint(int n) throws IOException {
        this.ensureOpen();
        FT2Helper.checkReturnCode(FT2Helper.INSTANCE.FT_Load_Char(this.face.getPointer(), new NativeLong((long)n), 4));
        return this.makeGlyphInfo();
    }

    public boolean copyGlpyhToBufferedImage(BufferedImage bufferedImage, int n, int n2, Color color) throws IOException {
        this.ensureGlyphLoaded();
        FT2Library.FT_Bitmap fT_Bitmap = this.face.glyph.bitmap;
        if (fT_Bitmap.buffer == null) {
            return false;
        }
        switch (bufferedImage.getType()) {
            case 10: {
                return FT2Helper.copyGlyphToBufferedImageGray(fT_Bitmap, bufferedImage, n, n2);
            }
            case 2: {
                return FT2Helper.copyGlyphToBufferedImageIntARGB(fT_Bitmap, bufferedImage, n, n2, color);
            }
        }
        throw new UnsupportedOperationException("unsupported BufferdImage type");
    }

    public boolean copyGlyphToByteBuffer(ByteBuffer byteBuffer, int n) throws IOException {
        this.ensureGlyphLoaded();
        FT2Library.FT_Bitmap fT_Bitmap = this.face.glyph.bitmap;
        if (fT_Bitmap.buffer == null) {
            return false;
        }
        return FT2Helper.copyGlyphToByteBuffer(fT_Bitmap, byteBuffer, n);
    }

    public boolean copyGlyphToByteBufferColor(ByteBuffer byteBuffer, int n, byte[] byArray, byte[] byArray2) throws IOException {
        this.ensureGlyphLoaded();
        if (byArray.length != byArray2.length) {
            throw new IllegalArgumentException("color arrays must have same length");
        }
        short[] sArray = new short[byArray.length * 2];
        for (int i = 0; i < byArray.length; ++i) {
            int n2 = byArray[i] & 0xFF;
            sArray[i * 2 + 0] = (short)n2;
            sArray[i * 2 + 1] = (short)((byArray2[i] & 0xFF) - n2);
        }
        FT2Library.FT_Bitmap fT_Bitmap = this.face.glyph.bitmap;
        if (fT_Bitmap.buffer == null) {
            return false;
        }
        return FT2Helper.copyGlyphToByteBuffer(fT_Bitmap, byteBuffer, n, sArray);
    }

    public static FreeTypeFont create(ByteBuffer byteBuffer) throws IOException {
        FT2Helper.checkAvailable();
        return new FreeTypeFont(FT2Helper.FT_Init_FreeType(), byteBuffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FreeTypeFont create(File file) throws IOException {
        FT2Helper.checkAvailable();
        RandomAccessFile randomAccessFile = new RandomAccessFile(file, "r");
        try {
            int n = (int)Math.min(0x2000000L, randomAccessFile.length());
            ByteBuffer byteBuffer = ByteBuffer.allocateDirect(n);
            randomAccessFile.getChannel().read(byteBuffer);
            byteBuffer.flip();
            FreeTypeFont freeTypeFont = new FreeTypeFont(FT2Helper.FT_Init_FreeType(), byteBuffer);
            return freeTypeFont;
        }
        finally {
            randomAccessFile.close();
        }
    }

    public static FreeTypeFont create(InputStream inputStream) throws IOException {
        FT2Helper.checkAvailable();
        ByteBuffer byteBuffer = FT2Helper.inputStreamToByteBuffer(inputStream);
        return new FreeTypeFont(FT2Helper.FT_Init_FreeType(), byteBuffer);
    }

    private FreeTypeGlyphInfo makeGlyphInfo() {
        this.face.glyph.read();
        return new FreeTypeGlyphInfo(this.face.glyph);
    }

    private int roundMaybeScaleY(NativeLong nativeLong) {
        return this.roundMaybeScaleY(nativeLong.longValue());
    }

    private int roundMaybeScaleY(long l) {
        if (this.face.isScalable()) {
            l = FT2Helper.FT_FixMul(l, this.face.size.metrics.y_scale.longValue());
        }
        return FT2Helper.round26_6(l);
    }

    final void ensureOpen() throws IOException {
        if (this.library == null) {
            throw new ClosedChannelException();
        }
    }

    final void ensureGlyphLoaded() throws IOException {
        this.ensureOpen();
        if (this.face.glyph == null) {
            throw new IllegalStateException("No glyph loaded");
        }
    }

    private void close0() throws IOException {
        if (this.library != null) {
            int n = FT2Helper.INSTANCE.FT_Done_FreeType(this.library);
            this.library = null;
            this.face = null;
            this.fontBuffer = null;
            FT2Helper.checkReturnCode(n);
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.close0();
    }
}

