/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.javafreetype;

import de.matthiasmann.javafreetype.FT2Helper;
import de.matthiasmann.javafreetype.FT2Library;

public class FreeTypeGlyphInfo {
    final int width;
    final int height;
    final int offsetX;
    final int offsetY;
    final int advanceX;
    final int advanceY;

    FreeTypeGlyphInfo(FT2Library.FT_GlyphSlot fT_GlyphSlot) {
        if (fT_GlyphSlot.format == FT2Library.FT_GLYPH_FORMAT_BITMAP) {
            this.width = fT_GlyphSlot.bitmap.width;
            this.height = fT_GlyphSlot.bitmap.rows;
            this.offsetX = fT_GlyphSlot.bitmap_left;
            this.offsetY = fT_GlyphSlot.bitmap_top;
        } else {
            this.width = 0;
            this.height = 0;
            this.offsetX = 0;
            this.offsetY = 0;
        }
        this.advanceX = FT2Helper.round26_6(fT_GlyphSlot.advance.x);
        this.advanceY = FT2Helper.round26_6(fT_GlyphSlot.advance.y);
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getOffsetX() {
        return this.offsetX;
    }

    public int getOffsetY() {
        return this.offsetY;
    }

    public int getAdvanceX() {
        return this.advanceX;
    }

    public int getAdvanceY() {
        return this.advanceY;
    }
}

