/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.tools;

import com.badlogic.gdx.utils.Array;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public class FileProcessor {
    FilenameFilter inputFilter;
    Comparator<File> comparator;
    Array<Pattern> inputRegex = new Array();
    String outputSuffix;
    ArrayList<InputFile> outputFiles = new ArrayList();
    boolean recursive = true;
    boolean flattenOutput;
    Comparator<InputFile> inputFileComparator = new Comparator<InputFile>(){

        @Override
        public int compare(InputFile o1, InputFile o2) {
            return FileProcessor.this.comparator.compare(o1.inputFile, o2.inputFile);
        }
    };

    public FileProcessor setInputFilter(FilenameFilter inputFilter) {
        this.inputFilter = inputFilter;
        return this;
    }

    public FileProcessor setComparator(Comparator<File> comparator) {
        this.comparator = comparator;
        return this;
    }

    public FileProcessor addInputSuffix(String ... suffixes) {
        for (String suffix : suffixes) {
            this.addInputRegex(".*" + Pattern.quote(suffix));
        }
        return this;
    }

    public FileProcessor addInputRegex(String ... regexex) {
        for (String regex : regexex) {
            this.inputRegex.add((Object)Pattern.compile(regex));
        }
        return this;
    }

    public FileProcessor setOutputSuffix(String outputSuffix) {
        this.outputSuffix = outputSuffix;
        return this;
    }

    public FileProcessor setFlattenOutput(boolean flattenOutput) {
        this.flattenOutput = flattenOutput;
        return this;
    }

    public FileProcessor setRecursive(boolean recursive) {
        this.recursive = recursive;
        return this;
    }

    public ArrayList<InputFile> process(File inputFile, File outputRoot) throws Exception {
        if (!inputFile.exists()) {
            throw new IllegalArgumentException("Input file does not exist: " + inputFile.getAbsolutePath());
        }
        if (inputFile.isFile()) {
            return this.process(new File[]{inputFile}, outputRoot);
        }
        return this.process(inputFile.listFiles(), outputRoot);
    }

    public ArrayList<InputFile> process(File[] files, File outputRoot) throws Exception {
        this.outputFiles.clear();
        HashMap<File, ArrayList<InputFile>> dirToEntries = new HashMap<File, ArrayList<InputFile>>();
        this.process(files, outputRoot, outputRoot, dirToEntries, 0);
        ArrayList<InputFile> allInputFiles = new ArrayList<InputFile>();
        for (Map.Entry<File, ArrayList<InputFile>> entry : dirToEntries.entrySet()) {
            ArrayList<InputFile> dirInputFiles = entry.getValue();
            if (this.comparator != null) {
                Collections.sort(dirInputFiles, this.inputFileComparator);
            }
            File inputDir = entry.getKey();
            File newOutputDir = this.flattenOutput ? outputRoot : dirInputFiles.get((int)0).outputDir;
            String outputName = inputDir.getName();
            if (this.outputSuffix != null) {
                outputName = outputName.replaceAll("(.*)\\..*", "$1") + this.outputSuffix;
            }
            InputFile inputFile = new InputFile();
            inputFile.inputFile = entry.getKey();
            inputFile.outputDir = newOutputDir;
            inputFile.outputFile = new File(newOutputDir, outputName);
            try {
                this.processDir(inputFile, dirInputFiles);
            }
            catch (Exception ex) {
                throw new Exception("Error processing directory: " + inputFile.inputFile.getAbsolutePath(), ex);
            }
            allInputFiles.addAll(dirInputFiles);
        }
        if (this.comparator != null) {
            Collections.sort(allInputFiles, this.inputFileComparator);
        }
        for (InputFile inputFile : allInputFiles) {
            try {
                this.processFile(inputFile);
            }
            catch (Exception ex) {
                throw new Exception("Error processing file: " + inputFile.inputFile.getAbsolutePath(), ex);
            }
        }
        return this.outputFiles;
    }

    private void process(File[] files, File outputRoot, File outputDir, HashMap<File, ArrayList<InputFile>> dirToEntries, int depth) {
        for (File file : files) {
            if (file.isFile()) {
                if (this.inputRegex.size > 0) {
                    boolean found = false;
                    for (Pattern pattern : this.inputRegex) {
                        if (!pattern.matcher(file.getName()).matches()) continue;
                        found = true;
                    }
                    if (!found) continue;
                }
                File dir = file.getParentFile();
                if (this.inputFilter != null && !this.inputFilter.accept(dir, file.getName())) continue;
                String outputName = file.getName();
                if (this.outputSuffix != null) {
                    outputName = outputName.replaceAll("(.*)\\..*", "$1") + this.outputSuffix;
                }
                InputFile inputFile = new InputFile();
                inputFile.depth = depth;
                inputFile.inputFile = file;
                inputFile.outputDir = outputDir;
                inputFile.outputFile = this.flattenOutput ? new File(outputRoot, outputName) : new File(outputDir, outputName);
                ArrayList<InputFile> inputFiles = dirToEntries.get(dir);
                if (inputFiles == null) {
                    inputFiles = new ArrayList();
                    dirToEntries.put(dir, inputFiles);
                }
                inputFiles.add(inputFile);
            }
            if (!this.recursive || !file.isDirectory()) continue;
            this.process(file.listFiles(this.inputFilter), outputRoot, new File(outputDir, file.getName()), dirToEntries, depth + 1);
        }
    }

    protected void processFile(InputFile inputFile) throws Exception {
    }

    protected void processDir(InputFile inputDir, ArrayList<InputFile> files) throws Exception {
    }

    protected void addProcessedFile(InputFile inputFile) {
        this.outputFiles.add(inputFile);
    }

    public static class InputFile {
        public File inputFile;
        public File outputDir;
        public File outputFile;
        public int depth;

        public InputFile() {
        }

        public InputFile(File inputFile, File outputFile) {
            this.inputFile = inputFile;
            this.outputFile = outputFile;
        }
    }
}

