/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.tools.hiero;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.tools.hiero.Kerning;
import com.badlogic.gdx.tools.hiero.unicodefont.Glyph;
import com.badlogic.gdx.tools.hiero.unicodefont.GlyphPage;
import com.badlogic.gdx.tools.hiero.unicodefont.UnicodeFont;
import java.awt.Font;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphMetrics;
import java.awt.font.GlyphVector;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.imageio.ImageIO;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;

public class BMFontUtil {
    private final UnicodeFont unicodeFont;

    public BMFontUtil(UnicodeFont unicodeFont) {
        this.unicodeFont = unicodeFont;
    }

    public void save(File outputBMFontFile) throws IOException {
        File outputDir = outputBMFontFile.getParentFile();
        String outputName = outputBMFontFile.getName();
        if (outputName.endsWith(".fnt")) {
            outputName = outputName.substring(0, outputName.length() - 4);
        }
        this.unicodeFont.loadGlyphs();
        PrintStream out = new PrintStream(new FileOutputStream(new File(outputDir, outputName + ".fnt")));
        Font font = this.unicodeFont.getFont();
        int pageWidth = this.unicodeFont.getGlyphPageWidth();
        int pageHeight = this.unicodeFont.getGlyphPageHeight();
        out.println("info face=\"" + font.getFontName() + "\" size=" + font.getSize() + " bold=" + (font.isBold() ? 1 : 0) + " italic=" + (font.isItalic() ? 1 : 0) + " charset=\"\" unicode=0 stretchH=100 smooth=1 aa=1 padding=" + this.unicodeFont.getPaddingTop() + "," + this.unicodeFont.getPaddingLeft() + "," + this.unicodeFont.getPaddingBottom() + "," + this.unicodeFont.getPaddingRight() + " spacing=" + this.unicodeFont.getPaddingAdvanceX() + "," + this.unicodeFont.getPaddingAdvanceY());
        out.println("common lineHeight=" + this.unicodeFont.getLineHeight() + " base=" + this.unicodeFont.getAscent() + " scaleW=" + pageWidth + " scaleH=" + pageHeight + " pages=" + this.unicodeFont.getGlyphPages().size() + " packed=0");
        int pageIndex = 0;
        int glyphCount = 0;
        Iterator pageIter = this.unicodeFont.getGlyphPages().iterator();
        while (pageIter.hasNext()) {
            GlyphPage page = (GlyphPage)pageIter.next();
            String fileName = pageIndex == 0 && !pageIter.hasNext() ? outputName + ".png" : outputName + (pageIndex + 1) + ".png";
            out.println("page id=" + pageIndex + " file=\"" + fileName + "\"");
            glyphCount += page.getGlyphs().size();
            ++pageIndex;
        }
        out.println("chars count=" + glyphCount);
        int[] glyphMetrics = this.getGlyphMetrics(font, 32);
        int xAdvance = glyphMetrics[1];
        out.println("char id=32   x=0     y=0     width=0     height=0     xoffset=0     yoffset=" + this.unicodeFont.getAscent() + "    xadvance=" + xAdvance + "     page=0  chnl=0 ");
        pageIndex = 0;
        ArrayList allGlyphs = new ArrayList(512);
        for (GlyphPage page : this.unicodeFont.getGlyphPages()) {
            for (Glyph glyph : page.getGlyphs()) {
                glyphMetrics = this.getGlyphMetrics(font, glyph.getCodePoint());
                int xOffset = glyphMetrics[0];
                xAdvance = glyphMetrics[1];
                out.println("char id=" + glyph.getCodePoint() + "   " + "x=" + (int)(glyph.getU() * (float)pageWidth) + "     y=" + (int)(glyph.getV() * (float)pageHeight) + "     width=" + glyph.getWidth() + "     height=" + glyph.getHeight() + "     xoffset=" + xOffset + "     yoffset=" + glyph.getYOffset() + "    xadvance=" + xAdvance + "     page=" + pageIndex + "  chnl=0 ");
            }
            allGlyphs.addAll(page.getGlyphs());
            ++pageIndex;
        }
        String ttfFileRef = this.unicodeFont.getFontFile();
        if (ttfFileRef == null) {
            System.out.println("Kerning information could not be output because a TTF font file was not specified.");
        } else {
            Kerning kerning = new Kerning();
            try {
                kerning.load(Gdx.files.internal(ttfFileRef).read(), font.getSize());
            }
            catch (IOException ex) {
                System.out.println("Unable to read kerning information from font: " + ttfFileRef);
            }
            HashMap<Integer, Integer> glyphCodeToCodePoint = new HashMap<Integer, Integer>();
            for (Glyph glyph : allGlyphs) {
                glyphCodeToCodePoint.put(new Integer(this.getGlyphCode(font, glyph.getCodePoint())), new Integer(glyph.getCodePoint()));
            }
            class KerningPair {
                public int firstCodePoint;
                public int secondCodePoint;
                public int offset;

                KerningPair() {
                }
            }
            ArrayList<KerningPair> kernings = new ArrayList<KerningPair>(256);
            for (Glyph firstGlyph : allGlyphs) {
                int firstGlyphCode = this.getGlyphCode(font, firstGlyph.getCodePoint());
                int[] values = kerning.getValues(firstGlyphCode);
                if (values == null) continue;
                for (int i = 0; i < values.length; ++i) {
                    Integer secondCodePoint = (Integer)glyphCodeToCodePoint.get(new Integer(values[i] & 0xFFFF));
                    if (secondCodePoint == null) continue;
                    int offset = values[i] >> 16;
                    KerningPair pair = new KerningPair();
                    pair.firstCodePoint = firstGlyph.getCodePoint();
                    pair.secondCodePoint = secondCodePoint;
                    pair.offset = offset;
                    kernings.add(pair);
                }
            }
            out.println("kernings count=" + kerning.getCount());
            for (KerningPair pair : kernings) {
                out.println("kerning first=" + pair.firstCodePoint + "  second=" + pair.secondCodePoint + "  amount=" + pair.offset);
            }
        }
        out.close();
        int width = this.unicodeFont.getGlyphPageWidth();
        int height = this.unicodeFont.getGlyphPageHeight();
        IntBuffer buffer = BufferUtils.createIntBuffer((int)(width * height));
        BufferedImage pageImage = new BufferedImage(width, height, 2);
        int[] row = new int[width];
        pageIndex = 0;
        Iterator pageIter2 = this.unicodeFont.getGlyphPages().iterator();
        while (pageIter2.hasNext()) {
            GlyphPage page = (GlyphPage)pageIter2.next();
            String fileName = pageIndex == 0 && !pageIter2.hasNext() ? outputName + ".png" : outputName + (pageIndex + 1) + ".png";
            page.getTexture().bind();
            buffer.clear();
            GL11.glGetTexImage((int)3553, (int)0, (int)32993, (int)5121, (IntBuffer)buffer);
            WritableRaster raster = pageImage.getRaster();
            for (int y = 0; y < height; ++y) {
                buffer.get(row);
                raster.setDataElements(0, y, width, 1, row);
            }
            File imageOutputFile = new File(outputDir, fileName);
            ImageIO.write((RenderedImage)pageImage, "png", imageOutputFile);
            ++pageIndex;
        }
    }

    private int getGlyphCode(Font font, int codePoint) {
        char[] chars = Character.toChars(codePoint);
        GlyphVector vector = font.layoutGlyphVector(GlyphPage.renderContext, chars, 0, chars.length, 0);
        return vector.getGlyphCode(0);
    }

    private int[] getGlyphMetrics(Font font, int codePoint) {
        char[] chars = Character.toChars(codePoint);
        GlyphVector vector = font.layoutGlyphVector(GlyphPage.renderContext, chars, 0, chars.length, 0);
        GlyphMetrics metrics = vector.getGlyphMetrics(0);
        int xOffset = vector.getGlyphPixelBounds((int)0, (FontRenderContext)GlyphPage.renderContext, (float)0.5f, (float)0.0f).x - this.unicodeFont.getPaddingLeft();
        int xAdvance = (int)(metrics.getAdvanceX() + (float)this.unicodeFont.getPaddingAdvanceX() + (float)this.unicodeFont.getPaddingLeft() + (float)this.unicodeFont.getPaddingRight());
        return new int[]{xOffset, xAdvance};
    }
}

