/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.tools.imagepacker;

import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.utils.GdxRuntimeException;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.CRC32;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;

public class TexturePacker {
    static Pattern indexPattern = Pattern.compile(".+_(\\d+)(_.*|$)");
    public static boolean quiet;
    ArrayList<Image> images = new ArrayList();
    HashMap<String, Image> imageCrcs = new HashMap();
    FileWriter writer;
    int uncompressedSize;
    int compressedSize;
    int xPadding;
    int yPadding;
    final Filter filter;
    int minWidth;
    int minHeight;
    int maxWidth;
    int maxHeight;
    final Settings settings;
    BufferedImage emptyImage = new BufferedImage(1, 1, 6);
    private static ArrayList<Comparator> imageComparators;
    static final HashMap<Texture.TextureFilter, String> filterToAbbrev;
    static final HashMap<Pixmap.Format, String> formatToAbbrev;

    public TexturePacker(Settings settings) {
        this.settings = settings;
        this.filter = new Filter(Direction.none, null, null, -1, -1, null, null);
    }

    public TexturePacker(Settings settings, File inputDir, Filter filter, File outputDir, File packFile) throws IOException {
        this.settings = settings;
        this.filter = filter;
        File[] files = inputDir.listFiles(filter);
        if (files == null) {
            return;
        }
        for (File file : files) {
            int dotIndex;
            if (file.isDirectory()) continue;
            String imageName = file.getAbsolutePath().substring(inputDir.getAbsolutePath().length()) + "\n";
            if (imageName.startsWith("/") || imageName.startsWith("\\")) {
                imageName = imageName.substring(1);
            }
            if ((dotIndex = imageName.lastIndexOf(46)) != -1) {
                imageName = imageName.substring(0, dotIndex);
            }
            this.addImage(ImageIO.read(file), imageName);
        }
        if (this.images.isEmpty()) {
            return;
        }
        TexturePacker.log(inputDir.toString());
        if (filter.format != null) {
            TexturePacker.log("Format: " + filter.format);
        } else {
            TexturePacker.log("Format: " + settings.defaultFormat + " (default)");
        }
        if (filter.minFilter != null && filter.magFilter != null) {
            TexturePacker.log("Filter: " + filter.minFilter + ", " + filter.magFilter);
        } else {
            TexturePacker.log("Filter: " + settings.defaultFilterMin + ", " + settings.defaultFilterMag + " (default)");
        }
        if (filter.direction != Direction.none) {
            TexturePacker.log("Repeat: " + (Object)((Object)filter.direction));
        }
        this.process(outputDir, packFile, inputDir.getName());
    }

    static void log(String message) {
        if (!quiet) {
            System.out.println(message);
        }
    }

    public void addImage(BufferedImage image, String name) {
        Image squeezed = this.squeeze(image, name, false);
        if (squeezed != null) {
            if (this.settings.alias) {
                String crc = TexturePacker.hash(squeezed);
                Image existing = this.imageCrcs.get(crc);
                if (existing != null) {
                    existing.aliases.add(squeezed);
                    return;
                }
                this.imageCrcs.put(crc, squeezed);
            }
            this.images.add(squeezed);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(File outputDir, File packFile, String prefix) throws IOException {
        if (this.images.isEmpty()) {
            return;
        }
        this.minWidth = this.filter.width != -1 ? this.filter.width : this.settings.minWidth;
        this.minHeight = this.filter.height != -1 ? this.filter.height : this.settings.minHeight;
        this.maxWidth = this.filter.width != -1 ? this.filter.width : this.settings.maxWidth;
        int n = this.maxHeight = this.filter.height != -1 ? this.filter.height : this.settings.maxHeight;
        if (this.settings.edgePadding) {
            this.xPadding = !this.filter.direction.isX() ? this.settings.padding : 0;
            this.yPadding = !this.filter.direction.isY() ? this.settings.padding : 0;
        } else {
            this.xPadding = this.images.size() > 1 && !this.filter.direction.isX() ? this.settings.padding : 0;
            this.yPadding = this.images.size() > 1 && !this.filter.direction.isY() ? this.settings.padding : 0;
        }
        outputDir.mkdirs();
        this.writer = new FileWriter(packFile, true);
        try {
            while (!this.images.isEmpty() && this.writePage(prefix, outputDir)) {
            }
            if (this.writer != null) {
                TexturePacker.log("Pixels eliminated: " + (1.0f - (float)this.compressedSize / (float)this.uncompressedSize) * 100.0f + "%");
                TexturePacker.log("");
            }
        }
        finally {
            this.writer.close();
        }
    }

    private boolean writePage(String prefix, File outputDir) throws IOException {
        int type;
        Comparator bestComparator = null;
        Comparator secondBestComparator = imageComparators.get(0);
        int bestWidth = 99999;
        int bestHeight = 99999;
        int secondBestWidth = 99999;
        int secondBestHeight = 99999;
        int bestUsedPixels = 0;
        int width = this.minWidth;
        int height = this.minHeight;
        int grownPixels = 0;
        boolean grownPixels2 = false;
        int i = 0;
        int ii = 0;
        while (true) {
            for (Comparator comparator : imageComparators) {
                Collections.sort(this.images, comparator);
                int usedPixels = this.insert(null, new ArrayList<Image>(this.images), width, height);
                if (usedPixels > bestUsedPixels) {
                    secondBestComparator = comparator;
                    secondBestWidth = width;
                    secondBestHeight = height;
                }
                if (usedPixels != -1 || width * height >= bestWidth * bestHeight) continue;
                bestComparator = comparator;
                bestWidth = width;
                bestHeight = height;
            }
            if (width == this.maxWidth && height == this.maxHeight || bestComparator != null) break;
            if (this.settings.pot) {
                if (i % 3 == 0) {
                    grownPixels += MathUtils.nextPowerOfTwo((int)(width + 1)) - width;
                    if ((width = MathUtils.nextPowerOfTwo((int)(width + 1))) > this.maxWidth) {
                        ++i;
                        width -= grownPixels;
                        grownPixels = 0;
                    }
                } else if (i % 3 == 1) {
                    grownPixels += MathUtils.nextPowerOfTwo((int)(height + 1)) - height;
                    if ((height = MathUtils.nextPowerOfTwo((int)(height + 1))) > this.maxHeight) {
                        ++i;
                        height -= grownPixels;
                        grownPixels = 0;
                    }
                } else {
                    if (++ii % 2 == 1) {
                        width = MathUtils.nextPowerOfTwo((int)(width + 1));
                    } else {
                        height = MathUtils.nextPowerOfTwo((int)(height + 1));
                    }
                    ++i;
                }
            } else {
                int incr = 2;
                if (i % 3 == 0) {
                    if (width + incr >= MathUtils.nextPowerOfTwo((int)width)) {
                        width -= grownPixels;
                        grownPixels = 0;
                        ++i;
                    } else {
                        width += incr;
                        grownPixels += incr;
                    }
                } else if (i % 3 == 1) {
                    if (height + incr >= MathUtils.nextPowerOfTwo((int)height)) {
                        height -= grownPixels;
                        grownPixels = 0;
                        ++i;
                    } else {
                        height += incr;
                        grownPixels += incr;
                    }
                } else {
                    if (width == MathUtils.nextPowerOfTwo((int)width) && height == MathUtils.nextPowerOfTwo((int)height)) {
                        ++ii;
                    }
                    if (ii % 2 == 1) {
                        width += incr;
                    } else {
                        height += incr;
                    }
                    ++i;
                }
            }
            width = Math.min(this.maxWidth, width);
            height = Math.min(this.maxHeight, height);
        }
        if (bestComparator != null) {
            Collections.sort(this.images, bestComparator);
        } else {
            Collections.sort(this.images, secondBestComparator);
            bestWidth = secondBestWidth;
            bestHeight = secondBestHeight;
        }
        width = bestWidth;
        height = bestHeight;
        if (this.settings.pot) {
            width = MathUtils.nextPowerOfTwo((int)width);
            height = MathUtils.nextPowerOfTwo((int)height);
        }
        if (width > this.maxWidth || height > this.maxHeight) {
            System.out.println("ERROR: Images do not fit on max size: " + this.maxWidth + "x" + this.maxHeight);
            return false;
        }
        switch (this.filter.format != null ? this.filter.format : this.settings.defaultFormat) {
            case RGBA8888: 
            case RGBA4444: {
                type = 2;
                break;
            }
            case RGB565: 
            case RGB888: {
                type = 1;
                break;
            }
            case Alpha: {
                type = 10;
                break;
            }
            default: {
                throw new RuntimeException("Luminance Alpha format is not supported.");
            }
        }
        FileFormat fileFormat = this.filter.fileFormat != null ? this.filter.fileFormat : this.settings.defaultFileFormat;
        float imageQuality = this.settings.defaultImageQuality;
        int imageNumber = 1;
        File outputFile = new File(outputDir, prefix + imageNumber + "." + TexturePacker.getFileExtension(fileFormat));
        while (outputFile.exists()) {
            outputFile = new File(outputDir, prefix + ++imageNumber + "." + TexturePacker.getFileExtension(fileFormat));
        }
        this.writer.write("\n" + outputFile.getName() + "\n");
        if (this.filter.format != null) {
            this.writer.write("format: " + this.filter.format + "\n");
            Pixmap.Format format = this.filter.format;
        } else {
            this.writer.write("format: " + this.settings.defaultFormat + "\n");
            Pixmap.Format format = this.settings.defaultFormat;
        }
        if (this.filter.minFilter == null || this.filter.magFilter == null) {
            this.writer.write("filter: " + this.settings.defaultFilterMin + "," + this.settings.defaultFilterMag + "\n");
        } else {
            this.writer.write("filter: " + this.filter.minFilter + "," + this.filter.magFilter + "\n");
        }
        this.writer.write("repeat: " + (Object)((Object)this.filter.direction) + "\n");
        BufferedImage canvas = new BufferedImage(width, height, type);
        this.insert(canvas, this.images, bestWidth, bestHeight);
        TexturePacker.log("Writing " + canvas.getWidth() + "x" + canvas.getHeight() + ": " + outputFile);
        if (fileFormat == FileFormat.JPEG) {
            Iterator<ImageWriter> writers = ImageIO.getImageWritersByFormatName("jpg");
            ImageWriter writer = writers.next();
            ImageWriteParam param = writer.getDefaultWriteParam();
            param.setCompressionMode(2);
            param.setCompressionQuality(imageQuality);
            ImageOutputStream ios = ImageIO.createImageOutputStream(outputFile);
            writer.setOutput(ios);
            writer.write(null, new IIOImage(canvas, null, null), param);
            if (!this.settings.pot) {
                ios = ImageIO.createImageOutputStream(outputFile);
                writer.setOutput(ios);
                writer.write(null, new IIOImage(canvas, null, null), param);
            }
        } else {
            ImageIO.write((RenderedImage)canvas, TexturePacker.getFileExtension(fileFormat), outputFile);
            if (!this.settings.pot) {
                ImageIO.write((RenderedImage)this.squeeze(ImageIO.read(outputFile), "", true), TexturePacker.getFileExtension(fileFormat), outputFile);
            }
        }
        this.compressedSize += canvas.getWidth() * canvas.getHeight();
        return true;
    }

    private static String getFileExtension(FileFormat fileFormat) {
        String retVal = "";
        switch (fileFormat) {
            case PNG: {
                retVal = "png";
                break;
            }
            case JPEG: {
                retVal = "jpg";
            }
        }
        return retVal;
    }

    private int insert(BufferedImage canvas, ArrayList<Image> images, int width, int height) throws IOException {
        if (this.settings.debug && canvas != null) {
            Graphics g = canvas.getGraphics();
            g.setColor(Color.green);
            g.drawRect(0, 0, width - 1, height - 1);
        }
        int x = 0;
        int y = 0;
        if (this.settings.edgePadding) {
            if (!this.filter.direction.isX()) {
                x = this.xPadding;
                width -= this.xPadding;
            }
            if (!this.filter.direction.isY()) {
                y = this.yPadding;
                height -= this.yPadding;
            }
        } else {
            if (!this.filter.direction.isX()) {
                width += this.xPadding;
            }
            if (!this.filter.direction.isY()) {
                height += this.yPadding;
            }
        }
        Node root = new Node(x, y, width, height);
        int usedPixels = 0;
        for (int i = images.size() - 1; i >= 0; --i) {
            Image image = images.get(i);
            Node node = root.insert(image, false);
            if (node == null) {
                if (this.settings.rotate) {
                    node = root.insert(image, true);
                }
                if (node == null) continue;
            }
            usedPixels += image.getWidth() * image.getHeight();
            images.remove(i);
            if (canvas == null) continue;
            node.writePackEntry();
            Graphics2D g = (Graphics2D)canvas.getGraphics();
            if (image.rotate) {
                g.translate(node.left, node.top);
                g.rotate(-1.5707963705062866);
                g.translate(-node.left, -node.top);
                g.translate(-image.getWidth(), 0);
            }
            if (this.settings.duplicatePadding) {
                int amount = this.settings.padding / 2;
                int imageWidth = image.getWidth();
                int imageHeight = image.getHeight();
                g.drawImage(image, node.left - amount, node.top - amount, node.left, node.top, 0, 0, 1, 1, null);
                g.drawImage(image, node.left + imageWidth, node.top - amount, node.left + imageWidth + amount, node.top, 0, 0, 1, 1, null);
                g.drawImage(image, node.left - amount, node.top + imageHeight, node.left, node.top + imageHeight + amount, 0, 0, 1, 1, null);
                g.drawImage(image, node.left + imageWidth, node.top + imageHeight, node.left + imageWidth + amount, node.top + imageHeight + amount, 0, 0, 1, 1, null);
                g.drawImage(image, node.left, node.top - amount, node.left + imageWidth, node.top, 0, 0, imageWidth, 1, null);
                g.drawImage(image, node.left, node.top + imageHeight, node.left + imageWidth, node.top + imageHeight + amount, 0, imageHeight - 1, imageWidth, imageHeight, null);
                g.drawImage(image, node.left - amount, node.top, node.left, node.top + imageHeight, 0, 0, 1, imageHeight, null);
                g.drawImage(image, node.left + imageWidth, node.top, node.left + imageWidth + amount, node.top + imageHeight, imageWidth - 1, 0, imageWidth, imageHeight, null);
            }
            g.drawImage((java.awt.Image)image, node.left, node.top, null);
            if (image.rotate) {
                g.translate(image.getWidth(), 0);
                g.translate(node.left, node.top);
                g.rotate(1.5707963705062866);
                g.translate(-node.left, -node.top);
            }
            if (!this.settings.debug) continue;
            g.setColor(Color.magenta);
            int imageWidth = image.getWidth();
            int imageHeight = image.getHeight();
            if (image.rotate) {
                g.drawRect(node.left, node.top, imageHeight - 1, imageWidth - 1);
                continue;
            }
            g.drawRect(node.left, node.top, imageWidth - 1, imageHeight - 1);
        }
        return images.isEmpty() ? -1 : usedPixels;
    }

    private Image squeeze(BufferedImage source, String name, boolean skipTopLeft) {
        if (source == null) {
            return null;
        }
        if (!this.filter.accept(source)) {
            return null;
        }
        this.uncompressedSize += source.getWidth() * source.getHeight();
        WritableRaster alphaRaster = source.getAlphaRaster();
        if (alphaRaster == null || !this.settings.stripWhitespace || name.contains("_ws")) {
            return new Image(name, source, 0, 0, source.getWidth(), source.getHeight());
        }
        byte[] a = new byte[1];
        int top = 0;
        int bottom = source.getHeight();
        if (!this.filter.direction.isY()) {
            int alpha;
            int x;
            int y;
            if (!skipTopLeft) {
                block0: for (y = 0; y < source.getHeight(); ++y) {
                    for (x = 0; x < source.getWidth(); ++x) {
                        alphaRaster.getDataElements(x, y, a);
                        alpha = a[0];
                        if (alpha < 0) {
                            alpha += 256;
                        }
                        if (alpha > this.settings.alphaThreshold) break block0;
                    }
                    ++top;
                }
            }
            y = source.getHeight();
            block2: while (--y >= top) {
                for (x = 0; x < source.getWidth(); ++x) {
                    alphaRaster.getDataElements(x, y, a);
                    alpha = a[0];
                    if (alpha < 0) {
                        alpha += 256;
                    }
                    if (alpha > this.settings.alphaThreshold) break block2;
                }
                --bottom;
            }
        }
        int left = 0;
        int right = source.getWidth();
        if (!this.filter.direction.isX()) {
            int alpha;
            int y;
            int x;
            if (!skipTopLeft) {
                block4: for (x = 0; x < source.getWidth(); ++x) {
                    for (y = top; y < bottom; ++y) {
                        alphaRaster.getDataElements(x, y, a);
                        alpha = a[0];
                        if (alpha < 0) {
                            alpha += 256;
                        }
                        if (alpha > this.settings.alphaThreshold) break block4;
                    }
                    ++left;
                }
            }
            x = source.getWidth();
            block6: while (--x >= left) {
                for (y = top; y < bottom; ++y) {
                    alphaRaster.getDataElements(x, y, a);
                    alpha = a[0];
                    if (alpha < 0) {
                        alpha += 256;
                    }
                    if (alpha > this.settings.alphaThreshold) break block6;
                }
                --right;
            }
        }
        int newWidth = right - left;
        int newHeight = bottom - top;
        if (newWidth <= 0 || newHeight <= 0) {
            if (this.settings.ignoreBlankImages) {
                TexturePacker.log("Ignoring blank input image: " + name);
                return null;
            }
            return new Image(name, this.emptyImage, 0, 0, 1, 1);
        }
        return new Image(name, source, left, top, newWidth, newHeight);
    }

    private static String hash(BufferedImage image) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA1");
            WritableRaster raster = image.getRaster();
            byte[] pixel = new byte[4];
            for (int y = 0; y < image.getHeight(); ++y) {
                for (int x = 0; x < image.getWidth(); ++x) {
                    raster.getDataElements(x, y, pixel);
                    digest.update(pixel);
                }
            }
            return new BigInteger(1, digest.digest()).toString(16);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new RuntimeException(ex);
        }
    }

    private static void process(Settings settings, File rootDir, File inputDir, File outputDir, File packFile) throws IOException {
        File[] files;
        if (inputDir.getName().startsWith(".")) {
            return;
        }
        boolean skip = false;
        if (settings.incremental) {
            Long childCountOld;
            String rootFolderAbsolutePath;
            files = inputDir.listFiles();
            if (files == null) {
                return;
            }
            boolean noneHaveChanged = true;
            int childCountNow = 0;
            boolean useAbsolutePaths = true;
            if (settings.incrementalFilePath != null) {
                useAbsolutePaths = false;
            }
            for (File file : files) {
                String rootFolderAbsolutePath2;
                if (file.isDirectory()) continue;
                String path = file.getAbsolutePath();
                if (!useAbsolutePaths && TexturePacker.isSubPath(rootFolderAbsolutePath2 = rootDir.getAbsolutePath(), path)) {
                    path = TexturePacker.removeSubPath(rootFolderAbsolutePath2, path);
                }
                Long crcOld = settings.crcs.get(path);
                long crcNow = TexturePacker.crc(file);
                if (crcOld == null || crcOld != crcNow) {
                    noneHaveChanged = false;
                }
                settings.crcs.put(path, crcNow);
                ++childCountNow;
            }
            String path = inputDir.getAbsolutePath();
            if (!useAbsolutePaths && TexturePacker.isSubPath(rootFolderAbsolutePath = rootDir.getAbsolutePath(), path)) {
                path = TexturePacker.removeSubPath(rootFolderAbsolutePath, path);
            }
            if ((childCountOld = settings.crcs.get(path)) == null || (long)childCountNow != childCountOld) {
                noneHaveChanged = false;
            }
            settings.crcs.put(path, Long.valueOf(childCountNow));
            if (outputDir.exists()) {
                boolean foundPage = false;
                String prefix = inputDir.getName();
                for (File file : outputDir.listFiles()) {
                    if (!file.getName().startsWith(prefix)) continue;
                    foundPage = true;
                    break;
                }
                if (!foundPage) {
                    noneHaveChanged = false;
                }
            }
            String section = settings.packSections.get(inputDir.getName());
            if (noneHaveChanged && section != null) {
                FileWriter writer = new FileWriter(packFile, true);
                writer.append(section);
                writer.close();
                TexturePacker.log(inputDir.toString());
                TexturePacker.log("Skipping unchanged directory.");
                TexturePacker.log("");
                skip = true;
            }
        }
        if (!skip) {
            if (outputDir.exists()) {
                String prefix = inputDir.getName();
                for (File file : outputDir.listFiles()) {
                    if (!file.getName().startsWith(prefix) || !file.getName().endsWith("." + TexturePacker.getFileExtension(settings.defaultFileFormat))) continue;
                    file.delete();
                }
            }
            ArrayList<Texture.TextureFilter> filters = new ArrayList<Texture.TextureFilter>();
            filters.add(null);
            filters.addAll(Arrays.asList(Texture.TextureFilter.values()));
            ArrayList<Pixmap.Format> formats = new ArrayList<Pixmap.Format>();
            formats.add(null);
            formats.addAll(Arrays.asList(Pixmap.Format.values()));
            int n = formats.size();
            for (int i = 0; i < n; ++i) {
                Pixmap.Format format = (Pixmap.Format)formats.get(i);
                int nn = filters.size();
                for (int ii = 0; ii < nn; ++ii) {
                    Texture.TextureFilter min = (Texture.TextureFilter)filters.get(ii);
                    for (int iii = 0; iii < nn; ++iii) {
                        int width;
                        Texture.TextureFilter mag = (Texture.TextureFilter)filters.get(iii);
                        if (min == null && mag != null || min != null && mag == null) continue;
                        Filter filter = new Filter(Direction.none, settings.defaultFileFormat, format, -1, -1, min, mag);
                        new TexturePacker(settings, inputDir, filter, outputDir, packFile);
                        for (width = settings.minWidth; width <= settings.maxWidth; width <<= 1) {
                            filter = new Filter(Direction.x, settings.defaultFileFormat, format, width, -1, min, mag);
                            new TexturePacker(settings, inputDir, filter, outputDir, packFile);
                        }
                        for (int height = settings.minHeight; height <= settings.maxHeight; height <<= 1) {
                            filter = new Filter(Direction.y, settings.defaultFileFormat, format, -1, height, min, mag);
                            new TexturePacker(settings, inputDir, filter, outputDir, packFile);
                        }
                        for (width = settings.minWidth; width <= settings.maxWidth; width <<= 1) {
                            for (int height = settings.minHeight; height <= settings.maxHeight; height <<= 1) {
                                filter = new Filter(Direction.xy, settings.defaultFileFormat, format, width, height, min, mag);
                                new TexturePacker(settings, inputDir, filter, outputDir, packFile);
                            }
                        }
                    }
                }
            }
        }
        if ((files = inputDir.listFiles()) == null) {
            return;
        }
        for (File file : files) {
            if (!file.isDirectory()) continue;
            TexturePacker.process(settings, rootDir, file, outputDir, packFile);
        }
    }

    public static void process(Settings settings, String input, String output) {
        TexturePacker.process(settings, input, output, "pack");
    }

    public static void process(Settings settings, String input, String output, String packFileName) {
        try {
            File inputDir = new File(input);
            File outputDir = new File(output);
            if (!inputDir.isDirectory()) {
                System.out.println("Not a directory: " + inputDir);
                return;
            }
            File packFile = new File(outputDir, packFileName);
            File incrmentalFile = null;
            if (settings.incremental && packFile.exists()) {
                String imageName;
                BufferedReader reader;
                settings.crcs.clear();
                String incrementalFilePath = settings.incrementalFilePath;
                if (incrementalFilePath == null) {
                    incrementalFilePath = System.getProperty("user.home") + "/.texturepacker/" + TexturePacker.hash(inputDir.getAbsolutePath());
                }
                if ((incrmentalFile = new File(incrementalFilePath)).exists()) {
                    String crc;
                    String path;
                    reader = new BufferedReader(new FileReader(incrmentalFile));
                    while ((path = reader.readLine()) != null && (crc = reader.readLine()) != null) {
                        settings.crcs.put(path, Long.parseLong(crc));
                    }
                    reader.close();
                }
                reader = new BufferedReader(new FileReader(packFile));
                StringBuilder buffer = new StringBuilder(2048);
                while ((imageName = reader.readLine()) != null) {
                    String line;
                    if (imageName.length() == 0) continue;
                    String pageName = imageName.replaceAll("\\d+." + TexturePacker.getFileExtension(settings.defaultFileFormat) + "$", "");
                    String section = settings.packSections.get(pageName);
                    if (section != null) {
                        buffer.append(section);
                    }
                    buffer.append('\n');
                    buffer.append(imageName);
                    buffer.append('\n');
                    while ((line = reader.readLine()) != null && line.length() != 0) {
                        buffer.append(line);
                        buffer.append('\n');
                    }
                    settings.packSections.put(pageName, buffer.toString());
                    buffer.setLength(0);
                }
                reader.close();
            }
            packFile.delete();
            TexturePacker.process(settings, inputDir, inputDir, outputDir, packFile);
            if (incrmentalFile != null) {
                incrmentalFile.getParentFile().mkdirs();
                FileWriter writer = new FileWriter(incrmentalFile);
                for (Map.Entry<String, Long> entry : settings.crcs.entrySet()) {
                    writer.write(entry.getKey() + "\n");
                    writer.write(entry.getValue() + "\n");
                }
                writer.close();
            }
        }
        catch (IOException ex) {
            throw new GdxRuntimeException("Error packing images: " + input, (Throwable)ex);
        }
    }

    private static String hash(String value) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA1");
            digest.update(value.getBytes());
            return new BigInteger(1, digest.digest()).toString(16);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new RuntimeException(ex);
        }
    }

    private static long crc(File file) {
        try {
            int length;
            FileInputStream input = new FileInputStream(file);
            byte[] buffer = new byte[4096];
            CRC32 crc32 = new CRC32();
            while ((length = input.read(buffer)) != -1) {
                crc32.update(buffer, 0, length);
            }
            input.close();
            return crc32.getValue();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    static boolean isSubPath(String path, String subPath) {
        if (subPath.length() < path.length()) {
            return false;
        }
        String subPathSubString = subPath.substring(0, path.length());
        return subPathSubString.equals(path);
    }

    static boolean isAbsolutePath(String path) {
        return new File(path).isAbsolute();
    }

    static String removeSubPath(String path, String subPath) {
        return subPath.replace(path, "");
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 2) {
            System.out.println("Usage: INPUTDIR OUTPUTDIR");
            return;
        }
        String input = args[0];
        String output = args[1];
        Settings settings = new Settings();
        settings.alias = true;
        TexturePacker.process(settings, input, output);
    }

    static {
        imageComparators = new ArrayList();
        imageComparators.add(new Comparator<Image>(){

            @Override
            public int compare(Image image1, Image image2) {
                int diff = image1.getHeight() - image2.getHeight();
                if (diff != 0) {
                    return diff;
                }
                return image1.getWidth() - image2.getWidth();
            }
        });
        imageComparators.add(new Comparator<Image>(){

            @Override
            public int compare(Image image1, Image image2) {
                int diff = image1.getWidth() - image2.getWidth();
                if (diff != 0) {
                    return diff;
                }
                return image1.getHeight() - image2.getHeight();
            }
        });
        imageComparators.add(new Comparator<Image>(){

            @Override
            public int compare(Image image1, Image image2) {
                return image1.getWidth() * image1.getHeight() - image2.getWidth() * image2.getHeight();
            }
        });
        filterToAbbrev = new HashMap();
        filterToAbbrev.put(Texture.TextureFilter.Linear, "l");
        filterToAbbrev.put(Texture.TextureFilter.Nearest, "n");
        filterToAbbrev.put(Texture.TextureFilter.MipMap, "m");
        filterToAbbrev.put(Texture.TextureFilter.MipMapLinearLinear, "mll");
        filterToAbbrev.put(Texture.TextureFilter.MipMapLinearNearest, "mln");
        filterToAbbrev.put(Texture.TextureFilter.MipMapNearestLinear, "mnl");
        filterToAbbrev.put(Texture.TextureFilter.MipMapNearestNearest, "mnn");
        formatToAbbrev = new HashMap();
        formatToAbbrev.put(Pixmap.Format.RGBA8888, "rgba8");
        formatToAbbrev.put(Pixmap.Format.RGBA4444, "rgba4");
        formatToAbbrev.put(Pixmap.Format.RGB565, "rgb565");
        formatToAbbrev.put(Pixmap.Format.Alpha, "a");
    }

    public static class Settings {
        public Pixmap.Format defaultFormat = Pixmap.Format.RGBA8888;
        public float defaultImageQuality = 0.9f;
        public FileFormat defaultFileFormat = FileFormat.PNG;
        public Texture.TextureFilter defaultFilterMin = Texture.TextureFilter.Nearest;
        public Texture.TextureFilter defaultFilterMag = Texture.TextureFilter.Nearest;
        public int alphaThreshold = 0;
        public boolean pot = true;
        public int padding = 2;
        public boolean duplicatePadding = true;
        public boolean debug = false;
        public boolean rotate = false;
        public int minWidth = 128;
        public int minHeight = 128;
        public int maxWidth = 1024;
        public int maxHeight = 1024;
        public boolean stripWhitespace = false;
        public boolean incremental;
        public boolean alias = true;
        public boolean edgePadding = true;
        public boolean ignoreBlankImages = true;
        public String incrementalFilePath = null;
        HashMap<String, Long> crcs = new HashMap();
        HashMap<String, String> packSections = new HashMap();
    }

    private static enum Direction {
        x,
        y,
        xy,
        none;


        public boolean isX() {
            return this == x || this == xy;
        }

        public boolean isY() {
            return this == y || this == xy;
        }
    }

    private static class Filter
    implements FilenameFilter {
        Direction direction;
        FileFormat fileFormat;
        Pixmap.Format format;
        Texture.TextureFilter minFilter;
        Texture.TextureFilter magFilter;
        int width = -1;
        int height = -1;
        Settings settings;

        public Filter(Direction direction, FileFormat fileFormat, Pixmap.Format format, int width, int height, Texture.TextureFilter minFilter, Texture.TextureFilter magFilter) {
            this.direction = direction;
            this.fileFormat = fileFormat;
            this.format = format;
            this.width = width;
            this.height = height;
            this.minFilter = minFilter;
            this.magFilter = magFilter;
        }

        @Override
        public boolean accept(File dir, String name) {
            switch (this.direction) {
                case none: {
                    if (!name.contains("_x") && !name.contains("_y")) break;
                    return false;
                }
                case x: {
                    if (name.contains("_x") && !name.contains("_xy")) break;
                    return false;
                }
                case y: {
                    if (name.contains("_y") && !name.contains("_xy")) break;
                    return false;
                }
                case xy: {
                    if (name.contains("_xy")) break;
                    return false;
                }
            }
            if (this.format != null) {
                if (!name.contains("_" + formatToAbbrev.get(this.format))) {
                    return false;
                }
            } else {
                for (String f : formatToAbbrev.values()) {
                    if (!name.contains("_" + f)) continue;
                    return false;
                }
            }
            if (this.minFilter != null && this.magFilter != null) {
                if (!name.contains("_" + filterToAbbrev.get(this.minFilter) + "," + filterToAbbrev.get(this.magFilter) + ".") && !name.contains("_" + filterToAbbrev.get(this.minFilter) + "," + filterToAbbrev.get(this.magFilter) + "_")) {
                    return false;
                }
            } else {
                for (String f : filterToAbbrev.values()) {
                    String tag = "_" + f + ",";
                    int tagIndex = name.indexOf(tag);
                    if (tagIndex == -1) continue;
                    String rest = name.substring(tagIndex + tag.length());
                    for (String f2 : filterToAbbrev.values()) {
                        if (!rest.startsWith(f2 + ".") && !rest.startsWith(f2 + "_")) continue;
                        return false;
                    }
                }
            }
            return true;
        }

        public boolean accept(BufferedImage image) {
            if (this.width != -1 && image.getWidth() != this.width) {
                return false;
            }
            return this.height == -1 || image.getHeight() == this.height;
        }
    }

    public static enum FileFormat {
        PNG,
        JPEG;

    }

    private static class Image
    extends BufferedImage {
        final String name;
        final int offsetX;
        final int offsetY;
        final int originalWidth;
        final int originalHeight;
        boolean rotate;
        ArrayList<Image> aliases = new ArrayList();

        public Image(String name, BufferedImage src, int left, int top, int newWidth, int newHeight) {
            super(src.getColorModel(), src.getRaster().createWritableChild(left, top, newWidth, newHeight, 0, 0, null), src.getColorModel().isAlphaPremultiplied(), null);
            this.name = name;
            this.offsetX = left;
            this.offsetY = top;
            this.originalWidth = src.getWidth();
            this.originalHeight = src.getHeight();
        }

        @Override
        public String toString() {
            return this.name;
        }
    }

    private class Node {
        int left;
        int top;
        int width;
        int height;
        Node child1;
        Node child2;
        Image image;

        public Node(int left, int top, int width, int height) {
            this.left = left;
            this.top = top;
            this.width = width;
            this.height = height;
        }

        public Node insert(Image image, boolean rotate) throws IOException {
            if (this.image != null) {
                return null;
            }
            if (this.child1 != null) {
                Node newNode = this.child1.insert(image, rotate);
                if (newNode != null) {
                    return newNode;
                }
                return this.child2.insert(image, rotate);
            }
            int imageWidth = image.getWidth();
            int imageHeight = image.getHeight();
            if (rotate) {
                int temp = imageWidth;
                imageWidth = imageHeight;
                imageHeight = temp;
            }
            int neededWidth = imageWidth + TexturePacker.this.xPadding;
            int neededHeight = imageHeight + TexturePacker.this.yPadding;
            if (neededWidth > this.width || neededHeight > this.height) {
                return null;
            }
            if (neededWidth == this.width && neededHeight == this.height) {
                this.image = image;
                image.rotate = rotate;
                return this;
            }
            int dw = this.width - neededWidth;
            int dh = this.height - neededHeight;
            if (dw > dh) {
                this.child1 = new Node(this.left, this.top, neededWidth, this.height);
                this.child2 = new Node(this.left + neededWidth, this.top, this.width - neededWidth, this.height);
            } else {
                this.child1 = new Node(this.left, this.top, this.width, neededHeight);
                this.child2 = new Node(this.left, this.top + neededHeight, this.width, this.height - neededHeight);
            }
            return this.child1.insert(image, rotate);
        }

        void writePackEntry() throws IOException {
            this.writePackEntry(this.image, false);
            for (Image alias : this.image.aliases) {
                this.writePackEntry(alias, true);
            }
        }

        private void writePackEntry(Image image, boolean alias) throws IOException {
            int underscoreIndex;
            String imageName = image.name;
            imageName = imageName.replace("\\", "/");
            TexturePacker.log("Packing... " + imageName + (alias ? " (alias)" : ""));
            Matcher matcher = indexPattern.matcher(imageName);
            int index = -1;
            if (matcher.matches()) {
                index = Integer.parseInt(matcher.group(1));
            }
            if ((underscoreIndex = imageName.indexOf(95)) != -1) {
                imageName = imageName.substring(0, underscoreIndex);
            }
            TexturePacker.this.writer.write(imageName + "\n");
            TexturePacker.this.writer.write("  rotate: " + image.rotate + "\n");
            TexturePacker.this.writer.write("  xy: " + this.left + ", " + this.top + "\n");
            TexturePacker.this.writer.write("  size: " + image.getWidth() + ", " + image.getHeight() + "\n");
            TexturePacker.this.writer.write("  orig: " + image.originalWidth + ", " + image.originalHeight + "\n");
            TexturePacker.this.writer.write("  offset: " + image.offsetX + ", " + (image.originalHeight - image.getHeight() - image.offsetY) + "\n");
            TexturePacker.this.writer.write("  index: " + index + "\n");
        }
    }
}

