/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.tools.particleeditor;

import com.badlogic.gdx.ApplicationListener;
import com.badlogic.gdx.Files;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.InputProcessor;
import com.badlogic.gdx.backends.lwjgl.LwjglCanvas;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.ParticleEffect;
import com.badlogic.gdx.graphics.g2d.ParticleEmitter;
import com.badlogic.gdx.graphics.g2d.Sprite;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.tools.particleeditor.CountPanel;
import com.badlogic.gdx.tools.particleeditor.EditorPanel;
import com.badlogic.gdx.tools.particleeditor.EffectPanel;
import com.badlogic.gdx.tools.particleeditor.GradientPanel;
import com.badlogic.gdx.tools.particleeditor.ImagePanel;
import com.badlogic.gdx.tools.particleeditor.NumericPanel;
import com.badlogic.gdx.tools.particleeditor.OptionsPanel;
import com.badlogic.gdx.tools.particleeditor.PercentagePanel;
import com.badlogic.gdx.tools.particleeditor.RangedNumericPanel;
import com.badlogic.gdx.tools.particleeditor.ScaledNumericPanel;
import com.badlogic.gdx.tools.particleeditor.SpawnPanel;
import com.badlogic.gdx.utils.GdxRuntimeException;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.UIManager;
import javax.swing.border.CompoundBorder;
import javax.swing.plaf.basic.BasicSplitPaneUI;

public class ParticleEditor
extends JFrame {
    LwjglCanvas lwjglCanvas;
    JPanel rowsPanel;
    JPanel editRowsPanel;
    EffectPanel effectPanel;
    private JSplitPane splitPane;
    OrthographicCamera worldCamera;
    OrthographicCamera textCamera;
    ParticleEmitter.NumericValue pixelsPerMeter;
    ParticleEmitter.NumericValue zoomLevel;
    float pixelsPerMeterPrev;
    float zoomLevelPrev;
    ParticleEffect effect = new ParticleEffect();
    final HashMap<ParticleEmitter, ParticleData> particleData = new HashMap();

    public ParticleEditor() {
        super("Particle Editor");
        this.lwjglCanvas = new LwjglCanvas((ApplicationListener)new Renderer(), false);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent event) {
                System.exit(0);
            }
        });
        this.initializeComponents();
        this.setSize(950, 950);
        this.setLocationRelativeTo(null);
        this.setDefaultCloseOperation(2);
        this.setVisible(true);
    }

    void reloadRows() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                ParticleEditor.this.editRowsPanel.removeAll();
                ParticleEditor.this.addEditorRow(new NumericPanel("Pixels per meter", ParticleEditor.this.pixelsPerMeter));
                ParticleEditor.this.addEditorRow(new NumericPanel("Zoom level", ParticleEditor.this.zoomLevel));
                ParticleEditor.this.rowsPanel.removeAll();
                ParticleEmitter emitter = ParticleEditor.this.getEmitter();
                ParticleEditor.this.addRow(new ImagePanel(ParticleEditor.this));
                ParticleEditor.this.addRow(new RangedNumericPanel("Delay", emitter.getDelay()));
                ParticleEditor.this.addRow(new RangedNumericPanel("Duration", emitter.getDuration()));
                ParticleEditor.this.addRow(new CountPanel(ParticleEditor.this));
                ParticleEditor.this.addRow(new ScaledNumericPanel("Emission", "Duration", emitter.getEmission()));
                ParticleEditor.this.addRow(new ScaledNumericPanel("Life", "Duration", emitter.getLife()));
                ParticleEditor.this.addRow(new ScaledNumericPanel("Life Offset", "Duration", emitter.getLifeOffset()));
                ParticleEditor.this.addRow(new RangedNumericPanel("X Offset", emitter.getXOffsetValue()));
                ParticleEditor.this.addRow(new RangedNumericPanel("Y Offset", emitter.getYOffsetValue()));
                ParticleEditor.this.addRow(new SpawnPanel(emitter.getSpawnShape(), ParticleEditor.this));
                ParticleEditor.this.addRow(new ScaledNumericPanel("Spawn Width", "Duration", emitter.getSpawnWidth()));
                ParticleEditor.this.addRow(new ScaledNumericPanel("Spawn Height", "Duration", emitter.getSpawnHeight()));
                ParticleEditor.this.addRow(new ScaledNumericPanel("Size", "Life", emitter.getScale()));
                ParticleEditor.this.addRow(new ScaledNumericPanel("Velocity", "Life", emitter.getVelocity()));
                ParticleEditor.this.addRow(new ScaledNumericPanel("Angle", "Life", emitter.getAngle()));
                ParticleEditor.this.addRow(new ScaledNumericPanel("Rotation", "Life", emitter.getRotation()));
                ParticleEditor.this.addRow(new ScaledNumericPanel("Wind", "Life", emitter.getWind()));
                ParticleEditor.this.addRow(new ScaledNumericPanel("Gravity", "Life", emitter.getGravity()));
                ParticleEditor.this.addRow(new GradientPanel("Tint", emitter.getTint()));
                ParticleEditor.this.addRow(new PercentagePanel("Transparency", "Life", emitter.getTransparency()));
                ParticleEditor.this.addRow(new OptionsPanel(ParticleEditor.this));
                for (Component component : ParticleEditor.this.rowsPanel.getComponents()) {
                    if (!(component instanceof EditorPanel)) continue;
                    ((EditorPanel)component).update(ParticleEditor.this);
                }
                ParticleEditor.this.rowsPanel.repaint();
            }
        });
    }

    void addEditorRow(JPanel row) {
        row.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Color.black));
        this.editRowsPanel.add((Component)row, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
    }

    void addRow(JPanel row) {
        row.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Color.black));
        this.rowsPanel.add((Component)row, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void setVisible(String name, boolean visible) {
        for (Component component : this.rowsPanel.getComponents()) {
            if (!(component instanceof EditorPanel) || !((EditorPanel)component).getName().equals(name)) continue;
            component.setVisible(visible);
        }
    }

    public ParticleEmitter getEmitter() {
        return (ParticleEmitter)this.effect.getEmitters().get(this.effectPanel.editIndex);
    }

    public ImageIcon getIcon(ParticleEmitter emitter) {
        ParticleData data = this.particleData.get(emitter);
        if (data == null) {
            data = new ParticleData();
            this.particleData.put(emitter, data);
        }
        String imagePath = emitter.getImagePath();
        if (data.icon == null && imagePath != null) {
            try {
                URL url;
                File file = new File(imagePath);
                if (file.exists()) {
                    url = file.toURI().toURL();
                } else {
                    url = ParticleEditor.class.getResource(imagePath);
                    if (url == null) {
                        return null;
                    }
                }
                data.icon = new ImageIcon(url);
            }
            catch (MalformedURLException ex) {
                ex.printStackTrace();
            }
        }
        return data.icon;
    }

    public void setIcon(ParticleEmitter emitters, ImageIcon icon) {
        ParticleData data = this.particleData.get(emitters);
        if (data == null) {
            data = new ParticleData();
            this.particleData.put(emitters, data);
        }
        data.icon = icon;
    }

    public void setEnabled(ParticleEmitter emitter, boolean enabled) {
        ParticleData data = this.particleData.get(emitter);
        if (data == null) {
            data = new ParticleData();
            this.particleData.put(emitter, data);
        }
        data.enabled = enabled;
        emitter.reset();
    }

    public boolean isEnabled(ParticleEmitter emitter) {
        ParticleData data = this.particleData.get(emitter);
        if (data == null) {
            return true;
        }
        return data.enabled;
    }

    private void initializeComponents() {
        this.splitPane = new JSplitPane();
        this.splitPane.setUI(new BasicSplitPaneUI(){

            @Override
            public void paint(Graphics g, JComponent jc) {
            }
        });
        this.splitPane.setDividerSize(4);
        this.getContentPane().add((Component)this.splitPane, "Center");
        JSplitPane rightSplit = new JSplitPane(0);
        rightSplit.setUI(new BasicSplitPaneUI(){

            @Override
            public void paint(Graphics g, JComponent jc) {
            }
        });
        rightSplit.setDividerSize(4);
        this.splitPane.add((Component)rightSplit, "right");
        JPanel propertiesPanel = new JPanel(new GridBagLayout());
        rightSplit.add((Component)propertiesPanel, "top");
        propertiesPanel.setBorder(new CompoundBorder(BorderFactory.createEmptyBorder(3, 0, 6, 6), BorderFactory.createTitledBorder("Editor Properties")));
        JScrollPane scroll = new JScrollPane();
        propertiesPanel.add((Component)scroll, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 11, 1, new Insets(0, 0, 0, 0), 0, 0));
        scroll.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.editRowsPanel = new JPanel(new GridBagLayout());
        scroll.setViewportView(this.editRowsPanel);
        scroll.getVerticalScrollBar().setUnitIncrement(70);
        propertiesPanel = new JPanel(new GridBagLayout());
        rightSplit.add((Component)propertiesPanel, "bottom");
        propertiesPanel.setBorder(new CompoundBorder(BorderFactory.createEmptyBorder(3, 0, 6, 6), BorderFactory.createTitledBorder("Emitter Properties")));
        scroll = new JScrollPane();
        propertiesPanel.add((Component)scroll, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 11, 1, new Insets(0, 0, 0, 0), 0, 0));
        scroll.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.rowsPanel = new JPanel(new GridBagLayout());
        scroll.setViewportView(this.rowsPanel);
        scroll.getVerticalScrollBar().setUnitIncrement(70);
        rightSplit.setDividerLocation(200);
        JSplitPane leftSplit = new JSplitPane(0);
        leftSplit.setUI(new BasicSplitPaneUI(){

            @Override
            public void paint(Graphics g, JComponent jc) {
            }
        });
        leftSplit.setDividerSize(4);
        this.splitPane.add((Component)leftSplit, "left");
        JPanel spacer = new JPanel(new BorderLayout());
        leftSplit.add((Component)spacer, "top");
        spacer.add(this.lwjglCanvas.getCanvas());
        spacer.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 4));
        JPanel emittersPanel = new JPanel(new BorderLayout());
        leftSplit.add((Component)emittersPanel, "bottom");
        emittersPanel.setBorder(new CompoundBorder(BorderFactory.createEmptyBorder(0, 6, 6, 0), BorderFactory.createTitledBorder("Effect Emitters")));
        this.effectPanel = new EffectPanel(this);
        emittersPanel.add(this.effectPanel);
        leftSplit.setDividerLocation(625);
        this.splitPane.setDividerLocation(325);
    }

    public static void main(String[] args) {
        for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
            if (!"Nimbus".equals(info.getName())) continue;
            try {
                UIManager.setLookAndFeel(info.getClassName());
            }
            catch (Throwable ignored) {}
            break;
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new ParticleEditor();
            }
        });
    }

    static class ParticleData {
        public ImageIcon icon;
        public String imagePath;
        public boolean enabled = true;

        ParticleData() {
        }
    }

    class Renderer
    implements ApplicationListener,
    InputProcessor {
        private float maxActiveTimer;
        private int maxActive;
        private int lastMaxActive;
        private boolean mouseDown;
        private int activeCount;
        private int mouseX;
        private int mouseY;
        private BitmapFont font;
        private SpriteBatch spriteBatch;
        private Sprite bgImage;

        Renderer() {
        }

        public void create() {
            if (this.spriteBatch != null) {
                return;
            }
            Texture.setEnforcePotImages((boolean)false);
            this.spriteBatch = new SpriteBatch();
            ParticleEditor.this.worldCamera = new OrthographicCamera();
            ParticleEditor.this.textCamera = new OrthographicCamera();
            ParticleEditor.this.pixelsPerMeter = new ParticleEmitter.NumericValue();
            ParticleEditor.this.pixelsPerMeter.setValue(1.0f);
            ParticleEditor.this.pixelsPerMeter.setAlwaysActive(true);
            ParticleEditor.this.zoomLevel = new ParticleEmitter.NumericValue();
            ParticleEditor.this.zoomLevel.setValue(1.0f);
            ParticleEditor.this.zoomLevel.setAlwaysActive(true);
            this.font = new BitmapFont(Gdx.files.getFileHandle("default.fnt", Files.FileType.Internal), Gdx.files.getFileHandle("default.png", Files.FileType.Internal), true);
            ParticleEditor.this.effectPanel.newEmitter("Untitled", true);
            Gdx.input.setInputProcessor((InputProcessor)this);
        }

        public void resize(int width, int height) {
            Gdx.gl.glViewport(0, 0, width, height);
            if (ParticleEditor.this.pixelsPerMeter.getValue() <= 0.0f) {
                ParticleEditor.this.pixelsPerMeter.setValue(1.0f);
            }
            ParticleEditor.this.worldCamera.setToOrtho(false, (float)width / ParticleEditor.this.pixelsPerMeter.getValue(), (float)height / ParticleEditor.this.pixelsPerMeter.getValue());
            ParticleEditor.this.worldCamera.update();
            ParticleEditor.this.textCamera.setToOrtho(true, (float)width, (float)height);
            ParticleEditor.this.textCamera.update();
            ParticleEditor.this.effect.setPosition(ParticleEditor.this.worldCamera.viewportWidth / 2.0f, ParticleEditor.this.worldCamera.viewportHeight / 2.0f);
        }

        public void render() {
            int viewWidth = Gdx.graphics.getWidth();
            int viewHeight = Gdx.graphics.getHeight();
            float delta = Gdx.graphics.getDeltaTime();
            Gdx.gl.glClear(16384);
            if (ParticleEditor.this.pixelsPerMeter.getValue() != ParticleEditor.this.pixelsPerMeterPrev || ParticleEditor.this.zoomLevel.getValue() != ParticleEditor.this.zoomLevelPrev) {
                if (ParticleEditor.this.pixelsPerMeter.getValue() <= 0.0f) {
                    ParticleEditor.this.pixelsPerMeter.setValue(1.0f);
                }
                ParticleEditor.this.worldCamera.setToOrtho(false, (float)viewWidth / ParticleEditor.this.pixelsPerMeter.getValue(), (float)viewHeight / ParticleEditor.this.pixelsPerMeter.getValue());
                ParticleEditor.this.worldCamera.zoom = ParticleEditor.this.zoomLevel.getValue();
                ParticleEditor.this.worldCamera.update();
                ParticleEditor.this.effect.setPosition(ParticleEditor.this.worldCamera.viewportWidth / 2.0f, ParticleEditor.this.worldCamera.viewportHeight / 2.0f);
                ParticleEditor.this.zoomLevelPrev = ParticleEditor.this.zoomLevel.getValue();
                ParticleEditor.this.pixelsPerMeterPrev = ParticleEditor.this.pixelsPerMeter.getValue();
            }
            this.spriteBatch.setProjectionMatrix(ParticleEditor.this.worldCamera.combined);
            this.spriteBatch.begin();
            this.spriteBatch.enableBlending();
            this.spriteBatch.setBlendFunction(770, 771);
            if (this.bgImage != null) {
                this.bgImage.setPosition((float)(viewWidth / 2) - this.bgImage.getWidth() / 2.0f, (float)(viewHeight / 2) - this.bgImage.getHeight() / 2.0f);
                this.bgImage.draw(this.spriteBatch);
            }
            this.activeCount = 0;
            boolean complete = true;
            for (ParticleEmitter emitter : ParticleEditor.this.effect.getEmitters()) {
                boolean enabled;
                if (emitter.getSprite() == null && emitter.getImagePath() != null) {
                    this.loadImage(emitter);
                }
                if (!(enabled = ParticleEditor.this.isEnabled(emitter))) continue;
                if (emitter.getSprite() != null) {
                    emitter.draw(this.spriteBatch, delta);
                }
                this.activeCount += emitter.getActiveCount();
                if (emitter.isContinuous()) {
                    complete = false;
                }
                if (emitter.isComplete()) continue;
                complete = false;
            }
            if (complete) {
                ParticleEditor.this.effect.start();
            }
            this.maxActive = Math.max(this.maxActive, this.activeCount);
            this.maxActiveTimer += delta;
            if (this.maxActiveTimer > 3.0f) {
                this.maxActiveTimer = 0.0f;
                this.lastMaxActive = this.maxActive;
                this.maxActive = 0;
            }
            if (this.mouseDown) {
                // empty if block
            }
            this.spriteBatch.setProjectionMatrix(ParticleEditor.this.textCamera.combined);
            this.font.draw(this.spriteBatch, (CharSequence)("FPS: " + Gdx.graphics.getFramesPerSecond()), 5.0f, 15.0f);
            this.font.draw(this.spriteBatch, (CharSequence)("Count: " + this.activeCount), 5.0f, 35.0f);
            this.font.draw(this.spriteBatch, (CharSequence)("Max: " + this.lastMaxActive), 5.0f, 55.0f);
            this.font.draw(this.spriteBatch, (CharSequence)((int)(ParticleEditor.this.getEmitter().getPercentComplete() * 100.0f) + "%"), 5.0f, 75.0f);
            this.spriteBatch.end();
        }

        private void loadImage(ParticleEmitter emitter) {
            final String imagePath = emitter.getImagePath();
            String imageName = new File(imagePath.replace('\\', '/')).getName();
            try {
                FileHandle file = imagePath.equals("particle.png") ? Gdx.files.classpath(imagePath) : Gdx.files.absolute(imagePath);
                emitter.setSprite(new Sprite(new Texture(file)));
            }
            catch (GdxRuntimeException ex) {
                ex.printStackTrace();
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JOptionPane.showMessageDialog(ParticleEditor.this, "Error loading image:\n" + imagePath);
                    }
                });
                emitter.setImagePath(null);
            }
        }

        public boolean keyDown(int keycode) {
            return false;
        }

        public boolean keyUp(int keycode) {
            return false;
        }

        public boolean keyTyped(char character) {
            return false;
        }

        public boolean touchDown(int x, int y, int pointer, int newParam) {
            Vector3 touchPoint = new Vector3((float)x, (float)y, 0.0f);
            ParticleEditor.this.worldCamera.unproject(touchPoint);
            ParticleEditor.this.effect.setPosition(touchPoint.x, touchPoint.y);
            return false;
        }

        public boolean touchUp(int x, int y, int pointer, int button) {
            return false;
        }

        public boolean touchDragged(int x, int y, int pointer) {
            Vector3 touchPoint = new Vector3((float)x, (float)y, 0.0f);
            ParticleEditor.this.worldCamera.unproject(touchPoint);
            ParticleEditor.this.effect.setPosition(touchPoint.x, touchPoint.y);
            return false;
        }

        public void dispose() {
        }

        public void pause() {
        }

        public void resume() {
        }

        public boolean touchMoved(int x, int y) {
            return false;
        }

        public boolean scrolled(int amount) {
            return false;
        }
    }
}

