/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.tools.particleeditor;

import com.badlogic.gdx.graphics.g2d.ParticleEmitter;
import com.badlogic.gdx.tools.particleeditor.EditorPanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class RangedNumericPanel
extends EditorPanel {
    private final ParticleEmitter.RangedNumericValue value;
    JSpinner minSpinner;
    JSpinner maxSpinner;
    JButton rangeButton;
    JLabel label;

    public RangedNumericPanel(String name, final ParticleEmitter.RangedNumericValue value) {
        super(name, (ParticleEmitter.ParticleValue)value);
        this.value = value;
        this.initializeComponents();
        this.minSpinner.setValue(Float.valueOf(value.getLowMin()));
        this.maxSpinner.setValue(Float.valueOf(value.getLowMax()));
        this.minSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent event) {
                value.setLowMin(((Float)RangedNumericPanel.this.minSpinner.getValue()).floatValue());
                if (!RangedNumericPanel.this.maxSpinner.isVisible()) {
                    value.setLowMax(((Float)RangedNumericPanel.this.minSpinner.getValue()).floatValue());
                }
            }
        });
        this.maxSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent event) {
                value.setLowMax(((Float)RangedNumericPanel.this.maxSpinner.getValue()).floatValue());
            }
        });
        this.rangeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                boolean visible = !RangedNumericPanel.this.maxSpinner.isVisible();
                RangedNumericPanel.this.maxSpinner.setVisible(visible);
                RangedNumericPanel.this.rangeButton.setText(visible ? "<" : ">");
                JSpinner spinner = visible ? RangedNumericPanel.this.maxSpinner : RangedNumericPanel.this.minSpinner;
                value.setLowMax(((Float)spinner.getValue()).floatValue());
            }
        });
        if (value.getLowMin() == value.getLowMax()) {
            this.rangeButton.doClick(0);
        }
    }

    private void initializeComponents() {
        JPanel contentPanel = this.getContentPanel();
        this.label = new JLabel("Value:");
        contentPanel.add((Component)this.label, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 6), 0, 0));
        this.minSpinner = new JSpinner(new SpinnerNumberModel(new Float(0.0f), new Float(-99999.0f), new Float(99999.0f), new Float(1.0f)));
        contentPanel.add((Component)this.minSpinner, new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.maxSpinner = new JSpinner(new SpinnerNumberModel(new Float(0.0f), new Float(-99999.0f), new Float(99999.0f), new Float(1.0f)));
        contentPanel.add((Component)this.maxSpinner, new GridBagConstraints(4, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 6, 0, 0), 0, 0));
        this.rangeButton = new JButton("<");
        this.rangeButton.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        contentPanel.add((Component)this.rangeButton, new GridBagConstraints(5, 2, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 1, 0, 0), 0, 0));
    }
}

