/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.tools.particleeditor;

import com.badlogic.gdx.graphics.g2d.ParticleEmitter;
import com.badlogic.gdx.tools.particleeditor.Chart;
import com.badlogic.gdx.tools.particleeditor.EditorPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class ScaledNumericPanel
extends EditorPanel {
    final ParticleEmitter.ScaledNumericValue value;
    JSpinner lowMinSpinner;
    JSpinner lowMaxSpinner;
    JSpinner highMinSpinner;
    JSpinner highMaxSpinner;
    JCheckBox relativeCheckBox;
    Chart chart;
    JPanel formPanel;
    JButton expandButton;
    JButton lowRangeButton;
    JButton highRangeButton;

    public ScaledNumericPanel(String name, String chartTitle, final ParticleEmitter.ScaledNumericValue value) {
        super(name, (ParticleEmitter.ParticleValue)value);
        this.value = value;
        this.initializeComponents(chartTitle);
        this.lowMinSpinner.setValue(Float.valueOf(value.getLowMin()));
        this.lowMaxSpinner.setValue(Float.valueOf(value.getLowMax()));
        this.highMinSpinner.setValue(Float.valueOf(value.getHighMin()));
        this.highMaxSpinner.setValue(Float.valueOf(value.getHighMax()));
        this.chart.setValues(value.getTimeline(), value.getScaling());
        this.relativeCheckBox.setSelected(value.isRelative());
        this.lowMinSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent event) {
                value.setLowMin(((Float)ScaledNumericPanel.this.lowMinSpinner.getValue()).floatValue());
                if (!ScaledNumericPanel.this.lowMaxSpinner.isVisible()) {
                    value.setLowMax(((Float)ScaledNumericPanel.this.lowMinSpinner.getValue()).floatValue());
                }
            }
        });
        this.lowMaxSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent event) {
                value.setLowMax(((Float)ScaledNumericPanel.this.lowMaxSpinner.getValue()).floatValue());
            }
        });
        this.highMinSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent event) {
                value.setHighMin(((Float)ScaledNumericPanel.this.highMinSpinner.getValue()).floatValue());
                if (!ScaledNumericPanel.this.highMaxSpinner.isVisible()) {
                    value.setHighMax(((Float)ScaledNumericPanel.this.highMinSpinner.getValue()).floatValue());
                }
            }
        });
        this.highMaxSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent event) {
                value.setHighMax(((Float)ScaledNumericPanel.this.highMaxSpinner.getValue()).floatValue());
            }
        });
        this.relativeCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                value.setRelative(ScaledNumericPanel.this.relativeCheckBox.isSelected());
            }
        });
        this.lowRangeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                boolean visible = !ScaledNumericPanel.this.lowMaxSpinner.isVisible();
                ScaledNumericPanel.this.lowMaxSpinner.setVisible(visible);
                ScaledNumericPanel.this.lowRangeButton.setText(visible ? "<" : ">");
                GridBagLayout layout = (GridBagLayout)ScaledNumericPanel.this.formPanel.getLayout();
                GridBagConstraints constraints = layout.getConstraints(ScaledNumericPanel.this.lowRangeButton);
                constraints.gridx = visible ? 5 : 4;
                layout.setConstraints(ScaledNumericPanel.this.lowRangeButton, constraints);
                JSpinner spinner = visible ? ScaledNumericPanel.this.lowMaxSpinner : ScaledNumericPanel.this.lowMinSpinner;
                value.setLowMax(((Float)spinner.getValue()).floatValue());
            }
        });
        this.highRangeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                boolean visible = !ScaledNumericPanel.this.highMaxSpinner.isVisible();
                ScaledNumericPanel.this.highMaxSpinner.setVisible(visible);
                ScaledNumericPanel.this.highRangeButton.setText(visible ? "<" : ">");
                GridBagLayout layout = (GridBagLayout)ScaledNumericPanel.this.formPanel.getLayout();
                GridBagConstraints constraints = layout.getConstraints(ScaledNumericPanel.this.highRangeButton);
                constraints.gridx = visible ? 5 : 4;
                layout.setConstraints(ScaledNumericPanel.this.highRangeButton, constraints);
                JSpinner spinner = visible ? ScaledNumericPanel.this.highMaxSpinner : ScaledNumericPanel.this.highMinSpinner;
                value.setHighMax(((Float)spinner.getValue()).floatValue());
            }
        });
        this.expandButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                ScaledNumericPanel.this.chart.setExpanded(!ScaledNumericPanel.this.chart.isExpanded());
                boolean expanded = ScaledNumericPanel.this.chart.isExpanded();
                GridBagLayout layout = (GridBagLayout)ScaledNumericPanel.this.getContentPanel().getLayout();
                GridBagConstraints chartConstraints = layout.getConstraints(ScaledNumericPanel.this.chart);
                GridBagConstraints expandButtonConstraints = layout.getConstraints(ScaledNumericPanel.this.expandButton);
                if (expanded) {
                    ScaledNumericPanel.this.chart.setPreferredSize(new Dimension(150, 200));
                    ScaledNumericPanel.this.expandButton.setText("\ufffd");
                    chartConstraints.weightx = 1.0;
                    expandButtonConstraints.weightx = 0.0;
                } else {
                    ScaledNumericPanel.this.chart.setPreferredSize(new Dimension(150, 30));
                    ScaledNumericPanel.this.expandButton.setText("+");
                    chartConstraints.weightx = 0.0;
                    expandButtonConstraints.weightx = 1.0;
                }
                layout.setConstraints(ScaledNumericPanel.this.chart, chartConstraints);
                layout.setConstraints(ScaledNumericPanel.this.expandButton, expandButtonConstraints);
                ScaledNumericPanel.this.relativeCheckBox.setVisible(!expanded);
                ScaledNumericPanel.this.formPanel.setVisible(!expanded);
                ScaledNumericPanel.this.chart.revalidate();
            }
        });
        if (value.getLowMin() == value.getLowMax()) {
            this.lowRangeButton.doClick(0);
        }
        if (value.getHighMin() == value.getHighMax()) {
            this.highRangeButton.doClick(0);
        }
    }

    public JPanel getFormPanel() {
        return this.formPanel;
    }

    private void initializeComponents(String chartTitle) {
        JPanel contentPanel = this.getContentPanel();
        this.formPanel = new JPanel(new GridBagLayout());
        contentPanel.add((Component)this.formPanel, new GridBagConstraints(5, 5, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 6), 0, 0));
        JLabel label = new JLabel("High:");
        this.formPanel.add((Component)label, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 6), 0, 0));
        this.highMinSpinner = new JSpinner(new SpinnerNumberModel(new Float(0.0f), new Float(-99999.0f), new Float(99999.0f), new Float(1.0f)));
        this.formPanel.add((Component)this.highMinSpinner, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.highMaxSpinner = new JSpinner(new SpinnerNumberModel(new Float(0.0f), new Float(-99999.0f), new Float(99999.0f), new Float(1.0f)));
        this.formPanel.add((Component)this.highMaxSpinner, new GridBagConstraints(4, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 6, 0, 0), 0, 0));
        this.highRangeButton = new JButton("<");
        this.highRangeButton.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        this.formPanel.add((Component)this.highRangeButton, new GridBagConstraints(5, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 1, 0, 0), 0, 0));
        label = new JLabel("Low:");
        this.formPanel.add((Component)label, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 6), 0, 0));
        this.lowMinSpinner = new JSpinner(new SpinnerNumberModel(new Float(0.0f), new Float(-99999.0f), new Float(99999.0f), new Float(1.0f)));
        this.formPanel.add((Component)this.lowMinSpinner, new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.lowMaxSpinner = new JSpinner(new SpinnerNumberModel(new Float(0.0f), new Float(-99999.0f), new Float(99999.0f), new Float(1.0f)));
        this.formPanel.add((Component)this.lowMaxSpinner, new GridBagConstraints(4, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 6, 0, 0), 0, 0));
        this.lowRangeButton = new JButton("<");
        this.lowRangeButton.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        this.formPanel.add((Component)this.lowRangeButton, new GridBagConstraints(5, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 1, 0, 0), 0, 0));
        this.chart = new Chart(chartTitle){

            @Override
            public void pointsChanged() {
                ScaledNumericPanel.this.value.setTimeline(ScaledNumericPanel.this.chart.getValuesX());
                ScaledNumericPanel.this.value.setScaling(ScaledNumericPanel.this.chart.getValuesY());
            }
        };
        contentPanel.add((Component)this.chart, new GridBagConstraints(6, 5, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.chart.setPreferredSize(new Dimension(150, 30));
        this.expandButton = new JButton("+");
        contentPanel.add((Component)this.expandButton, new GridBagConstraints(7, 5, 1, 1, 1.0, 0.0, 16, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.expandButton.setBorder(BorderFactory.createEmptyBorder(4, 8, 4, 8));
        this.relativeCheckBox = new JCheckBox("Relative");
        contentPanel.add((Component)this.relativeCheckBox, new GridBagConstraints(7, 5, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 6, 0, 0), 0, 0));
    }
}

