/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.tools.skins;

import com.badlogic.gdx.ApplicationListener;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.backends.jogl.JoglApplication;
import com.badlogic.gdx.backends.jogl.JoglApplicationConfiguration;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.NinePatch;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.tools.FileProcessor;
import com.badlogic.gdx.tools.imagepacker.TexturePacker;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.Json;
import com.badlogic.gdx.utils.ObjectMap;
import com.badlogic.gdx.utils.OrderedMap;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.Writer;
import java.util.concurrent.CountDownLatch;
import javax.imageio.ImageIO;

public class SkinPacker {
    public static void process(TexturePacker.Settings settings, final File inputDir, final File skinFile, final File imageFile) throws Exception {
        Texture.setEnforcePotImages((boolean)false);
        final File packedDir = new File("temp-packed");
        new FileHandle(packedDir).deleteDirectory();
        imageFile.delete();
        final ObjectMap nameToSplits = new ObjectMap();
        final TexturePacker texturePacker = new TexturePacker(settings);
        FileProcessor regionProcessor = new FileProcessor(){

            @Override
            protected void processFile(FileProcessor.InputFile inputFile) throws Exception {
                texturePacker.addImage(ImageIO.read(inputFile.inputFile), inputFile.outputFile.getName());
            }
        };
        regionProcessor.setRecursive(false);
        regionProcessor.setInputFilter(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".png") && !name.endsWith(".9.png");
            }
        });
        regionProcessor.setOutputSuffix("");
        regionProcessor.process(inputDir, inputDir);
        FileProcessor ninePatchProcessor = new FileProcessor(){

            @Override
            protected void processFile(FileProcessor.InputFile inputFile) throws Exception {
                BufferedImage image = ImageIO.read(inputFile.inputFile);
                String name = inputFile.outputFile.getName();
                name = name.substring(0, name.length() - 2);
                image = this.split(image, name);
                texturePacker.addImage(image, name);
            }

            private BufferedImage split(BufferedImage image, String name) {
                nameToSplits.put((Object)name, (Object)SkinPacker.getSplits(image, name));
                BufferedImage newImage = new BufferedImage(image.getWidth() - 2, image.getHeight() - 2, 6);
                newImage.getGraphics().drawImage(image, 0, 0, newImage.getWidth(), newImage.getHeight(), 1, 1, image.getWidth() - 1, image.getHeight() - 1, null);
                return newImage;
            }
        };
        ninePatchProcessor.setRecursive(false);
        ninePatchProcessor.addInputSuffix(".9.png");
        ninePatchProcessor.setOutputSuffix("");
        ninePatchProcessor.process(inputDir, inputDir);
        final File packFile = new File(packedDir, "pack");
        texturePacker.process(packedDir, packFile, "skin");
        if (!packFile.exists()) {
            throw new RuntimeException("No images were packed from input directory: " + inputDir.getAbsolutePath());
        }
        JoglApplicationConfiguration config = new JoglApplicationConfiguration();
        config.width = 1;
        config.height = 1;
        config.title = "SkinPacker";
        final CountDownLatch latch = new CountDownLatch(2);
        new JoglApplication(new ApplicationListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void create() {
                try {
                    Skin skin = new Skin();
                    TextureAtlas.TextureAtlasData atlas = new TextureAtlas.TextureAtlasData(new FileHandle(packFile), new FileHandle(packedDir), true);
                    if (atlas.getPages().size > 1) {
                        throw new GdxRuntimeException("Skin images could not be packed on to a single image!");
                    }
                    Texture texture = new Texture(1, 1, Pixmap.Format.Alpha);
                    for (TextureAtlas.TextureAtlasData.Region region : atlas.getRegions()) {
                        Splits splits = (Splits)nameToSplits.get((Object)region.name);
                        TextureRegion textureRegion = new TextureRegion(texture, region.left, region.top, region.width, region.height);
                        if (splits == null) {
                            skin.addResource(region.name, (Object)textureRegion);
                            continue;
                        }
                        if (splits.singleRegion) {
                            skin.addResource(region.name, (Object)new NinePatch(textureRegion));
                            continue;
                        }
                        skin.addResource(region.name, (Object)new NinePatch(textureRegion, splits.startX, region.width - splits.endX, splits.startY, region.height - splits.endY));
                    }
                    FileHandle newSkinFile = new FileHandle(new File(inputDir, "temp-skin"));
                    skin.save(newSkinFile);
                    ((TextureAtlas.TextureAtlasData.Page)atlas.getPages().get((int)0)).textureFile.moveTo(new FileHandle(imageFile));
                    new FileHandle(packedDir).deleteDirectory();
                    Json json = new Json();
                    if (skinFile != null) {
                        FileHandle oldSkinFile = new FileHandle(skinFile);
                        OrderedMap oldSkin = (OrderedMap)json.fromJson(OrderedMap.class, oldSkinFile);
                        OrderedMap newSkin = (OrderedMap)json.fromJson(OrderedMap.class, newSkinFile);
                        OrderedMap oldResources = (OrderedMap)oldSkin.get((Object)"resources");
                        OrderedMap newResources = (OrderedMap)newSkin.get((Object)"resources");
                        OrderedMap newPatches = (OrderedMap)newResources.get((Object)NinePatch.class.getName());
                        newPatches.orderedKeys().sort();
                        oldResources.put((Object)NinePatch.class.getName(), (Object)newPatches);
                        OrderedMap newRegions = (OrderedMap)newResources.get((Object)TextureRegion.class.getName());
                        newRegions.orderedKeys().sort();
                        oldResources.put((Object)TextureRegion.class.getName(), (Object)newRegions);
                        Writer writer = oldSkinFile.writer(false);
                        try {
                            writer.write(json.prettyPrint((Object)oldSkin, 130));
                            writer.close();
                        }
                        catch (IOException ex) {
                            throw new RuntimeException(ex);
                        }
                    } else {
                        newSkinFile.moveTo(new FileHandle(inputDir).child("skin.json"));
                    }
                    newSkinFile.delete();
                }
                finally {
                    Gdx.app.exit();
                    latch.countDown();
                }
            }

            public void resume() {
            }

            public void resize(int width, int height) {
            }

            public void render() {
            }

            public void pause() {
            }

            public void dispose() {
            }
        }, config);
        latch.countDown();
        latch.await();
    }

    public static Splits getSplits(BufferedImage image, String name) {
        boolean singleRegion;
        int endY;
        int endX;
        WritableRaster raster = image.getRaster();
        int[] rgba = new int[4];
        int startX = 1;
        for (int x = 1; x < raster.getWidth() - 1; ++x) {
            raster.getPixel(x, 0, rgba);
            if (rgba[3] == 0) continue;
            if (rgba[0] != 0 || rgba[1] != 0 || rgba[2] != 0) {
                throw new RuntimeException("Unknown pixel:" + x + ",0: " + name);
            }
            startX = x;
            break;
        }
        for (endX = startX; endX < raster.getWidth() - 1; ++endX) {
            raster.getPixel(endX, 0, rgba);
            if (rgba[3] == 0) break;
            if (rgba[0] == 0 && rgba[1] == 0 && rgba[2] == 0) continue;
            throw new RuntimeException("Unknown pixel " + endX + ",0: " + name);
        }
        for (int x = endX + 1; x < raster.getWidth() - 1; ++x) {
            raster.getPixel(x, 0, rgba);
            if (rgba[3] == 0) continue;
            throw new RuntimeException("Unknown pixel " + x + ",0: " + name);
        }
        int startY = 1;
        for (int y = 1; y < raster.getHeight() - 1; ++y) {
            raster.getPixel(0, y, rgba);
            if (rgba[3] == 0) continue;
            if (rgba[0] != 0 || rgba[1] != 0 || rgba[2] != 0) {
                throw new RuntimeException("Unknown pixel: 0," + y + ": " + name);
            }
            startY = y;
            break;
        }
        for (endY = startY; endY < raster.getHeight() - 1; ++endY) {
            raster.getPixel(0, endY, rgba);
            if (rgba[3] == 0) break;
            if (rgba[0] == 0 && rgba[1] == 0 && rgba[2] == 0) continue;
            throw new RuntimeException("Unknown pixel 0," + endY + ": " + name);
        }
        for (int y = endY + 1; y < raster.getHeight() - 1; ++y) {
            raster.getPixel(0, y, rgba);
            if (rgba[3] == 0) continue;
            throw new RuntimeException("Unknown pixel 0," + y + ": " + name);
        }
        boolean bl = singleRegion = startX == 1 && endX == 1 && startY == 1 && endY == 1;
        if (singleRegion) {
            endX = raster.getWidth();
            endY = raster.getHeight();
        }
        Splits splits = new Splits();
        splits.startX = startX - 1;
        splits.endX = endX - 1;
        splits.startY = startY - 1;
        splits.endY = endY - 1;
        splits.singleRegion = singleRegion;
        return splits;
    }

    public static void main(String[] args) throws Exception {
        File inputDir = new File("C:/Users/Nate/Desktop/shit");
        File skinFile = new File("C:/Users/Nate/Desktop/shit/skin.json");
        File imageFile = new File("C:/Users/Nate/Desktop/shit/uiskin.png");
        TexturePacker.Settings settings = new TexturePacker.Settings();
        settings.defaultFilterMag = Texture.TextureFilter.Linear;
        settings.defaultFilterMin = Texture.TextureFilter.Linear;
        settings.duplicatePadding = false;
        SkinPacker.process(settings, inputDir, skinFile, imageFile);
    }

    public static class Splits {
        public int startX;
        public int endX;
        public int startY;
        public int endY;
        public boolean singleRegion;
    }
}

