/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna;

import [Lcom.sun.jna.WString;;
import [Ljava.lang.Object;;
import [Ljava.lang.String;;
import com.sun.jna.AltCallingConvention;
import com.sun.jna.Callback;
import com.sun.jna.CallbackParameterContext;
import com.sun.jna.CallbackProxy;
import com.sun.jna.CallbackResultContext;
import com.sun.jna.FromNativeConverter;
import com.sun.jna.Function;
import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.NativeMapped;
import com.sun.jna.NativeMappedConverter;
import com.sun.jna.NativeString;
import com.sun.jna.Pointer;
import com.sun.jna.StringArray;
import com.sun.jna.Structure;
import com.sun.jna.ToNativeConverter;
import com.sun.jna.TypeMapper;
import com.sun.jna.WString;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;

class CallbackReference
extends WeakReference {
    static final Map callbackMap = new WeakHashMap();
    static final Map directCallbackMap = new WeakHashMap();
    static final Map allocations = new WeakHashMap();
    private static final Method PROXY_CALLBACK_METHOD;
    Pointer cbstruct;
    CallbackProxy proxy;
    Method method;

    public static Callback getCallback(Class clazz, Pointer pointer) {
        return CallbackReference.getCallback(clazz, pointer, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Callback getCallback(Class clazz, Pointer pointer, boolean bl) {
        Map map;
        if (pointer == null) {
            return null;
        }
        if (!clazz.isInterface()) {
            throw new IllegalArgumentException("Callback type must be an interface");
        }
        Map map2 = map = bl ? directCallbackMap : callbackMap;
        synchronized (map2) {
            Object object;
            Object object2;
            Object object3;
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                object3 = (Callback)iterator.next();
                if (!clazz.isAssignableFrom(object3.getClass()) || !pointer.equals(object2 = (object = (CallbackReference)map.get(object3)) != null ? ((CallbackReference)object).getTrampoline() : CallbackReference.getNativeFunctionPointer((Callback)object3))) continue;
                return object3;
            }
            int n = AltCallingConvention.class.isAssignableFrom(clazz) ? 1 : 0;
            object3 = new HashMap();
            object = Native.getLibraryOptions(clazz);
            if (object != null) {
                object3.putAll(object);
            }
            object3.put("invoking-method", CallbackReference.getCallbackMethod(clazz));
            object2 = new NativeFunctionHandler(pointer, n, (Map)object3);
            Callback callback = (Callback)Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, (InvocationHandler)object2);
            map.put(callback, null);
            return callback;
        }
    }

    private CallbackReference(Callback callback, int n, boolean bl) {
        super(callback);
        Object object;
        Object object2;
        boolean bl2;
        TypeMapper typeMapper = Native.getTypeMapper(callback.getClass());
        String string = System.getProperty("os.arch").toLowerCase();
        boolean bl3 = bl2 = "ppc".equals(string) || "powerpc".equals(string);
        if (bl) {
            object2 = CallbackReference.getCallbackMethod(callback);
            object = ((Method)object2).getParameterTypes();
            for (int i = 0; i < ((Class<?>[])object).length; ++i) {
                if (bl2 && (object[i] == Float.TYPE || object[i] == Double.TYPE)) {
                    bl = false;
                    break;
                }
                if (typeMapper == null || typeMapper.getFromNativeConverter(object[i]) == null) continue;
                bl = false;
                break;
            }
            if (typeMapper != null && typeMapper.getToNativeConverter(((Method)object2).getReturnType()) != null) {
                bl = false;
            }
        }
        if (bl) {
            this.method = CallbackReference.getCallbackMethod(callback);
            Class[] classArray = this.method.getParameterTypes();
            Class<?> clazz = this.method.getReturnType();
            this.cbstruct = CallbackReference.createNativeCallback(callback, this.method, classArray, clazz, n, true);
        } else {
            this.proxy = callback instanceof CallbackProxy ? (CallbackProxy)callback : new DefaultCallbackProxy(CallbackReference.getCallbackMethod(callback), typeMapper);
            Class[] classArray = this.proxy.getParameterTypes();
            Class clazz = this.proxy.getReturnType();
            if (typeMapper != null) {
                for (int i = 0; i < classArray.length; ++i) {
                    object = typeMapper.getFromNativeConverter(classArray[i]);
                    if (object == null) continue;
                    classArray[i] = object.nativeType();
                }
                object2 = typeMapper.getToNativeConverter(clazz);
                if (object2 != null) {
                    clazz = object2.nativeType();
                }
            }
            for (int i = 0; i < classArray.length; ++i) {
                classArray[i] = this.getNativeType(classArray[i]);
                if (CallbackReference.isAllowableNativeType(classArray[i])) continue;
                object = "Callback argument " + classArray[i] + " requires custom type conversion";
                throw new IllegalArgumentException((String)object);
            }
            if (!CallbackReference.isAllowableNativeType(clazz = this.getNativeType(clazz))) {
                String string2 = "Callback return type " + clazz + " requires custom type conversion";
                throw new IllegalArgumentException(string2);
            }
            this.cbstruct = CallbackReference.createNativeCallback(this.proxy, PROXY_CALLBACK_METHOD, classArray, clazz, n, false);
        }
    }

    private Class getNativeType(Class clazz) {
        if (Structure.class.isAssignableFrom(clazz)) {
            Structure.newInstance(clazz);
            if (!Structure.ByValue.class.isAssignableFrom(clazz)) {
                return Pointer.class;
            }
        } else {
            if (NativeMapped.class.isAssignableFrom(clazz)) {
                return NativeMappedConverter.getInstance(clazz).nativeType();
            }
            if (clazz == String.class || clazz == WString.class || clazz == String;.class || clazz == WString;.class || Callback.class.isAssignableFrom(clazz)) {
                return Pointer.class;
            }
        }
        return clazz;
    }

    private static Method checkMethod(Method method) {
        if (method.getParameterTypes().length > 256) {
            String string = "Method signature exceeds the maximum parameter count: " + method;
            throw new UnsupportedOperationException(string);
        }
        return method;
    }

    static Class findCallbackClass(Class clazz) {
        if (!Callback.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException(clazz.getName() + " is not derived from com.sun.jna.Callback");
        }
        if (clazz.isInterface()) {
            return clazz;
        }
        Class<?>[] classArray = clazz.getInterfaces();
        for (int i = 0; i < classArray.length; ++i) {
            if (!(class$com$sun$jna$Callback == null ? CallbackReference.class$("com.sun.jna.Callback") : class$com$sun$jna$Callback).isAssignableFrom(classArray[i])) continue;
            try {
                CallbackReference.getCallbackMethod(classArray[i]);
                return classArray[i];
            }
            catch (IllegalArgumentException illegalArgumentException) {
                break;
            }
        }
        if (Callback.class.isAssignableFrom(clazz.getSuperclass())) {
            return CallbackReference.findCallbackClass(clazz.getSuperclass());
        }
        return clazz;
    }

    private static Method getCallbackMethod(Callback callback) {
        return CallbackReference.getCallbackMethod(CallbackReference.findCallbackClass(callback.getClass()));
    }

    private static Method getCallbackMethod(Class clazz) {
        Method[] methodArray = clazz.getDeclaredMethods();
        Method[] methodArray2 = clazz.getMethods();
        HashSet<Method> hashSet = new HashSet<Method>(Arrays.asList(methodArray));
        hashSet.retainAll(Arrays.asList(methodArray2));
        Method[] methodArray3 = hashSet.iterator();
        while (methodArray3.hasNext()) {
            Method method = (Method)methodArray3.next();
            if (!Callback.FORBIDDEN_NAMES.contains(method.getName())) continue;
            methodArray3.remove();
        }
        methodArray3 = hashSet.toArray(new Method[hashSet.size()]);
        if (methodArray3.length == 1) {
            return CallbackReference.checkMethod(methodArray3[0]);
        }
        for (int i = 0; i < methodArray3.length; ++i) {
            Method method = methodArray3[i];
            if (!"callback".equals(method.getName())) continue;
            return CallbackReference.checkMethod(method);
        }
        String string = "Callback must implement a single public method, or one public method named 'callback'";
        throw new IllegalArgumentException(string);
    }

    public Pointer getTrampoline() {
        return this.cbstruct.getPointer(0L);
    }

    protected void finalize() {
        CallbackReference.freeNativeCallback(this.cbstruct.peer);
        this.cbstruct.peer = 0L;
    }

    private Callback getCallback() {
        return (Callback)this.get();
    }

    private static Pointer getNativeFunctionPointer(Callback callback) {
        InvocationHandler invocationHandler;
        if (Proxy.isProxyClass(callback.getClass()) && (invocationHandler = Proxy.getInvocationHandler(callback)) instanceof NativeFunctionHandler) {
            return ((NativeFunctionHandler)invocationHandler).getPointer();
        }
        return null;
    }

    public static Pointer getFunctionPointer(Callback callback) {
        return CallbackReference.getFunctionPointer(callback, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Pointer getFunctionPointer(Callback callback, boolean bl) {
        Map map;
        Pointer pointer = null;
        if (callback == null) {
            return null;
        }
        pointer = CallbackReference.getNativeFunctionPointer(callback);
        if (pointer != null) {
            return pointer;
        }
        int n = callback instanceof AltCallingConvention ? 1 : 0;
        Map map2 = map = bl ? directCallbackMap : callbackMap;
        synchronized (map2) {
            CallbackReference callbackReference = (CallbackReference)map.get(callback);
            if (callbackReference == null) {
                callbackReference = new CallbackReference(callback, n, bl);
                map.put(callback, callbackReference);
            }
            return callbackReference.getTrampoline();
        }
    }

    private static boolean isAllowableNativeType(Class clazz) {
        return clazz == Void.TYPE || clazz == Void.class || clazz == Boolean.TYPE || clazz == Boolean.class || clazz == Byte.TYPE || clazz == Byte.class || clazz == Short.TYPE || clazz == Short.class || clazz == Character.TYPE || clazz == Character.class || clazz == Integer.TYPE || clazz == Integer.class || clazz == Long.TYPE || clazz == Long.class || clazz == Float.TYPE || clazz == Float.class || clazz == Double.TYPE || clazz == Double.class || Structure.ByValue.class.isAssignableFrom(clazz) && Structure.class.isAssignableFrom(clazz) || Pointer.class.isAssignableFrom(clazz);
    }

    private static Pointer getNativeString(Object object, boolean bl) {
        if (object != null) {
            NativeString nativeString = new NativeString(object.toString(), bl);
            allocations.put(object, nativeString);
            return nativeString.getPointer();
        }
        return null;
    }

    private static synchronized native Pointer createNativeCallback(Callback var0, Method var1, Class[] var2, Class var3, int var4, boolean var5);

    private static synchronized native void freeNativeCallback(long var0);

    static {
        try {
            PROXY_CALLBACK_METHOD = CallbackProxy.class.getMethod("callback", Object;.class);
        }
        catch (Exception exception) {
            throw new Error("Error looking up CallbackProxy.callback() method");
        }
    }

    private class DefaultCallbackProxy
    implements CallbackProxy {
        private Method callbackMethod;
        private ToNativeConverter toNative;
        private FromNativeConverter[] fromNative;

        public DefaultCallbackProxy(Method method, TypeMapper typeMapper) {
            this.callbackMethod = method;
            Class<?>[] classArray = method.getParameterTypes();
            Class<?> clazz = method.getReturnType();
            this.fromNative = new FromNativeConverter[classArray.length];
            if ((class$com$sun$jna$NativeMapped == null ? (class$com$sun$jna$NativeMapped = CallbackReference.class$("com.sun.jna.NativeMapped")) : class$com$sun$jna$NativeMapped).isAssignableFrom(clazz)) {
                this.toNative = NativeMappedConverter.getInstance(clazz);
            } else if (typeMapper != null) {
                this.toNative = typeMapper.getToNativeConverter(clazz);
            }
            for (int i = 0; i < this.fromNative.length; ++i) {
                if ((class$com$sun$jna$NativeMapped == null ? CallbackReference.class$("com.sun.jna.NativeMapped") : class$com$sun$jna$NativeMapped).isAssignableFrom(classArray[i])) {
                    this.fromNative[i] = new NativeMappedConverter(classArray[i]);
                    continue;
                }
                if (typeMapper == null) continue;
                this.fromNative[i] = typeMapper.getFromNativeConverter(classArray[i]);
            }
            if (!method.isAccessible()) {
                try {
                    method.setAccessible(true);
                }
                catch (SecurityException securityException) {
                    throw new IllegalArgumentException("Callback method is inaccessible, make sure the interface is public: " + method);
                }
            }
        }

        private Object invokeCallback(Object[] objectArray) {
            Object object;
            Class<?>[] classArray = this.callbackMethod.getParameterTypes();
            Object[] objectArray2 = new Object[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                object = classArray[i];
                Object object2 = objectArray[i];
                if (this.fromNative[i] != null) {
                    CallbackParameterContext callbackParameterContext = new CallbackParameterContext((Class)object, this.callbackMethod, objectArray, i);
                    objectArray2[i] = this.fromNative[i].fromNative(object2, callbackParameterContext);
                    continue;
                }
                objectArray2[i] = this.convertArgument(object2, (Class)object);
            }
            Object object3 = null;
            object = CallbackReference.this.getCallback();
            if (object != null) {
                try {
                    object3 = this.convertResult(this.callbackMethod.invoke(object, objectArray2));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    Native.getCallbackExceptionHandler().uncaughtException((Callback)object, illegalArgumentException);
                }
                catch (IllegalAccessException illegalAccessException) {
                    Native.getCallbackExceptionHandler().uncaughtException((Callback)object, illegalAccessException);
                }
                catch (InvocationTargetException invocationTargetException) {
                    Native.getCallbackExceptionHandler().uncaughtException((Callback)object, invocationTargetException.getTargetException());
                }
            }
            for (int i = 0; i < objectArray2.length; ++i) {
                if (!(objectArray2[i] instanceof Structure) || objectArray2[i] instanceof Structure.ByValue) continue;
                ((Structure)objectArray2[i]).autoWrite();
            }
            return object3;
        }

        public Object callback(Object[] objectArray) {
            try {
                return this.invokeCallback(objectArray);
            }
            catch (Throwable throwable) {
                Native.getCallbackExceptionHandler().uncaughtException(CallbackReference.this.getCallback(), throwable);
                return null;
            }
        }

        private Object convertArgument(Object object, Class clazz) {
            if (object instanceof Pointer) {
                if (clazz == (class$java$lang$String == null ? (class$java$lang$String = CallbackReference.class$("java.lang.String")) : class$java$lang$String)) {
                    object = ((Pointer)object).getString(0L);
                } else if (clazz == (class$com$sun$jna$WString == null ? (class$com$sun$jna$WString = CallbackReference.class$("com.sun.jna.WString")) : class$com$sun$jna$WString)) {
                    object = new WString(((Pointer)object).getString(0L, true));
                } else if (clazz == (array$Ljava$lang$String == null ? (array$Ljava$lang$String = CallbackReference.class$("[Ljava.lang.String;")) : array$Ljava$lang$String) || clazz == (array$Lcom$sun$jna$WString == null ? (array$Lcom$sun$jna$WString = CallbackReference.class$("[Lcom.sun.jna.WString;")) : array$Lcom$sun$jna$WString)) {
                    object = ((Pointer)object).getStringArray(0L, clazz == (array$Lcom$sun$jna$WString == null ? (array$Lcom$sun$jna$WString = CallbackReference.class$("[Lcom.sun.jna.WString;")) : array$Lcom$sun$jna$WString));
                } else if ((class$com$sun$jna$Callback == null ? (class$com$sun$jna$Callback = CallbackReference.class$("com.sun.jna.Callback")) : class$com$sun$jna$Callback).isAssignableFrom(clazz)) {
                    object = CallbackReference.getCallback(clazz, (Pointer)object);
                } else if ((class$com$sun$jna$Structure == null ? (class$com$sun$jna$Structure = CallbackReference.class$("com.sun.jna.Structure")) : class$com$sun$jna$Structure).isAssignableFrom(clazz)) {
                    Structure structure = Structure.newInstance(clazz);
                    if ((class$com$sun$jna$Structure$ByValue == null ? (class$com$sun$jna$Structure$ByValue = CallbackReference.class$("com.sun.jna.Structure$ByValue")) : class$com$sun$jna$Structure$ByValue).isAssignableFrom(clazz)) {
                        byte[] byArray = new byte[structure.size()];
                        ((Pointer)object).read(0L, byArray, 0, byArray.length);
                        structure.getPointer().write(0L, byArray, 0, byArray.length);
                    } else {
                        structure.useMemory((Pointer)object);
                    }
                    structure.read();
                    object = structure;
                }
            } else if ((Boolean.TYPE == clazz || (class$java$lang$Boolean == null ? (class$java$lang$Boolean = CallbackReference.class$("java.lang.Boolean")) : class$java$lang$Boolean) == clazz) && object instanceof Number) {
                object = Function.valueOf(((Number)object).intValue() != 0);
            }
            return object;
        }

        private Object convertResult(Object object) {
            Class<?> clazz;
            if (this.toNative != null) {
                object = this.toNative.toNative(object, new CallbackResultContext(this.callbackMethod));
            }
            if (object == null) {
                return null;
            }
            if ((class$com$sun$jna$Structure == null ? (class$com$sun$jna$Structure = CallbackReference.class$("com.sun.jna.Structure")) : class$com$sun$jna$Structure).isAssignableFrom(clazz = object.getClass())) {
                if ((class$com$sun$jna$Structure$ByValue == null ? (class$com$sun$jna$Structure$ByValue = CallbackReference.class$("com.sun.jna.Structure$ByValue")) : class$com$sun$jna$Structure$ByValue).isAssignableFrom(clazz)) {
                    return object;
                }
                return ((Structure)object).getPointer();
            }
            if (clazz == Boolean.TYPE || clazz == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = CallbackReference.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
                return Boolean.TRUE.equals(object) ? Function.INTEGER_TRUE : Function.INTEGER_FALSE;
            }
            if (clazz == (class$java$lang$String == null ? (class$java$lang$String = CallbackReference.class$("java.lang.String")) : class$java$lang$String) || clazz == (class$com$sun$jna$WString == null ? (class$com$sun$jna$WString = CallbackReference.class$("com.sun.jna.WString")) : class$com$sun$jna$WString)) {
                return CallbackReference.getNativeString(object, clazz == (class$com$sun$jna$WString == null ? (class$com$sun$jna$WString = CallbackReference.class$("com.sun.jna.WString")) : class$com$sun$jna$WString));
            }
            if (clazz == (array$Ljava$lang$String == null ? (array$Ljava$lang$String = CallbackReference.class$("[Ljava.lang.String;")) : array$Ljava$lang$String) || clazz == (class$com$sun$jna$WString == null ? (class$com$sun$jna$WString = CallbackReference.class$("com.sun.jna.WString")) : class$com$sun$jna$WString)) {
                StringArray stringArray = clazz == (array$Ljava$lang$String == null ? (array$Ljava$lang$String = CallbackReference.class$("[Ljava.lang.String;")) : array$Ljava$lang$String) ? new StringArray((String[])object) : new StringArray((WString[])object);
                allocations.put(object, stringArray);
                return stringArray;
            }
            if ((class$com$sun$jna$Callback == null ? (class$com$sun$jna$Callback = CallbackReference.class$("com.sun.jna.Callback")) : class$com$sun$jna$Callback).isAssignableFrom(clazz)) {
                return CallbackReference.getFunctionPointer((Callback)object);
            }
            return object;
        }

        public Class[] getParameterTypes() {
            return this.callbackMethod.getParameterTypes();
        }

        public Class getReturnType() {
            return this.callbackMethod.getReturnType();
        }
    }

    private static class NativeFunctionHandler
    implements InvocationHandler {
        private Function function;
        private Map options;

        public NativeFunctionHandler(Pointer pointer, int n, Map map) {
            this.function = new Function(pointer, n);
            this.options = map;
        }

        public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
            if (Library.Handler.OBJECT_TOSTRING.equals(method)) {
                String string = "Proxy interface to " + this.function;
                Method method2 = (Method)this.options.get("invoking-method");
                Class clazz = CallbackReference.findCallbackClass(method2.getDeclaringClass());
                string = string + " (" + clazz.getName() + ")";
                return string;
            }
            if (Library.Handler.OBJECT_HASHCODE.equals(method)) {
                return new Integer(this.hashCode());
            }
            if (Library.Handler.OBJECT_EQUALS.equals(method)) {
                Object object2 = objectArray[0];
                if (object2 != null && Proxy.isProxyClass(object2.getClass())) {
                    return Function.valueOf(Proxy.getInvocationHandler(object2) == this);
                }
                return Boolean.FALSE;
            }
            if (Function.isVarArgs(method)) {
                objectArray = Function.concatenateVarArgs(objectArray);
            }
            return this.function.invoke(method.getReturnType(), objectArray, this.options);
        }

        public Pointer getPointer() {
            return this.function;
        }
    }
}

