/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna;

import [Lcom.sun.jna.NativeMapped;;
import [Lcom.sun.jna.Pointer;;
import [Lcom.sun.jna.Structure;;
import [Lcom.sun.jna.WString;;
import [Ljava.lang.String;;
import com.sun.jna.Callback;
import com.sun.jna.CallbackReference;
import com.sun.jna.FromNativeConverter;
import com.sun.jna.FunctionParameterContext;
import com.sun.jna.FunctionResultContext;
import com.sun.jna.Memory;
import com.sun.jna.MethodParameterContext;
import com.sun.jna.MethodResultContext;
import com.sun.jna.Native;
import com.sun.jna.NativeLibrary;
import com.sun.jna.NativeMapped;
import com.sun.jna.NativeMappedConverter;
import com.sun.jna.NativeString;
import com.sun.jna.Pointer;
import com.sun.jna.StringArray;
import com.sun.jna.Structure;
import com.sun.jna.ToNativeContext;
import com.sun.jna.TypeMapper;
import com.sun.jna.WString;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Map;

public class Function
extends Pointer {
    public static final int MAX_NARGS = 256;
    public static final int C_CONVENTION = 0;
    public static final int ALT_CONVENTION = 1;
    private static final int MASK_CC = 3;
    public static final int THROW_LAST_ERROR = 4;
    static final Integer INTEGER_TRUE = new Integer(-1);
    static final Integer INTEGER_FALSE = new Integer(0);
    private NativeLibrary library;
    private final String functionName;
    int callFlags;
    final Map options;
    static final String OPTION_INVOKING_METHOD = "invoking-method";
    static /* synthetic */ Class array$Lcom$sun$jna$Structure$ByReference;

    public static Function getFunction(String string, String string2) {
        return NativeLibrary.getInstance(string).getFunction(string2);
    }

    public static Function getFunction(String string, String string2, int n) {
        return NativeLibrary.getInstance(string).getFunction(string2, n);
    }

    public static Function getFunction(Pointer pointer) {
        return Function.getFunction(pointer, 0);
    }

    public static Function getFunction(Pointer pointer, int n) {
        return new Function(pointer, n);
    }

    Function(NativeLibrary nativeLibrary, String string, int n) {
        this.checkCallingConvention(n & 3);
        if (string == null) {
            throw new NullPointerException("Function name must not be null");
        }
        this.library = nativeLibrary;
        this.functionName = string;
        this.callFlags = n;
        this.options = nativeLibrary.options;
        try {
            this.peer = nativeLibrary.getSymbolAddress(string);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            throw new UnsatisfiedLinkError("Error looking up function '" + string + "': " + unsatisfiedLinkError.getMessage());
        }
    }

    Function(Pointer pointer, int n) {
        this.checkCallingConvention(n & 3);
        if (pointer == null || pointer.peer == 0L) {
            throw new NullPointerException("Function address may not be null");
        }
        this.functionName = pointer.toString();
        this.callFlags = n;
        this.peer = pointer.peer;
        this.options = Collections.EMPTY_MAP;
    }

    private void checkCallingConvention(int n) throws IllegalArgumentException {
        switch (n) {
            case 0: 
            case 1: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Unrecognized calling convention: " + n);
            }
        }
    }

    public String getName() {
        return this.functionName;
    }

    public int getCallingConvention() {
        return this.callFlags & 3;
    }

    public Object invoke(Class clazz, Object[] objectArray) {
        return this.invoke(clazz, objectArray, this.options);
    }

    public Object invoke(Class clazz, Object[] objectArray, Map map) {
        Object object;
        Object[] objectArray2 = new Object[]{};
        if (objectArray != null) {
            if (objectArray.length > 256) {
                throw new UnsupportedOperationException("Maximum argument count is 256");
            }
            objectArray2 = new Object[objectArray.length];
            System.arraycopy(objectArray, 0, objectArray2, 0, objectArray2.length);
        }
        TypeMapper typeMapper = (TypeMapper)map.get("type-mapper");
        Method method = (Method)map.get(OPTION_INVOKING_METHOD);
        boolean bl = Boolean.TRUE.equals(map.get("allow-objects"));
        for (int i = 0; i < objectArray2.length; ++i) {
            objectArray2[i] = this.convertArgument(objectArray2, i, method, typeMapper, bl);
        }
        Class clazz2 = clazz;
        FromNativeConverter fromNativeConverter = null;
        if (NativeMapped.class.isAssignableFrom(clazz)) {
            object = NativeMappedConverter.getInstance(clazz);
            fromNativeConverter = object;
            clazz2 = ((NativeMappedConverter)object).nativeType();
        } else if (typeMapper != null && (fromNativeConverter = typeMapper.getFromNativeConverter(clazz)) != null) {
            clazz2 = fromNativeConverter.nativeType();
        }
        object = this.invoke(objectArray2, clazz2, bl);
        if (fromNativeConverter != null) {
            FunctionResultContext functionResultContext = method != null ? new MethodResultContext(clazz, this, objectArray, method) : new FunctionResultContext(clazz, this, objectArray);
            object = fromNativeConverter.fromNative(object, functionResultContext);
        }
        if (objectArray != null) {
            for (int i = 0; i < objectArray.length; ++i) {
                Object object2 = objectArray[i];
                if (object2 == null) continue;
                if (object2 instanceof Structure) {
                    if (object2 instanceof Structure.ByValue) continue;
                    ((Structure)object2).autoRead();
                    continue;
                }
                if (objectArray2[i] instanceof PostCallRead) {
                    ((PostCallRead)objectArray2[i]).read();
                    if (!(objectArray2[i] instanceof PointerArray)) continue;
                    PointerArray pointerArray = (PointerArray)objectArray2[i];
                    if (!(array$Lcom$sun$jna$Structure$ByReference == null ? Function.class$("[Lcom.sun.jna.Structure$ByReference;") : array$Lcom$sun$jna$Structure$ByReference).isAssignableFrom(object2.getClass())) continue;
                    Class<?> clazz3 = object2.getClass().getComponentType();
                    Structure[] structureArray = (Structure[])object2;
                    for (int j = 0; j < structureArray.length; ++j) {
                        Pointer pointer = pointerArray.getPointer(Pointer.SIZE * j);
                        structureArray[j] = Structure.updateStructureByReference(clazz3, structureArray[j], pointer);
                    }
                    continue;
                }
                if (!(array$Lcom$sun$jna$Structure == null ? Function.class$("[Lcom.sun.jna.Structure;") : array$Lcom$sun$jna$Structure).isAssignableFrom(object2.getClass())) continue;
                Structure.autoRead((Structure[])object2);
            }
        }
        return object;
    }

    Object invoke(Object[] objectArray, Class clazz, boolean bl) {
        Object object = null;
        if (clazz == null || clazz == Void.TYPE || clazz == Void.class) {
            this.invokeVoid(this.callFlags, objectArray);
            object = null;
        } else if (clazz == Boolean.TYPE || clazz == Boolean.class) {
            object = Function.valueOf(this.invokeInt(this.callFlags, objectArray) != 0);
        } else if (clazz == Byte.TYPE || clazz == Byte.class) {
            object = new Byte((byte)this.invokeInt(this.callFlags, objectArray));
        } else if (clazz == Short.TYPE || clazz == Short.class) {
            object = new Short((short)this.invokeInt(this.callFlags, objectArray));
        } else if (clazz == Character.TYPE || clazz == Character.class) {
            object = new Character((char)this.invokeInt(this.callFlags, objectArray));
        } else if (clazz == Integer.TYPE || clazz == Integer.class) {
            object = new Integer(this.invokeInt(this.callFlags, objectArray));
        } else if (clazz == Long.TYPE || clazz == Long.class) {
            object = new Long(this.invokeLong(this.callFlags, objectArray));
        } else if (clazz == Float.TYPE || clazz == Float.class) {
            object = new Float(this.invokeFloat(this.callFlags, objectArray));
        } else if (clazz == Double.TYPE || clazz == Double.class) {
            object = new Double(this.invokeDouble(this.callFlags, objectArray));
        } else if (clazz == String.class) {
            object = this.invokeString(this.callFlags, objectArray, false);
        } else if (clazz == WString.class) {
            String string = this.invokeString(this.callFlags, objectArray, true);
            if (string != null) {
                object = new WString(string);
            }
        } else if (Pointer.class.isAssignableFrom(clazz)) {
            object = this.invokePointer(this.callFlags, objectArray);
        } else if (Structure.class.isAssignableFrom(clazz)) {
            if (Structure.ByValue.class.isAssignableFrom(clazz)) {
                Structure structure = this.invokeStructure(this.callFlags, objectArray, Structure.newInstance(clazz));
                structure.autoRead();
                object = structure;
            } else {
                object = this.invokePointer(this.callFlags, objectArray);
                if (object != null) {
                    Structure structure = Structure.newInstance(clazz);
                    structure.useMemory((Pointer)object);
                    structure.autoRead();
                    object = structure;
                }
            }
        } else if (Callback.class.isAssignableFrom(clazz)) {
            object = this.invokePointer(this.callFlags, objectArray);
            if (object != null) {
                object = CallbackReference.getCallback(clazz, (Pointer)object);
            }
        } else if (clazz == String;.class) {
            Pointer pointer = this.invokePointer(this.callFlags, objectArray);
            if (pointer != null) {
                object = pointer.getStringArray(0L);
            }
        } else if (clazz == WString;.class) {
            Pointer pointer = this.invokePointer(this.callFlags, objectArray);
            if (pointer != null) {
                String[] stringArray = pointer.getStringArray(0L, true);
                WString[] wStringArray = new WString[stringArray.length];
                for (int i = 0; i < stringArray.length; ++i) {
                    wStringArray[i] = new WString(stringArray[i]);
                }
                object = wStringArray;
            }
        } else if (clazz == Pointer;.class) {
            Pointer pointer = this.invokePointer(this.callFlags, objectArray);
            if (pointer != null) {
                object = pointer.getPointerArray(0L);
            }
        } else if (bl) {
            object = this.invokeObject(this.callFlags, objectArray);
            if (object != null && !clazz.isAssignableFrom(object.getClass())) {
                throw new ClassCastException("Return type " + clazz + " does not match result " + object.getClass());
            }
        } else {
            throw new IllegalArgumentException("Unsupported return type " + clazz + " in function " + this.getName());
        }
        return object;
    }

    private Object convertArgument(Object[] objectArray, int n, Method method, TypeMapper typeMapper, boolean bl) {
        Object object;
        Structure[] structureArray;
        Class<?> clazz;
        Object object2 = objectArray[n];
        if (object2 != null) {
            clazz = object2.getClass();
            structureArray = null;
            if (NativeMapped.class.isAssignableFrom(clazz)) {
                structureArray = NativeMappedConverter.getInstance(clazz);
            } else if (typeMapper != null) {
                structureArray = typeMapper.getToNativeConverter(clazz);
            }
            if (structureArray != null) {
                object = method != null ? new MethodParameterContext(this, objectArray, n, method) : new FunctionParameterContext(this, objectArray, n);
                object2 = structureArray.toNative(object2, (ToNativeContext)object);
            }
        }
        if (object2 == null || this.isPrimitiveArray(object2.getClass())) {
            return object2;
        }
        clazz = object2.getClass();
        if (object2 instanceof Structure) {
            structureArray = (Structure)object2;
            structureArray.autoWrite();
            if (structureArray instanceof Structure.ByValue) {
                object = structureArray.getClass();
                if (method != null) {
                    Class<?>[] classArray = method.getParameterTypes();
                    if (Function.isVarArgs(method)) {
                        if (n < classArray.length - 1) {
                            object = classArray[n];
                        } else {
                            Class<?> clazz2 = classArray[classArray.length - 1].getComponentType();
                            if (clazz2 != Object.class) {
                                object = clazz2;
                            }
                        }
                    } else {
                        object = classArray[n];
                    }
                }
                if (Structure.ByValue.class.isAssignableFrom((Class<?>)object)) {
                    return structureArray;
                }
            }
            return structureArray.getPointer();
        }
        if (object2 instanceof Callback) {
            return CallbackReference.getFunctionPointer((Callback)object2);
        }
        if (object2 instanceof String) {
            return new NativeString((String)object2, false).getPointer();
        }
        if (object2 instanceof WString) {
            return new NativeString(object2.toString(), true).getPointer();
        }
        if (object2 instanceof Boolean) {
            return Boolean.TRUE.equals(object2) ? INTEGER_TRUE : INTEGER_FALSE;
        }
        if (String;.class == clazz) {
            return new StringArray((String[])object2);
        }
        if (WString;.class == clazz) {
            return new StringArray((WString[])object2);
        }
        if (Pointer;.class == clazz) {
            return new PointerArray((Pointer[])object2);
        }
        if (NativeMapped;.class.isAssignableFrom(clazz)) {
            return new NativeMappedArray((NativeMapped[])object2);
        }
        if (Structure;.class.isAssignableFrom(clazz)) {
            structureArray = (Structure[])object2;
            boolean bl2 = Structure.ByReference.class.isAssignableFrom((Class<?>)(object = clazz.getComponentType()));
            if (bl2) {
                Pointer[] pointerArray = new Pointer[structureArray.length + 1];
                for (int i = 0; i < structureArray.length; ++i) {
                    pointerArray[i] = structureArray[i] != null ? structureArray[i].getPointer() : null;
                }
                return new PointerArray(pointerArray);
            }
            if (structureArray.length == 0) {
                throw new IllegalArgumentException("Structure array must have non-zero length");
            }
            if (structureArray[0] == null) {
                Structure.newInstance(object).toArray(structureArray);
                return structureArray[0].getPointer();
            }
            Structure.autoWrite(structureArray);
            return structureArray[0].getPointer();
        }
        if (clazz.isArray()) {
            throw new IllegalArgumentException("Unsupported array argument type: " + clazz.getComponentType());
        }
        if (bl) {
            return object2;
        }
        if (!Native.isSupportedNativeType(object2.getClass())) {
            throw new IllegalArgumentException("Unsupported argument type " + object2.getClass().getName() + " at parameter " + n + " of function " + this.getName());
        }
        return object2;
    }

    private boolean isPrimitiveArray(Class clazz) {
        return clazz.isArray() && clazz.getComponentType().isPrimitive();
    }

    private native int invokeInt(int var1, Object[] var2);

    private native long invokeLong(int var1, Object[] var2);

    public void invoke(Object[] objectArray) {
        this.invoke(Void.class, objectArray);
    }

    private native void invokeVoid(int var1, Object[] var2);

    private native float invokeFloat(int var1, Object[] var2);

    private native double invokeDouble(int var1, Object[] var2);

    private String invokeString(int n, Object[] objectArray, boolean bl) {
        Pointer pointer = this.invokePointer(n, objectArray);
        String string = null;
        if (pointer != null) {
            string = bl ? pointer.getString(0L, bl) : pointer.getString(0L);
        }
        return string;
    }

    private native Pointer invokePointer(int var1, Object[] var2);

    private native Structure invokeStructure(int var1, Object[] var2, Structure var3);

    private native Object invokeObject(int var1, Object[] var2);

    public String toString() {
        if (this.library != null) {
            return "native function " + this.functionName + "(" + this.library.getName() + ")@0x" + Long.toHexString(this.peer);
        }
        return "native function@0x" + Long.toHexString(this.peer);
    }

    public Object invokeObject(Object[] objectArray) {
        return this.invoke(Object.class, objectArray);
    }

    public Pointer invokePointer(Object[] objectArray) {
        return (Pointer)this.invoke(Pointer.class, objectArray);
    }

    public String invokeString(Object[] objectArray, boolean bl) {
        Class clazz = bl ? WString.class : String.class;
        Object object = this.invoke(clazz, objectArray);
        return object != null ? object.toString() : null;
    }

    public int invokeInt(Object[] objectArray) {
        return (Integer)this.invoke(Integer.class, objectArray);
    }

    public long invokeLong(Object[] objectArray) {
        return (Long)this.invoke(Long.class, objectArray);
    }

    public float invokeFloat(Object[] objectArray) {
        return ((Float)this.invoke(Float.class, objectArray)).floatValue();
    }

    public double invokeDouble(Object[] objectArray) {
        return (Double)this.invoke(Double.class, objectArray);
    }

    public void invokeVoid(Object[] objectArray) {
        this.invoke(Void.class, objectArray);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (object.getClass() == this.getClass()) {
            Function function = (Function)object;
            return function.callFlags == this.callFlags && ((Object)function.options).equals(this.options) && function.peer == this.peer;
        }
        return false;
    }

    static Object[] concatenateVarArgs(Object[] objectArray) {
        if (objectArray != null && objectArray.length > 0) {
            Class<?> clazz;
            Object object = objectArray[objectArray.length - 1];
            Class<?> clazz2 = clazz = object != null ? object.getClass() : null;
            if (clazz != null && clazz.isArray()) {
                Object[] objectArray2 = (Object[])object;
                Object[] objectArray3 = new Object[objectArray.length + objectArray2.length];
                System.arraycopy(objectArray, 0, objectArray3, 0, objectArray.length - 1);
                System.arraycopy(objectArray2, 0, objectArray3, objectArray.length - 1, objectArray2.length);
                objectArray3[objectArray3.length - 1] = null;
                objectArray = objectArray3;
            }
        }
        return objectArray;
    }

    static boolean isVarArgs(Method method) {
        try {
            Method method2 = method.getClass().getMethod("isVarArgs", new Class[0]);
            return Boolean.TRUE.equals(method2.invoke((Object)method, new Object[0]));
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return false;
    }

    static Boolean valueOf(boolean bl) {
        return bl ? Boolean.TRUE : Boolean.FALSE;
    }

    private static class NativeMappedArray
    extends Memory
    implements PostCallRead {
        private final NativeMapped[] original;

        public NativeMappedArray(NativeMapped[] nativeMappedArray) {
            super(Native.getNativeSize(nativeMappedArray.getClass(), nativeMappedArray));
            this.original = nativeMappedArray;
            Class<?> clazz = nativeMappedArray.getClass().getComponentType();
            this.setValue(0L, this.original, this.original.getClass());
        }

        public void read() {
            this.getValue(0L, this.original.getClass(), this.original);
        }
    }

    private static class PointerArray
    extends Memory
    implements PostCallRead {
        private final Pointer[] original;

        public PointerArray(Pointer[] pointerArray) {
            super(Pointer.SIZE * (pointerArray.length + 1));
            this.original = pointerArray;
            for (int i = 0; i < pointerArray.length; ++i) {
                this.setPointer(i * Pointer.SIZE, pointerArray[i]);
            }
            this.setPointer(Pointer.SIZE * pointerArray.length, null);
        }

        public void read() {
            this.read(0L, this.original, 0, this.original.length);
        }
    }

    public static interface PostCallRead {
        public void read();
    }
}

