/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna;

import com.sun.jna.Function;
import com.sun.jna.FunctionMapper;
import com.sun.jna.InvocationMapper;
import com.sun.jna.NativeLibrary;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;

public interface Library {
    public static final String OPTION_TYPE_MAPPER = "type-mapper";
    public static final String OPTION_FUNCTION_MAPPER = "function-mapper";
    public static final String OPTION_INVOCATION_MAPPER = "invocation-mapper";
    public static final String OPTION_STRUCTURE_ALIGNMENT = "structure-alignment";
    public static final String OPTION_ALLOW_OBJECTS = "allow-objects";
    public static final String OPTION_CALLING_CONVENTION = "calling-convention";

    public static class Handler
    implements InvocationHandler {
        static final Method OBJECT_TOSTRING;
        static final Method OBJECT_HASHCODE;
        static final Method OBJECT_EQUALS;
        private final NativeLibrary nativeLibrary;
        private final Class interfaceClass;
        private final Map options;
        private FunctionMapper functionMapper;
        private final InvocationMapper invocationMapper;
        private final Map functions = new WeakHashMap();

        public Handler(String string, Class clazz, Map hashMap) {
            int n;
            if (string != null && "".equals(string.trim())) {
                throw new IllegalArgumentException("Invalid library name \"" + string + "\"");
            }
            this.interfaceClass = clazz;
            hashMap = new HashMap<String, Integer>(hashMap);
            int n2 = n = (1.class$com$sun$jna$AltCallingConvention == null ? (1.class$com$sun$jna$AltCallingConvention = 1.class$("com.sun.jna.AltCallingConvention")) : 1.class$com$sun$jna$AltCallingConvention).isAssignableFrom(clazz) ? 1 : 0;
            if (hashMap.get(Library.OPTION_CALLING_CONVENTION) == null) {
                hashMap.put(Library.OPTION_CALLING_CONVENTION, new Integer(n));
            }
            this.options = hashMap;
            this.nativeLibrary = NativeLibrary.getInstance(string, hashMap);
            this.functionMapper = (FunctionMapper)hashMap.get(Library.OPTION_FUNCTION_MAPPER);
            if (this.functionMapper == null) {
                this.functionMapper = new FunctionNameMap(hashMap);
            }
            this.invocationMapper = (InvocationMapper)hashMap.get(Library.OPTION_INVOCATION_MAPPER);
        }

        public NativeLibrary getNativeLibrary() {
            return this.nativeLibrary;
        }

        public String getLibraryName() {
            return this.nativeLibrary.getName();
        }

        public Class getInterfaceClass() {
            return this.interfaceClass;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
            if (OBJECT_TOSTRING.equals(method)) {
                return "Proxy interface to " + this.nativeLibrary;
            }
            if (OBJECT_HASHCODE.equals(method)) {
                return new Integer(this.hashCode());
            }
            if (OBJECT_EQUALS.equals(method)) {
                Object object2 = objectArray[0];
                if (object2 != null && Proxy.isProxyClass(object2.getClass())) {
                    return Function.valueOf(Proxy.getInvocationHandler(object2) == this);
                }
                return Boolean.FALSE;
            }
            FunctionInfo functionInfo = null;
            Map map = this.functions;
            synchronized (map) {
                functionInfo = (FunctionInfo)this.functions.get(method);
                if (functionInfo == null) {
                    functionInfo = new FunctionInfo();
                    functionInfo.isVarArgs = Function.isVarArgs(method);
                    if (this.invocationMapper != null) {
                        functionInfo.handler = this.invocationMapper.getInvocationHandler(this.nativeLibrary, method);
                    }
                    if (functionInfo.handler == null) {
                        String string = this.functionMapper.getFunctionName(this.nativeLibrary, method);
                        if (string == null) {
                            string = method.getName();
                        }
                        functionInfo.function = this.nativeLibrary.getFunction(string, method);
                        functionInfo.options = new HashMap(this.options);
                        functionInfo.options.put("invoking-method", method);
                    }
                    this.functions.put(method, functionInfo);
                }
            }
            if (functionInfo.isVarArgs) {
                objectArray = Function.concatenateVarArgs(objectArray);
            }
            if (functionInfo.handler != null) {
                return functionInfo.handler.invoke(object, method, objectArray);
            }
            return functionInfo.function.invoke(method.getReturnType(), objectArray, functionInfo.options);
        }

        static {
            try {
                OBJECT_TOSTRING = (1.class$java$lang$Object == null ? (1.class$java$lang$Object = 1.class$("java.lang.Object")) : 1.class$java$lang$Object).getMethod("toString", new Class[0]);
                OBJECT_HASHCODE = (1.class$java$lang$Object == null ? (1.class$java$lang$Object = 1.class$("java.lang.Object")) : 1.class$java$lang$Object).getMethod("hashCode", new Class[0]);
                OBJECT_EQUALS = (1.class$java$lang$Object == null ? (1.class$java$lang$Object = 1.class$("java.lang.Object")) : 1.class$java$lang$Object).getMethod("equals", 1.class$java$lang$Object == null ? (1.class$java$lang$Object = 1.class$("java.lang.Object")) : 1.class$java$lang$Object);
            }
            catch (Exception exception) {
                throw new Error("Error retrieving Object.toString() method");
            }
        }

        private static class FunctionInfo {
            InvocationHandler handler;
            Function function;
            boolean isVarArgs;
            Map options;

            private FunctionInfo() {
            }
        }

        private static class FunctionNameMap
        implements FunctionMapper {
            private final Map map;

            public FunctionNameMap(Map map) {
                this.map = new HashMap(map);
            }

            public String getFunctionName(NativeLibrary nativeLibrary, Method method) {
                String string = method.getName();
                if (this.map.containsKey(string)) {
                    return (String)this.map.get(string);
                }
                return string;
            }
        }
    }
}

