/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.javafreetype;

import com.sun.jna.Native;
import com.sun.jna.NativeLong;
import com.sun.jna.Platform;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.PointerByReference;
import de.matthiasmann.javafreetype.FT2Library;
import de.matthiasmann.javafreetype.FreeTypeException;
import de.matthiasmann.javafreetype.FreeTypeFont;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.SinglePixelPackedSampleModel;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

class FT2Helper {
    private static Boolean isAvailable;
    static FT2Library INSTANCE;
    static String nativeLibName;

    FT2Helper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static synchronized boolean isAvailable() {
        if (isAvailable == null) {
            try {
                String string = nativeLibName != null ? nativeLibName : (Platform.isWindows() ? "freetype6" : "freetype");
                INSTANCE = (FT2Library)Native.loadLibrary(string, FT2Library.class);
                Pointer pointer = FT2Helper.FT_Init_FreeType();
                try {
                    isAvailable = FT2Helper.checkLibrary(pointer);
                }
                finally {
                    INSTANCE.FT_Done_FreeType(pointer);
                }
            }
            catch (Throwable throwable) {
                isAvailable = Boolean.FALSE;
                FT2Helper.getLogger().log(Level.SEVERE, "Can't load FreeType2 library", throwable);
            }
        }
        return isAvailable;
    }

    static void checkAvailable() {
        if (!FT2Helper.isAvailable()) {
            throw new UnsupportedOperationException("FreeType2 library not available");
        }
    }

    static void checkReturnCode(int n) throws FreeTypeException {
        if (n != 0) {
            throw new FreeTypeException(n);
        }
    }

    static String trueTypeEngineToString(int n) {
        switch (n) {
            case 0: {
                return "NONE";
            }
            case 1: {
                return "UNPATENTED";
            }
            case 2: {
                return "PATENTED";
            }
        }
        return "unknown: " + n;
    }

    static boolean checkLibrary(Pointer pointer) {
        IntByReference intByReference = new IntByReference();
        IntByReference intByReference2 = new IntByReference();
        IntByReference intByReference3 = new IntByReference();
        INSTANCE.FT_Library_Version(pointer, intByReference, intByReference2, intByReference3);
        int n = -1;
        if (intByReference.getValue() > 2 || intByReference.getValue() == 2 && intByReference2.getValue() >= 2) {
            n = INSTANCE.FT_Get_TrueType_Engine_Type(pointer);
        }
        FT2Helper.getLogger().log(Level.INFO, "FreeType2 version: {0}.{1}.{2} TrueType engine: {3}", new Object[]{intByReference.getValue(), intByReference2.getValue(), intByReference3.getValue(), FT2Helper.trueTypeEngineToString(n)});
        int n2 = 2;
        int n3 = 3;
        if (intByReference.getValue() > 2) {
            return true;
        }
        if (intByReference.getValue() == 2 && intByReference2.getValue() >= 3) {
            return true;
        }
        FT2Helper.getLogger().log(Level.WARNING, "FreeType2 library too old");
        return false;
    }

    static Pointer FT_Init_FreeType() throws FreeTypeException {
        PointerByReference pointerByReference = new PointerByReference();
        FT2Helper.checkReturnCode(INSTANCE.FT_Init_FreeType(pointerByReference));
        return pointerByReference.getValue();
    }

    static FT2Library.FT_Face FT_New_Memory_Face(Pointer pointer, ByteBuffer byteBuffer, long l) throws FreeTypeException {
        PointerByReference pointerByReference = new PointerByReference();
        FT2Helper.checkReturnCode(INSTANCE.FT_New_Memory_Face(pointer, byteBuffer, new NativeLong((long)byteBuffer.remaining()), new NativeLong(l), pointerByReference));
        return new FT2Library.FT_Face(pointerByReference.getValue());
    }

    static int FT_IMAGE_TAG(int n, int n2, int n3, int n4) {
        return n << 24 | n2 << 16 | n3 << 8 | n4;
    }

    static int to26_6(float f) {
        return Math.round(Math.scalb(f, 6));
    }

    static int round26_6(NativeLong nativeLong) {
        return FT2Helper.round26_6(nativeLong.longValue());
    }

    static int round26_6(long l) {
        if (l < 0L) {
            return (int)(l - 32L >> 6);
        }
        return (int)(l + 32L >> 6);
    }

    static long FT_FixMul(long l, long l2) {
        long l3 = l * l2;
        l3 = l3 < 0L ? (l3 -= 32768L) : (l3 += 32768L);
        return l3 >> 16;
    }

    static boolean copyGlyphToBufferedImageGray(FT2Library.FT_Bitmap fT_Bitmap, BufferedImage bufferedImage, int n, int n2) {
        if (n + fT_Bitmap.width > bufferedImage.getWidth()) {
            return false;
        }
        if (n2 + fT_Bitmap.rows > bufferedImage.getHeight()) {
            return false;
        }
        DataBufferByte dataBufferByte = (DataBufferByte)bufferedImage.getRaster().getDataBuffer();
        byte[] byArray = dataBufferByte.getData();
        int n3 = ((ComponentSampleModel)bufferedImage.getSampleModel()).getScanlineStride();
        ByteBuffer byteBuffer = fT_Bitmap.buffer.getByteBuffer(0L, Math.abs(fT_Bitmap.pitch) * fT_Bitmap.rows);
        int n4 = fT_Bitmap.pitch < 0 ? -fT_Bitmap.pitch * (fT_Bitmap.rows - 1) : 0;
        int n5 = dataBufferByte.getOffset() + n2 * n3 + n;
        int n6 = 0;
        while (n6 < fT_Bitmap.rows) {
            for (int i = 0; i < fT_Bitmap.width; ++i) {
                byArray[n5 + i] = byteBuffer.get(n4 + i);
            }
            ++n6;
            n4 += fT_Bitmap.pitch;
            n5 += n3;
        }
        return true;
    }

    static boolean copyGlyphToBufferedImageIntARGB(FT2Library.FT_Bitmap fT_Bitmap, BufferedImage bufferedImage, int n, int n2, Color color) {
        if (n + fT_Bitmap.width > bufferedImage.getWidth()) {
            return false;
        }
        if (n2 + fT_Bitmap.rows > bufferedImage.getHeight()) {
            return false;
        }
        DataBufferInt dataBufferInt = (DataBufferInt)bufferedImage.getRaster().getDataBuffer();
        int[] nArray = dataBufferInt.getData();
        int n3 = ((SinglePixelPackedSampleModel)bufferedImage.getSampleModel()).getScanlineStride();
        ByteBuffer byteBuffer = fT_Bitmap.buffer.getByteBuffer(0L, Math.abs(fT_Bitmap.pitch) * fT_Bitmap.rows);
        int n4 = fT_Bitmap.pitch < 0 ? -fT_Bitmap.pitch * (fT_Bitmap.rows - 1) : 0;
        int n5 = dataBufferInt.getOffset() + n2 * n3 + n;
        int n6 = (color == null ? Color.WHITE : color).getRGB() & 0xFFFFFF;
        int n7 = 0;
        while (n7 < fT_Bitmap.rows) {
            for (int i = 0; i < fT_Bitmap.width; ++i) {
                nArray[n5 + i] = n6 | byteBuffer.get(n4 + i) << 24;
            }
            ++n7;
            n4 += fT_Bitmap.pitch;
            n5 += n3;
        }
        return true;
    }

    static boolean copyGlyphToByteBuffer(FT2Library.FT_Bitmap fT_Bitmap, ByteBuffer byteBuffer, int n) {
        ByteBuffer byteBuffer2 = fT_Bitmap.buffer.getByteBuffer(0L, Math.abs(fT_Bitmap.pitch) * fT_Bitmap.rows);
        int n2 = fT_Bitmap.pitch < 0 ? -fT_Bitmap.pitch * (fT_Bitmap.rows - 1) : 0;
        int n3 = byteBuffer.position();
        int n4 = 0;
        while (n4 < fT_Bitmap.rows) {
            byteBuffer2.clear().position(n2).limit(n2 + fT_Bitmap.width);
            byteBuffer.position(n3);
            byteBuffer.put(byteBuffer2);
            ++n4;
            n2 += fT_Bitmap.pitch;
            n3 += n;
        }
        return true;
    }

    static boolean copyGlyphToByteBuffer(FT2Library.FT_Bitmap fT_Bitmap, ByteBuffer byteBuffer, int n, short[] sArray) {
        ByteBuffer byteBuffer2 = fT_Bitmap.buffer.getByteBuffer(0L, Math.abs(fT_Bitmap.pitch) * fT_Bitmap.rows);
        int n2 = fT_Bitmap.pitch < 0 ? -fT_Bitmap.pitch * (fT_Bitmap.rows - 1) : 0;
        int n3 = byteBuffer.position();
        int n4 = fT_Bitmap.width;
        int n5 = 0;
        while (n5 < fT_Bitmap.rows) {
            int n6 = n3;
            for (int i = 0; i < n4; ++i) {
                int n7 = byteBuffer2.get(n2 + i) & 0xFF;
                if (n7 >= 128) {
                    ++n7;
                }
                int n8 = 0;
                while (n8 < sArray.length) {
                    byteBuffer.put(n6, (byte)(sArray[n8] + (sArray[n8 + 1] * n7 >> 8)));
                    n8 += 2;
                    ++n6;
                }
            }
            byteBuffer.position(n6);
            ++n5;
            n2 += fT_Bitmap.pitch;
            n3 += n;
        }
        return true;
    }

    static ByteBuffer inputStreamToByteBuffer(InputStream inputStream) throws IOException {
        int n;
        byte[] byArray;
        int n2 = 4096;
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
        while (true) {
            int n3;
            byArray = new byte[4096];
            n = 0;
            while ((n3 = inputStream.read(byArray, n, 4096 - n)) > 0 && (n += n3) < 4096) {
            }
            if (n != 4096) break;
            arrayList.add(byArray);
        }
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(arrayList.size() * 4096 + n);
        int n4 = arrayList.size();
        for (int i = 0; i < n4; ++i) {
            byteBuffer.put((byte[])arrayList.get(i));
        }
        arrayList.clear();
        byteBuffer.put(byArray, 0, n).flip();
        return byteBuffer;
    }

    static Logger getLogger() {
        return Logger.getLogger(FreeTypeFont.class.getName());
    }
}

