/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twlthemeeditor;

import de.matthiasmann.twl.GUI;
import de.matthiasmann.twl.Widget;
import de.matthiasmann.twl.input.Input;
import de.matthiasmann.twl.input.lwjgl.LWJGLInput;
import de.matthiasmann.twl.renderer.Renderer;
import de.matthiasmann.twl.renderer.lwjgl.LWJGLRenderer;
import de.matthiasmann.twl.theme.ThemeManager;
import de.matthiasmann.twlthemeeditor.gui.MainUI;
import de.matthiasmann.twlthemeeditor.gui.MessageLog;
import java.awt.Canvas;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.util.concurrent.atomic.AtomicReference;
import java.util.prefs.Preferences;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.lwjgl.LWJGLException;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.Sys;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.GL11;

public class Main
extends Frame {
    private static final String KEY_MAINWINDOW_X = "mainwindow.x";
    private static final String KEY_MAINWINDOW_Y = "mainwindow.y";
    private static final String KEY_MAINWINDOW_WIDTH = "mainwindow.width";
    private static final String KEY_MAINWINDOW_HEIGHT = "mainwindow.height";
    private static final int REQUIRED_LWJGL_VERSION_MAJOR = 2;
    private static final int REQUIRED_LWJGL_VERSION_MINOR = 6;
    final Canvas canvas;
    final AtomicReference<Dimension> newCanvasSize = new AtomicReference();
    volatile boolean closeRequested;

    public static void main(String[] stringArray) throws Exception {
        try {
            System.setProperty("org.lwjgl.input.Mouse.allowNegativeMouseCoords", "true");
            System.setProperty("sun.java2d.noddraw", "true");
            System.setProperty("sun.java2d.opengl", "false");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        int n = Display.getDesktopDisplayMode().getWidth();
        int n2 = Display.getDesktopDisplayMode().getHeight();
        final Preferences preferences = Preferences.userNodeForPackage(Main.class);
        int n3 = Math.max(400, Math.min(n, preferences.getInt(KEY_MAINWINDOW_WIDTH, n * 4 / 5)));
        int n4 = Math.max(300, Math.min(n2, preferences.getInt(KEY_MAINWINDOW_HEIGHT, n2 * 4 / 5)));
        final Main main = new Main();
        main.setSize(n3, n4);
        String string = preferences.get(KEY_MAINWINDOW_X, null);
        String string2 = preferences.get(KEY_MAINWINDOW_Y, null);
        if (string != null && string2 != null) {
            try {
                int n5 = Math.max(0, Math.min(n - n3, Integer.parseInt(string)));
                int n6 = Math.max(0, Math.min(n2 - n4, Integer.parseInt(string2)));
                main.setLocation(n5, n6);
            }
            catch (Throwable throwable) {
                main.setLocationRelativeTo(null);
            }
        } else {
            main.setLocationRelativeTo(null);
        }
        main.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                preferences.putInt(Main.KEY_MAINWINDOW_WIDTH, main.getWidth());
                preferences.putInt(Main.KEY_MAINWINDOW_HEIGHT, main.getHeight());
            }

            public void componentMoved(ComponentEvent componentEvent) {
                preferences.putInt(Main.KEY_MAINWINDOW_X, main.getX());
                preferences.putInt(Main.KEY_MAINWINDOW_Y, main.getY());
            }
        });
        main.setVisible(true);
        main.run();
        main.dispose();
        System.exit(0);
    }

    public Main() {
        super("TWL Theme editor");
        this.canvas = new Canvas();
        this.canvas.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                Main.this.newCanvasSize.set(Main.this.canvas.getSize());
            }
        });
        this.add((Component)this.canvas, "Center");
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(Main.class.getResource("icon16.png")));
        if (LWJGLUtil.getPlatform() == 3) {
            this.addWindowFocusListener(new WindowAdapter(){

                public void windowGainedFocus(WindowEvent windowEvent) {
                    Main.this.canvas.requestFocusInWindow();
                }
            });
        }
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                Main.this.closeRequested = true;
            }
        });
    }

    public void run() {
        try {
            Object object;
            boolean bl = false;
            Display.setParent((Canvas)this.canvas);
            try {
                Display.create();
            }
            catch (LWJGLException lWJGLException) {
                if (lWJGLException.getMessage().equals("Pixel format not accelerated")) {
                    try {
                        System.setProperty("org.lwjgl.opengl.Display.allowSoftwareOpenGL", "true");
                        Display.create();
                        bl = true;
                    }
                    catch (LWJGLException lWJGLException2) {
                        throw lWJGLException2;
                    }
                    catch (SecurityException securityException) {
                        throw lWJGLException;
                    }
                }
                throw lWJGLException;
            }
            Display.setVSyncEnabled((boolean)true);
            LWJGLRenderer lWJGLRenderer = new LWJGLRenderer();
            MainUI mainUI = new MainUI();
            GUI gUI = new GUI((Widget)mainUI, (Renderer)lWJGLRenderer, (Input)new LWJGLInput());
            mainUI.setFocusKeyEnabled(true);
            ThemeManager themeManager = ThemeManager.createThemeManager((URL)Main.class.getResource("gui.xml"), (Renderer)lWJGLRenderer);
            gUI.applyTheme(themeManager);
            if (bl) {
                object = new MessageLog.Category("OpenGL", MessageLog.CombineMode.NONE, 2);
                mainUI.addMessage(new MessageLog.Entry((MessageLog.Category)object, "Software OpenGL rendering in use", "Software OpenGL rendering offers poor performance which could make this editor hard to use.It is suggested to check that the latest graphics driver from the graphic card vendor is installed.", null, new MessageLog.EntryAction[0]));
                mainUI.openMessagesDialog();
            }
            object = null;
            Matcher matcher = Pattern.compile("^(\\d+)\\.(\\d+)(\\.\\d+)?").matcher(Sys.getVersion());
            if (matcher.matches()) {
                int n = Integer.parseInt(matcher.group(1));
                int n2 = Integer.parseInt(matcher.group(2));
                if (n < 2 || n == 2 && n2 < 6) {
                    object = "is too old and could result in mouse handling issues";
                }
            } else {
                object = "could not be parsed";
            }
            if (object != null) {
                MessageLog.Category category = new MessageLog.Category("LWJGL", MessageLog.CombineMode.NONE, 2);
                mainUI.addMessage(new MessageLog.Entry(category, "LWJGL version", "The used version of LWJGL (" + Sys.getVersion() + ") " + (String)object + ".\nIt is suggested to upgrade to LWJGL " + 2 + "." + 6 + " or later.", null, new MessageLog.EntryAction[0]));
                mainUI.openMessagesDialog();
            }
            while (!(Display.isCloseRequested() || this.closeRequested || mainUI.isCloseRequested())) {
                Dimension dimension = this.newCanvasSize.getAndSet(null);
                if (dimension != null) {
                    GL11.glViewport((int)0, (int)0, (int)dimension.width, (int)dimension.height);
                    lWJGLRenderer.syncViewportSize();
                }
                GL11.glClear((int)16384);
                gUI.update();
                Display.update();
            }
            gUI.destroy();
            themeManager.destroy();
        }
        catch (Throwable throwable) {
            Main.showErrMsg(throwable);
        }
        Display.destroy();
    }

    public static void showErrMsg(Throwable throwable) {
        throwable.printStackTrace();
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        printWriter.flush();
        Sys.alert((String)"TWL Theme Editor - unhandled exception", (String)stringWriter.toString());
    }
}

