/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twlthemeeditor;

import de.matthiasmann.twlthemeeditor.VirtualFile;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.ArrayList;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestEnv
extends URLStreamHandler {
    private final ArrayList<VirtualFile> files = new ArrayList();

    public void unregisterFile(VirtualFile virtualFile) {
        this.files.remove(virtualFile);
    }

    public void unregisterFiles(Collection<VirtualFile> collection) {
        this.files.removeAll(collection);
    }

    public void registerFile(VirtualFile virtualFile) {
        this.files.add(virtualFile);
    }

    public VirtualFile registerFile(final URL uRL) {
        VirtualFile virtualFile = new VirtualFile(){

            @Override
            public String getVirtualFileName() {
                return uRL.getFile();
            }

            @Override
            public Object getContent(Class<?> clazz) throws IOException {
                return uRL.getContent(new Class[]{clazz});
            }

            @Override
            public InputStream openStream() throws IOException {
                return uRL.openStream();
            }
        };
        this.registerFile(virtualFile);
        return virtualFile;
    }

    protected VirtualFile findVirtualFile(String string) {
        for (VirtualFile virtualFile : this.files) {
            String string2 = virtualFile.getVirtualFileName();
            if (!string2.equals(string)) continue;
            return virtualFile;
        }
        return null;
    }

    @Override
    protected URLConnection openConnection(URL uRL) throws IOException {
        final String string = uRL.getFile();
        final VirtualFile virtualFile = this.findVirtualFile(string);
        return new URLConnection(uRL){

            public void connect() throws IOException {
                if (virtualFile == null) {
                    throw new FileNotFoundException(string);
                }
            }

            public Object getContent(Class[] classArray) throws IOException {
                if (virtualFile != null && classArray.length > 0) {
                    return virtualFile.getContent(classArray[0]);
                }
                return null;
            }

            public InputStream getInputStream() throws IOException {
                if (virtualFile == null) {
                    throw new FileNotFoundException(string);
                }
                return virtualFile.openStream();
            }
        };
    }

    public URL getURL(String string) throws MalformedURLException {
        return new URL("testenv", "local", 80, string, this);
    }
}

