/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twlthemeeditor.datamodel;

import de.matthiasmann.twl.model.Property;
import de.matthiasmann.twl.model.TreeTableNode;
import de.matthiasmann.twlthemeeditor.datamodel.DomXPPParser;
import de.matthiasmann.twlthemeeditor.datamodel.Kind;
import de.matthiasmann.twlthemeeditor.datamodel.ThemeFile;
import de.matthiasmann.twlthemeeditor.datamodel.ThemeTreeNode;
import de.matthiasmann.twlthemeeditor.datamodel.ThemeTreeOperation;
import de.matthiasmann.twlthemeeditor.datamodel.operations.CloneNodeOperation;
import de.matthiasmann.twlthemeeditor.datamodel.operations.CreateChildOperation;
import de.matthiasmann.twlthemeeditor.properties.AttributeProperty;
import de.matthiasmann.twlthemeeditor.properties.ElementTextProperty;
import de.matthiasmann.twlthemeeditor.properties.HasProperties;
import de.matthiasmann.twlthemeeditor.properties.KeyStrokeProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InputMapAction
extends ThemeTreeNode
implements HasProperties {
    protected final AttributeProperty nameProperty;
    protected final KeyStrokeProperty keyBindingProperty;

    public InputMapAction(ThemeFile themeFile, TreeTableNode treeTableNode, Element element) {
        super(themeFile, treeTableNode, element);
        this.nameProperty = new AttributeProperty(element, "name");
        this.addProperty((Property<?>)this.nameProperty);
        this.keyBindingProperty = new KeyStrokeProperty((Property<String>)new ElementTextProperty(element, "key binding"), (Property<String>)this.nameProperty);
        this.addProperty(this.keyBindingProperty);
    }

    @Override
    public void addChildren() throws IOException {
    }

    @Override
    public void addToXPP(DomXPPParser domXPPParser) {
        domXPPParser.addElement(this, this.element);
    }

    @Override
    public Kind getKind() {
        return Kind.NONE;
    }

    @Override
    public String getName() {
        return this.nameProperty.getPropertyValue();
    }

    @Override
    public List<ThemeTreeOperation> getOperations() {
        List<ThemeTreeOperation> list = super.getOperations();
        list.add(new CloneNodeOperation(this.element, this));
        return list;
    }

    @Override
    public List<CreateChildOperation> getCreateChildOperations() {
        return new ArrayList<CreateChildOperation>();
    }
}

