/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twlthemeeditor.datamodel;

import de.matthiasmann.twl.Alignment;
import de.matthiasmann.twl.model.Property;
import de.matthiasmann.twl.model.TreeTableNode;
import de.matthiasmann.twlthemeeditor.VirtualFile;
import de.matthiasmann.twlthemeeditor.datamodel.DomWrapper;
import de.matthiasmann.twlthemeeditor.datamodel.DomXPPParser;
import de.matthiasmann.twlthemeeditor.datamodel.FontDef;
import de.matthiasmann.twlthemeeditor.datamodel.InputMapDef;
import de.matthiasmann.twlthemeeditor.datamodel.Kind;
import de.matthiasmann.twlthemeeditor.datamodel.Theme;
import de.matthiasmann.twlthemeeditor.datamodel.ThemeFile;
import de.matthiasmann.twlthemeeditor.datamodel.ThemeTreeNode;
import de.matthiasmann.twlthemeeditor.datamodel.ThemeTreeOperation;
import de.matthiasmann.twlthemeeditor.datamodel.Utils;
import de.matthiasmann.twlthemeeditor.datamodel.operations.CloneNodeOperation;
import de.matthiasmann.twlthemeeditor.datamodel.operations.CreateChildOperation;
import de.matthiasmann.twlthemeeditor.datamodel.operations.CreateNewParam;
import de.matthiasmann.twlthemeeditor.datamodel.operations.CreateNewParamEnum;
import de.matthiasmann.twlthemeeditor.datamodel.operations.CreateNewParamFontDef;
import de.matthiasmann.twlthemeeditor.properties.AttributeProperty;
import de.matthiasmann.twlthemeeditor.properties.BooleanProperty;
import de.matthiasmann.twlthemeeditor.properties.BorderProperty;
import de.matthiasmann.twlthemeeditor.properties.DerivedNodeReferenceProperty;
import de.matthiasmann.twlthemeeditor.properties.DimensionProperty;
import de.matthiasmann.twlthemeeditor.properties.ElementTextProperty;
import de.matthiasmann.twlthemeeditor.properties.EnumProperty;
import de.matthiasmann.twlthemeeditor.properties.GapProperty;
import de.matthiasmann.twlthemeeditor.properties.HasProperties;
import de.matthiasmann.twlthemeeditor.properties.IntegerFormulaProperty;
import de.matthiasmann.twlthemeeditor.properties.NameProperty;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Param
extends ThemeTreeNode
implements HasProperties {
    protected final Theme theme;
    protected final NameProperty nameProperty;
    protected final Element valueElement;
    protected String icon;
    protected Property<?> valueProperty;
    protected ArrayList<VirtualFile> virtualFontFiles;
    protected Property<String> fileNameProperty;
    protected DerivedNodeReferenceProperty refProperty;
    private static final HashMap<String, String> ICON_MAP = new HashMap();

    public Param(Theme theme, TreeTableNode treeTableNode, Element element) throws IOException {
        super(theme.getThemeFile(), treeTableNode, element);
        this.theme = theme;
        this.nameProperty = new NameProperty((Property)new AttributeProperty(element, "name"), null, null, false){

            public void validateName(String string) throws IllegalArgumentException {
                if (string.endsWith(".") || string.startsWith(".")) {
                    throw new IllegalArgumentException("Name can not start or end with '.'");
                }
                if (string.indexOf(42) >= 0) {
                    throw new IllegalArgumentException("name can not contain '*'");
                }
            }
        };
        this.addProperty(this.nameProperty);
        this.valueElement = Param.getFirstChildElement(element);
        if (this.valueElement != null) {
            String string = this.valueElement.getName();
            this.icon = ICON_MAP.get(string);
            if (this.isFontDef()) {
                this.initFontDef();
            } else if (this.isInputMapDef()) {
                this.initInputMapDef();
            } else {
                this.initValueProperty();
            }
        }
    }

    protected final boolean isMap() {
        return this.valueElement != null && "map".equals(this.valueElement.getName());
    }

    protected final boolean isFontDef() {
        return this.valueElement != null && "fontDef".equals(this.valueElement.getName());
    }

    protected final boolean isInputMapDef() {
        return this.valueElement != null && "inputMapDef".equals(this.valueElement.getName());
    }

    private void initFontDef() throws IOException {
        this.virtualFontFiles = new ArrayList();
        this.fileNameProperty = new AttributeProperty(this.valueElement, "filename", "Font file name", true);
        this.fileNameProperty.addValueChangedCallback(new Runnable(){

            public void run() {
                try {
                    Param.this.registerFontFiles();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        });
        this.addProperty(this.fileNameProperty);
        FontDef.addCommonFontDefProperties(this, this.valueElement);
        this.registerFontFiles();
    }

    private void initInputMapDef() {
        this.refProperty = new DerivedNodeReferenceProperty((Property<String>)new AttributeProperty(this.valueElement, "ref", "Base input map reference", true), this, Kind.INPUTMAP);
        this.addProperty(this.refProperty);
    }

    private void initValueProperty() {
        this.valueProperty = Param.createProperty(this.valueElement, this, this.theme.getLimit());
        if (this.valueProperty != null) {
            this.addProperty(this.valueProperty);
        }
    }

    @Override
    public String getName() {
        return this.nameProperty.getPropertyValue();
    }

    @Override
    protected String getIcon() {
        return this.icon;
    }

    boolean isWildcard() {
        return this.valueProperty instanceof DerivedNodeReferenceProperty && ((DerivedNodeReferenceProperty)this.valueProperty).isWildcard();
    }

    @Override
    public String getDisplayName() {
        String string = this.getName();
        if (this.isWildcard()) {
            if (string.isEmpty()) {
                return "*";
            }
            return string.concat(".*");
        }
        return string;
    }

    public Object getTooltipContent(int n) {
        if (this.isWildcard()) {
            return "Wildcard reference";
        }
        return null;
    }

    @Override
    public Kind getKind() {
        return Kind.NONE;
    }

    @Override
    protected String getType() {
        return "param-" + this.valueElement.getName();
    }

    public Element getValueElement() {
        return this.valueElement;
    }

    public Property<?> getValueProperty() {
        return this.valueProperty;
    }

    @Override
    public void addChildren() throws IOException {
        if (this.isMap()) {
            this.addChildren(this.theme.getThemeFile(), this.valueElement, new DomWrapper(){

                public TreeTableNode wrap(ThemeFile themeFile, ThemeTreeNode themeTreeNode, Element element) throws IOException {
                    if ("param".equals(element.getName())) {
                        return new Param(Param.this.theme, (TreeTableNode)themeTreeNode, element);
                    }
                    return null;
                }
            });
        }
        if (this.isFontDef()) {
            this.addChildren(this.theme.getThemeFile(), this.valueElement, new FontDef.DomWrapperImpl());
        }
        if (this.isInputMapDef()) {
            this.addChildren(this.theme.getThemeFile(), this.valueElement, new InputMapDef.DomWrapperImpl());
        }
    }

    @Override
    public void addToXPP(DomXPPParser domXPPParser) {
        if (this.isMap()) {
            domXPPParser.addStartTag((Object)this, this.element.getName(), this.element.getAttributes());
            domXPPParser.addStartTag((Object)this, "map", new Attribute[0]);
            Utils.addToXPP(domXPPParser, this);
            domXPPParser.addEndTag("map");
            domXPPParser.addEndTag(this.element.getName());
        } else if (this.isFontDef()) {
            domXPPParser.addStartTag((Object)this, this.element.getName(), this.element.getAttributes());
            Utils.addToXPP(domXPPParser, "fontDef", this, this.valueElement.getAttributes());
            domXPPParser.addEndTag(this.element.getName());
        } else if (this.isInputMapDef()) {
            domXPPParser.addStartTag((Object)this, this.element.getName(), this.element.getAttributes());
            Utils.addToXPP(domXPPParser, "inputMapDef", this, this.valueElement.getAttributes());
            domXPPParser.addEndTag(this.element.getName());
        } else {
            domXPPParser.addElement(this, this.element);
        }
    }

    @Override
    public boolean canPasteElement(Element element) {
        if (this.isFontDef()) {
            return FontDef.canPasteFontDefElement(element);
        }
        if (this.isInputMapDef()) {
            return InputMapDef.canPasteInputMapDefElement(element);
        }
        if (this.isMap()) {
            return "param".equals(element.getName());
        }
        return false;
    }

    @Override
    public List<ThemeTreeOperation> getOperations() {
        List<ThemeTreeOperation> list = super.getOperations();
        list.add(new CloneNodeOperation(this.element, this));
        return list;
    }

    @Override
    public List<CreateChildOperation> getCreateChildOperations() {
        List<CreateChildOperation> list = super.getCreateChildOperations();
        if (this.isMap()) {
            Param.addCreateParam(list, this, this.valueElement);
        }
        if (this.isFontDef()) {
            FontDef.addFontParamOperations(list, this, this.valueElement);
        }
        if (this.isInputMapDef()) {
            InputMapDef.addInputMapActionOperations(list, this, this.valueElement);
        }
        return list;
    }

    private URL getFontFileURL() throws MalformedURLException {
        String string = (String)this.fileNameProperty.getPropertyValue();
        return string != null ? this.themeFile.getURL(string) : null;
    }

    private void registerFontFiles() throws IOException {
        FontDef.registerFontFiles(this.getThemeFile().getEnv(), this.virtualFontFiles, this.getFontFileURL());
    }

    static void addCreateParam(List<CreateChildOperation> list, ThemeTreeNode themeTreeNode, Element element) {
        list.add(new CreateNewParam(element, "image", themeTreeNode, "none"));
        list.add(new CreateNewParam(element, "border", themeTreeNode, "0"));
        list.add(new CreateNewParam(element, "int", themeTreeNode, "0"));
        list.add(new CreateNewParam(element, "bool", themeTreeNode, "false"));
        list.add(new CreateNewParam(element, "gap", themeTreeNode, ""));
        list.add(new CreateNewParam(element, "dimension", themeTreeNode, "0,0"));
        list.add(new CreateNewParam(element, "string", themeTreeNode, ""));
        list.add(new CreateNewParam(element, "font", themeTreeNode, "default"));
        list.add(new CreateNewParamFontDef(element, themeTreeNode));
        list.add(new CreateNewParam(element, "cursor", themeTreeNode, "text"));
        list.add(new CreateNewParam(element, "map", themeTreeNode, "\n"));
        list.add(new CreateNewParamEnum(element, themeTreeNode, "alignment", "CENTER"));
        list.add(new CreateNewParam(element, "inputMap", themeTreeNode, "-defaultInputMap"));
        list.add(new CreateNewParam(element, "inputMapDef", themeTreeNode, ""));
    }

    static Property<?> createProperty(Element element, ThemeTreeNode themeTreeNode, ThemeTreeNode themeTreeNode2) {
        String string;
        String string2 = element.getName();
        if ("image".equals(string2)) {
            return new DerivedNodeReferenceProperty((Property<String>)new ElementTextProperty(element, "Image reference"), themeTreeNode2, Kind.IMAGE, true);
        }
        if ("border".equals(string2)) {
            return new BorderProperty((Property<String>)new ElementTextProperty(element, "Border"), 0, true);
        }
        if ("int".equals(string2)) {
            return new IntegerFormulaProperty((Property<String>)new ElementTextProperty(element, "Integer value"), Short.MIN_VALUE, Short.MAX_VALUE);
        }
        if ("bool".equals(string2)) {
            return new BooleanProperty((Property<String>)new ElementTextProperty(element, "Boolean value"), false);
        }
        if ("gap".equals(string2)) {
            return new GapProperty((Property<String>)new ElementTextProperty(element, "Layout gap"));
        }
        if ("dimension".equals(string2)) {
            return new DimensionProperty((Property<String>)new ElementTextProperty(element, "Dimesnion"));
        }
        if ("string".equals(string2)) {
            return new ElementTextProperty(element, "String value");
        }
        if ("font".equals(string2)) {
            return new DerivedNodeReferenceProperty((Property<String>)new ElementTextProperty(element, "Font reference"), themeTreeNode2, Kind.FONT);
        }
        if ("cursor".equals(string2)) {
            return new DerivedNodeReferenceProperty((Property<String>)new ElementTextProperty(element, "Cursor reference"), themeTreeNode2, Kind.CURSOR);
        }
        if ("enum".equals(string2) && "alignment".equals(string = element.getAttributeValue("type"))) {
            return Param.createEnumProperty(element, Alignment.class);
        }
        if ("inputMap".equals(string2)) {
            return new DerivedNodeReferenceProperty((Property<String>)new ElementTextProperty(element, "InputMap reference"), themeTreeNode2, Kind.INPUTMAP);
        }
        return null;
    }

    private static <T extends Enum<T>> EnumProperty<T> createEnumProperty(Element element, Class<T> clazz) {
        return EnumProperty.create((Property<String>)new ElementTextProperty(element, clazz.getSimpleName()), clazz);
    }

    private static Element getFirstChildElement(Element element) {
        int n = element.getContentSize();
        for (int i = 0; i < n; ++i) {
            Content content = element.getContent(i);
            if (!(content instanceof Element)) continue;
            return (Element)content;
        }
        return null;
    }

    static {
        ICON_MAP.put("border", "param-border");
        ICON_MAP.put("int", "param-int");
        ICON_MAP.put("string", "param-string");
        ICON_MAP.put("bool", "param-bool");
        ICON_MAP.put("image", "param-image");
        ICON_MAP.put("cursor", "param-cursor");
        ICON_MAP.put("font", "param-font");
        ICON_MAP.put("fontDef", "param-fontdef");
        ICON_MAP.put("inputMap", "param-inputmap");
        ICON_MAP.put("inputMapDef", "param-inputmapdef");
    }
}

