/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twlthemeeditor.datamodel;

import de.matthiasmann.twl.model.AbstractProperty;
import de.matthiasmann.twl.model.IntegerModel;
import de.matthiasmann.twl.model.Property;
import de.matthiasmann.twl.model.TreeTableNode;
import de.matthiasmann.twlthemeeditor.datamodel.DomWrapper;
import de.matthiasmann.twlthemeeditor.datamodel.DomXPPParser;
import de.matthiasmann.twlthemeeditor.datamodel.IntegerFormula;
import de.matthiasmann.twlthemeeditor.datamodel.Kind;
import de.matthiasmann.twlthemeeditor.datamodel.NodeReference;
import de.matthiasmann.twlthemeeditor.datamodel.Param;
import de.matthiasmann.twlthemeeditor.datamodel.ThemeFile;
import de.matthiasmann.twlthemeeditor.datamodel.ThemeTreeNode;
import de.matthiasmann.twlthemeeditor.datamodel.ThemeTreeOperation;
import de.matthiasmann.twlthemeeditor.datamodel.Utils;
import de.matthiasmann.twlthemeeditor.datamodel.operations.CloneNodeOperation;
import de.matthiasmann.twlthemeeditor.datamodel.operations.CreateChildOperation;
import de.matthiasmann.twlthemeeditor.datamodel.operations.CreateNewParam;
import de.matthiasmann.twlthemeeditor.datamodel.operations.CreateNewWildcardTheme;
import de.matthiasmann.twlthemeeditor.datamodel.operations.DeleteNodeOperation;
import de.matthiasmann.twlthemeeditor.properties.AttributeProperty;
import de.matthiasmann.twlthemeeditor.properties.BooleanProperty;
import de.matthiasmann.twlthemeeditor.properties.DerivedNodeReferenceProperty;
import de.matthiasmann.twlthemeeditor.properties.HasProperties;
import de.matthiasmann.twlthemeeditor.properties.NameProperty;
import de.matthiasmann.twlthemeeditor.properties.NodeReferenceProperty;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jdom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Theme
extends ThemeTreeNode
implements HasProperties {
    protected final NameProperty nameProperty;
    protected final BooleanProperty allowWildcardProperty;
    protected final BooleanProperty mergeProperty;
    protected final DerivedNodeReferenceProperty refProperty;

    public Theme(ThemeFile themeFile, TreeTableNode treeTableNode, Element element) {
        super(themeFile, treeTableNode, element);
        boolean bl;
        final boolean bl2 = element.getParentElement().isRootElement();
        boolean bl3 = bl = !bl2 && "".equals(element.getAttributeValue("name")) && "*".equals(element.getAttributeValue("ref"));
        if (bl) {
            this.nameProperty = null;
            this.allowWildcardProperty = null;
            this.mergeProperty = null;
            this.refProperty = null;
        } else {
            this.nameProperty = new NameProperty((Property)new AttributeProperty(element, "name"), this.getThemeTreeModel(), Kind.THEME, bl2){

                public void validateName(String string) throws IllegalArgumentException {
                    if (string == null || string.length() == 0) {
                        throw new IllegalArgumentException("empty name not allowed");
                    }
                    if (bl2 && Theme.this.getThemeTreeModel().findTopLevelNodes(Theme.class, string, Theme.this) != null) {
                        throw new IllegalArgumentException("Name \"" + string + "\" already in use");
                    }
                }
            };
            this.addProperty(this.nameProperty);
            if (bl2) {
                this.allowWildcardProperty = new BooleanProperty((Property<String>)new AttributeProperty(element, "allowWildcard", "Allow Wildcard", true), false);
                this.addProperty(this.allowWildcardProperty);
                this.mergeProperty = null;
            } else {
                this.allowWildcardProperty = null;
                this.mergeProperty = new BooleanProperty((Property<String>)new AttributeProperty(element, "merge", "Merge", true), false);
                this.addProperty(this.mergeProperty);
            }
            this.refProperty = new DerivedNodeReferenceProperty((Property<String>)new AttributeProperty(element, "ref", "Base theme reference", true), this, Kind.THEME);
            this.addProperty(this.refProperty);
        }
        this.addProperty(new NodeRefParamProperty("background", Kind.IMAGE, true));
        this.addProperty(new NodeRefParamProperty("overlay", Kind.IMAGE, true));
        this.addProperty(new NodeRefParamProperty("font", Kind.FONT, false));
        this.addProperty(new NodeRefParamProperty("mouseCursor", Kind.CURSOR, false));
        this.addProperty((Property<?>)new IntegerParamProperty("minWidth", 0, Short.MAX_VALUE));
        this.addProperty((Property<?>)new IntegerParamProperty("maxWidth", 0, Short.MAX_VALUE));
        this.addProperty((Property<?>)new IntegerParamProperty("minHeight", 0, Short.MAX_VALUE));
        this.addProperty((Property<?>)new IntegerParamProperty("maxHeight", 0, Short.MAX_VALUE));
    }

    @Override
    public String getName() {
        if (this.nameProperty == null) {
            return "WILDCARD";
        }
        return this.nameProperty.getPropertyValue();
    }

    @Override
    protected String getIcon() {
        return "theme";
    }

    public boolean isWildcard() {
        return this.nameProperty == null;
    }

    public boolean isAllowWildcard() {
        return this.allowWildcardProperty != null && this.allowWildcardProperty.getValue();
    }

    public boolean isMerge() {
        return this.mergeProperty != null && this.mergeProperty.getValue();
    }

    public boolean matchName(String string) {
        return this.nameProperty != null && this.nameProperty.getPropertyValue().equals(string);
    }

    public NodeReference getRef() {
        return this.refProperty.getPropertyValue();
    }

    @Override
    public Kind getKind() {
        return Kind.THEME;
    }

    public final Theme getLimit() {
        Theme theme = this;
        while (theme.getParent() instanceof Theme) {
            theme = (Theme)theme.getParent();
        }
        return theme;
    }

    @Override
    public boolean canPasteElement(Element element) {
        String string = element.getName();
        return "theme".equals(string) || "param".equals(string);
    }

    @Override
    public boolean childrenNeedName() {
        return true;
    }

    @Override
    public void addChildren() throws IOException {
        this.addChildren(this.themeFile, this.element, new DomWrapper(){

            public TreeTableNode wrap(ThemeFile themeFile, ThemeTreeNode themeTreeNode, Element element) throws IOException {
                String string = element.getName();
                if ("theme".equals(string)) {
                    return new Theme(themeFile, (TreeTableNode)themeTreeNode, element);
                }
                if ("param".equals(string)) {
                    return new Param(Theme.this, (TreeTableNode)themeTreeNode, element);
                }
                return null;
            }
        });
    }

    @Override
    public void addToXPP(DomXPPParser domXPPParser) {
        Utils.addToXPP(domXPPParser, this.element.getName(), this, this.element.getAttributes());
    }

    @Override
    public List<ThemeTreeOperation> getOperations() {
        List<ThemeTreeOperation> list = super.getOperations();
        list.add(new CloneNodeOperation(this.element, this));
        return list;
    }

    @Override
    public List<CreateChildOperation> getCreateChildOperations() {
        List<CreateChildOperation> list = super.getCreateChildOperations();
        ThemeFile.addCreateThemeOperation(list, this, this.element);
        list.add(new CreateNewWildcardTheme(this, this.element));
        Param.addCreateParam(list, this, this.element);
        return list;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class IntegerParamProperty
    extends ParamProperty<IntegerFormula>
    implements IntegerModel {
        final int minValue;
        final int maxValue;

        public IntegerParamProperty(String string, int n, int n2) {
            super(string, IntegerFormula.class);
            this.minValue = n;
            this.maxValue = n2;
        }

        public void addCallback(Runnable runnable) {
            this.addValueChangedCallback(runnable);
        }

        public void removeCallback(Runnable runnable) {
            this.removeValueChangedCallback(runnable);
        }

        public int getValue() {
            IntegerFormula integerFormula = (IntegerFormula)this.getPropertyValue();
            return integerFormula == null ? 0 : integerFormula.getValue();
        }

        public void setValue(int n) {
            this.setPropertyValue(new IntegerFormula(n));
        }

        public int getMaxValue() {
            return this.maxValue;
        }

        public int getMinValue() {
            return this.minValue;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class NodeRefParamProperty
    extends ParamProperty<NodeReference>
    implements NodeReferenceProperty {
        private final Kind kind;
        private final boolean supportsWildcard;

        public NodeRefParamProperty(String string, Kind kind, boolean bl) {
            super(string, NodeReference.class);
            this.kind = kind;
            this.supportsWildcard = bl;
        }

        @Override
        public Kind getKind() {
            return this.kind;
        }

        @Override
        public ThemeTreeNode getLimit() {
            NodeReferenceProperty nodeReferenceProperty = this.findNodeRefProperty();
            if (nodeReferenceProperty != null) {
                return nodeReferenceProperty.getLimit();
            }
            return null;
        }

        @Override
        public void handleNodeRenamed(String string, String string2, Kind kind) {
        }

        @Override
        public boolean isSupportsWildcard() {
            return this.supportsWildcard;
        }

        @Override
        protected String getDefaultValue() {
            return "none";
        }

        @Override
        protected String getTypeName() {
            return this.kind.name().toLowerCase();
        }

        private NodeReferenceProperty findNodeRefProperty() {
            Property<?> property;
            Param param = this.findParam();
            if (param != null && (property = param.getValueProperty()) instanceof NodeReferenceProperty) {
                return (NodeReferenceProperty)property;
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ParamProperty<T>
    extends AbstractProperty<T> {
        final String paramName;
        final Class<T> type;

        public ParamProperty(String string, Class<T> clazz) {
            this.paramName = string;
            this.type = clazz;
        }

        public boolean canBeNull() {
            return true;
        }

        public String getName() {
            return this.paramName;
        }

        public Class<T> getType() {
            return this.type;
        }

        public boolean isReadOnly() {
            return false;
        }

        public T getPropertyValue() {
            Property<?> property;
            Param param = this.findParam();
            if (param != null && (property = param.getValueProperty()).getType() == this.type) {
                return this.type.cast(property.getPropertyValue());
            }
            return null;
        }

        protected String getTypeName() {
            if (this.type == Integer.class || this.type == IntegerFormula.class) {
                return "int";
            }
            if (this.type == Boolean.class) {
                return "bool";
            }
            return this.type.getSimpleName().toLowerCase();
        }

        protected String getDefaultValue() {
            if (this.type == Integer.class || this.type == IntegerFormula.class) {
                return "0";
            }
            if (this.type == Boolean.class) {
                return "false";
            }
            return "";
        }

        public void setPropertyValue(T t) throws IllegalArgumentException {
            Object object;
            Param param = this.findParam();
            if (param == null && t != null) {
                object = new CreateNewParam(Theme.this.element, this.getTypeName(), Theme.this, this.getDefaultValue()){

                    protected String makeName() {
                        return ParamProperty.this.paramName;
                    }
                };
                try {
                    ((CreateChildOperation)object).execute(null);
                }
                catch (IOException iOException) {
                    Logger.getLogger(Theme.class.getName()).log(Level.SEVERE, "can't create param", iOException);
                }
                param = this.findParam();
            }
            if (param != null && (object = param.getValueProperty()).getType() == this.type) {
                if (t == null) {
                    DeleteNodeOperation deleteNodeOperation = new DeleteNodeOperation(param.getDOMElement(), param);
                    try {
                        deleteNodeOperation.execute(null);
                    }
                    catch (IOException iOException) {
                        Logger.getLogger(Theme.class.getName()).log(Level.SEVERE, "can't delete param", iOException);
                    }
                } else {
                    object.setPropertyValue(t);
                }
                this.fireValueChangedCallback();
            }
        }

        protected final Param findParam() {
            for (int i = 0; i < Theme.this.getNumChildren(); ++i) {
                Param param;
                TreeTableNode treeTableNode = Theme.this.getChild(i);
                if (!(treeTableNode instanceof Param) || !this.paramName.equals((param = (Param)treeTableNode).getName())) continue;
                return param;
            }
            return null;
        }
    }
}

