/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twlthemeeditor.datamodel;

import de.matthiasmann.twl.model.Property;
import de.matthiasmann.twl.model.TreeTableNode;
import de.matthiasmann.twlthemeeditor.TestEnv;
import de.matthiasmann.twlthemeeditor.VirtualFile;
import de.matthiasmann.twlthemeeditor.XMLWriter;
import de.matthiasmann.twlthemeeditor.datamodel.DomWrapper;
import de.matthiasmann.twlthemeeditor.datamodel.DomXPPParser;
import de.matthiasmann.twlthemeeditor.datamodel.FontDef;
import de.matthiasmann.twlthemeeditor.datamodel.Images;
import de.matthiasmann.twlthemeeditor.datamodel.Include;
import de.matthiasmann.twlthemeeditor.datamodel.InputMapDef;
import de.matthiasmann.twlthemeeditor.datamodel.Theme;
import de.matthiasmann.twlthemeeditor.datamodel.ThemeLoadErrorTracker;
import de.matthiasmann.twlthemeeditor.datamodel.ThemeTreeNode;
import de.matthiasmann.twlthemeeditor.datamodel.Utils;
import de.matthiasmann.twlthemeeditor.datamodel.operations.CreateChildOperation;
import de.matthiasmann.twlthemeeditor.datamodel.operations.CreateNewFontDef;
import de.matthiasmann.twlthemeeditor.datamodel.operations.CreateNewImages;
import de.matthiasmann.twlthemeeditor.datamodel.operations.CreateNewInclude;
import de.matthiasmann.twlthemeeditor.datamodel.operations.CreateNewSimple;
import de.matthiasmann.twlthemeeditor.gui.MessageLog;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.output.XMLOutputter;
import org.xmlpull.v1.XmlPullParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThemeFile
implements VirtualFile {
    private final MessageLog messageLog;
    private final ThemeFile rootThemeFile;
    private final TestEnv env;
    private final URL url;
    private final Document document;
    private final Runnable xmlChangedCB;
    private final Runnable propertyChangedCB;
    private ThemeTreeNode treeNode;
    private boolean modified;
    private boolean elementsUpgraded;
    private boolean hadErrors;
    private static final MessageLog.Category CAT_LOAD_ERROR = new MessageLog.Category("theme load error", MessageLog.CombineMode.NONE, 1);
    private static final MessageLog.Category CAT_UPGRADED = new MessageLog.Category("theme upgrades", MessageLog.CombineMode.NONE, 2);

    public ThemeFile(MessageLog messageLog, ThemeFile themeFile, TestEnv testEnv, URL uRL, Runnable runnable) throws IOException {
        this.messageLog = messageLog;
        this.rootThemeFile = themeFile;
        this.env = testEnv;
        this.url = uRL;
        this.xmlChangedCB = runnable;
        this.propertyChangedCB = new Runnable(){

            public void run() {
                ThemeFile.this.setModified(true);
                ThemeFile.this.xmlChangedCB.run();
            }
        };
        this.document = Utils.loadDocument(uRL);
        this.document.setProperty(ThemeFile.class.getName(), (Object)this);
        testEnv.registerFile(this);
    }

    public static ThemeFile getThemeFile(Content content) {
        Document document = content.getDocument();
        if (document != null) {
            return (ThemeFile)document.getProperty(ThemeFile.class.getName());
        }
        return null;
    }

    public boolean isModified() {
        return this.modified;
    }

    public void setModified(boolean bl) {
        this.modified = bl;
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        XMLWriter xMLWriter = new XMLWriter(new OutputStreamWriter(outputStream, "UTF8"));
        new XMLOutputter().output(this.document, (Writer)xMLWriter);
        ((Writer)xMLWriter).flush();
    }

    public TestEnv getEnv() {
        return this.env;
    }

    public Element getRootElement() {
        return this.document.getRootElement();
    }

    public ThemeFile getRootThemeFile() {
        return this.rootThemeFile == null ? this : this.rootThemeFile;
    }

    public URL getURL() {
        return this.url;
    }

    public URL getURL(String string) throws MalformedURLException {
        return new URL(this.url, string);
    }

    public ThemeFile createThemeFile(String string) throws IOException {
        return new ThemeFile(this.messageLog, this, this.env, this.getURL(string), this.xmlChangedCB);
    }

    public URL getVirtualURL() throws MalformedURLException {
        return this.env.getURL(this.url.getFile());
    }

    public void log(MessageLog.Entry entry) {
        this.messageLog.add(entry);
    }

    public void logError(String string, String string2, Throwable throwable) {
        this.hadErrors = true;
        this.messageLog.add(new MessageLog.Entry(CAT_LOAD_ERROR, string, string2, throwable, new MessageLog.EntryAction[0]));
    }

    public void elementUpgraded() {
        this.setModified(true);
        if (!this.elementsUpgraded) {
            this.elementsUpgraded = true;
            this.messageLog.add(new MessageLog.Entry(CAT_UPGRADED, "Elements have been upgraded", "The theme file '" + this.url.getPath() + "' has been converted to a new format. " + "Saving the theme will require a up to date TWL version to parse it.", null, new MessageLog.EntryAction[0]));
        }
    }

    public boolean isHadErrors() {
        return this.hadErrors;
    }

    protected void addChildren(ThemeTreeNode themeTreeNode) throws IOException {
        this.treeNode = themeTreeNode;
        themeTreeNode.addChildren(this, this.document.getRootElement(), new DomWrapper(){

            public TreeTableNode wrap(ThemeFile themeFile, ThemeTreeNode themeTreeNode, Element element) throws IOException {
                String string = element.getName();
                if ("images".equals(string)) {
                    return new Images((TreeTableNode)themeTreeNode, element, themeFile);
                }
                if ("textures".equals(string)) {
                    element.setName("images");
                    ThemeFile.this.setModified(true);
                    return new Images((TreeTableNode)themeTreeNode, element, themeFile);
                }
                if ("include".equals(string)) {
                    return new Include((TreeTableNode)themeTreeNode, element, themeFile);
                }
                if ("fontDef".equals(string)) {
                    return new FontDef(themeFile, (TreeTableNode)themeTreeNode, element);
                }
                if ("theme".equals(string)) {
                    return new Theme(themeFile, (TreeTableNode)themeTreeNode, element);
                }
                if ("inputMapDef".equals(string)) {
                    return new InputMapDef(themeFile, (TreeTableNode)themeTreeNode, element);
                }
                return null;
            }
        });
    }

    protected void addCreateOperations(List<CreateChildOperation> list, ThemeTreeNode themeTreeNode) {
        ThemeFile.addCreateThemeOperation(list, themeTreeNode, this.document.getRootElement());
        list.add(new CreateNewSimple(themeTreeNode, this.document.getRootElement(), "inputMapDef", "name", "changeMe"));
        list.add(new CreateNewImages(themeTreeNode, this.document.getRootElement()));
        list.add(new CreateNewFontDef(themeTreeNode, this.document.getRootElement()));
        list.add(new CreateNewInclude(themeTreeNode, this.document.getRootElement()));
    }

    static void addCreateThemeOperation(List<CreateChildOperation> list, ThemeTreeNode themeTreeNode, Element element) {
        list.add(new CreateNewSimple(themeTreeNode, element, "theme", "ref", "-defaults"));
    }

    void registerProperty(Property<?> property) {
        property.addValueChangedCallback(this.propertyChangedCB);
    }

    @Override
    public String getVirtualFileName() {
        return this.url.getFile();
    }

    @Override
    public Object getContent(Class<?> clazz) throws IOException {
        if (clazz == XmlPullParser.class && this.treeNode != null) {
            DomXPPParser domXPPParser = new DomXPPParser(this.getVirtualFileName());
            ThemeLoadErrorTracker.register(domXPPParser);
            Element element = this.document.getRootElement();
            Utils.addToXPP(domXPPParser, element.getName(), this.treeNode, element.getAttributes());
            return domXPPParser;
        }
        return null;
    }

    @Override
    public InputStream openStream() throws IOException {
        throw new IOException("Call getContent().");
    }
}

