/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twlthemeeditor.datamodel;

import de.matthiasmann.twl.model.AbstractTreeTableNode;
import de.matthiasmann.twl.model.Property;
import de.matthiasmann.twl.model.TreeTableNode;
import de.matthiasmann.twlthemeeditor.datamodel.DecoratedText;
import de.matthiasmann.twlthemeeditor.datamodel.DecoratedTextWithIcon;
import de.matthiasmann.twlthemeeditor.datamodel.DomWrapper;
import de.matthiasmann.twlthemeeditor.datamodel.DomXPPParser;
import de.matthiasmann.twlthemeeditor.datamodel.Kind;
import de.matthiasmann.twlthemeeditor.datamodel.NameGenerator;
import de.matthiasmann.twlthemeeditor.datamodel.ThemeFile;
import de.matthiasmann.twlthemeeditor.datamodel.ThemeTreeModel;
import de.matthiasmann.twlthemeeditor.datamodel.ThemeTreeOperation;
import de.matthiasmann.twlthemeeditor.datamodel.Unknown;
import de.matthiasmann.twlthemeeditor.datamodel.operations.CopyNodeOperation;
import de.matthiasmann.twlthemeeditor.datamodel.operations.CreateChildOperation;
import de.matthiasmann.twlthemeeditor.datamodel.operations.DeleteNodeOperation;
import de.matthiasmann.twlthemeeditor.datamodel.operations.MoveNodeOperations;
import de.matthiasmann.twlthemeeditor.datamodel.operations.PasteNodeOperation;
import de.matthiasmann.twlthemeeditor.properties.NodeReferenceProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.List;
import org.jdom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ThemeTreeNode
extends AbstractTreeTableNode {
    protected final ThemeFile themeFile;
    protected final Element element;
    protected final ArrayList<Property<?>> properties;
    protected boolean error;

    protected ThemeTreeNode(ThemeFile themeFile, TreeTableNode treeTableNode, Element element) {
        super(treeTableNode);
        this.themeFile = themeFile;
        this.element = element;
        this.properties = new ArrayList();
        this.setLeaf(true);
    }

    public final ThemeTreeModel getThemeTreeModel() {
        return (ThemeTreeModel)this.getTreeTableModel();
    }

    public final ThemeFile getThemeFile() {
        return this.themeFile;
    }

    public final ThemeFile getRootThemeFile() {
        return this.themeFile.getRootThemeFile();
    }

    public final Element getDOMElement() {
        return this.element;
    }

    public void setError(boolean bl) {
        this.error = bl;
        if (this.getParent() instanceof ThemeTreeNode) {
            ((ThemeTreeNode)this.getParent()).setError(bl);
        }
    }

    public <E extends TreeTableNode> List<E> getChildren(Class<E> clazz) {
        ArrayList<E> arrayList = new ArrayList<E>();
        int n = this.getNumChildren();
        for (int i = 0; i < n; ++i) {
            TreeTableNode treeTableNode = this.getChild(i);
            if (!clazz.isInstance(treeTableNode)) continue;
            arrayList.add(clazz.cast(treeTableNode));
        }
        return arrayList;
    }

    public boolean canPasteElement(Element element) {
        return false;
    }

    public boolean childrenNeedName() {
        return false;
    }

    public abstract Kind getKind();

    public abstract void addToXPP(DomXPPParser var1);

    public abstract void addChildren() throws IOException;

    protected void addChildren(ThemeFile themeFile, Element element, DomWrapper domWrapper) throws IOException {
        Element element2;
        int n;
        IdentityHashMap<Element, TreeTableNode> identityHashMap = new IdentityHashMap<Element, TreeTableNode>();
        int n2 = this.getNumChildren();
        for (n = 0; n < n2; ++n) {
            Object object = this.getChild(n);
            if (!(object instanceof ThemeTreeNode) || (element2 = ((ThemeTreeNode)((Object)object)).getDOMElement()) == null) continue;
            identityHashMap.put(element2, (TreeTableNode)object);
        }
        n = 0;
        for (Object object : element.getChildren()) {
            if (!(object instanceof Element)) continue;
            element2 = (Element)object;
            Object object2 = (TreeTableNode)identityHashMap.remove(element2);
            if (object2 != null) {
                if (this.getChild(n) != object2) {
                    this.removeChild((TreeTableNode)object2);
                    this.insertChild((TreeTableNode)object2, n);
                }
            } else {
                object2 = domWrapper.wrap(themeFile, this, element2);
                if (object2 == null) {
                    object2 = new Unknown((TreeTableNode)this, element2, themeFile);
                }
                if (object2 instanceof ThemeTreeNode) {
                    ((ThemeTreeNode)((Object)object2)).addChildren();
                }
                this.insertChild((TreeTableNode)object2, n);
            }
            ++n;
        }
        for (Object object : identityHashMap.values()) {
            this.removeChild((TreeTableNode)object);
        }
        this.setLeaf(this.getNumChildren() == 0);
    }

    private void removeChild(TreeTableNode treeTableNode) {
        int n = super.getChildIndex(treeTableNode);
        if (n >= 0) {
            super.removeChild(n);
        }
    }

    public List<ThemeTreeOperation> getOperations() {
        ArrayList<ThemeTreeOperation> arrayList = new ArrayList<ThemeTreeOperation>();
        arrayList.add(new DeleteNodeOperation(this.element, this));
        arrayList.add(new MoveNodeOperations("opMoveNodeUp", this.element, this, -1));
        arrayList.add(new MoveNodeOperations("opMoveNodeDown", this.element, this, 1));
        arrayList.add(new CopyNodeOperation(this.element, this));
        return arrayList;
    }

    public List<CreateChildOperation> getCreateChildOperations() {
        ArrayList<CreateChildOperation> arrayList = new ArrayList<CreateChildOperation>();
        arrayList.add(new PasteNodeOperation(this, this.element));
        return arrayList;
    }

    public final MoveNodeOperations getMoveOperation(int n) {
        for (ThemeTreeOperation themeTreeOperation : this.getOperations()) {
            MoveNodeOperations moveNodeOperations;
            if (!(themeTreeOperation instanceof MoveNodeOperations) || (moveNodeOperations = (MoveNodeOperations)themeTreeOperation).getDirection() != n) continue;
            return moveNodeOperations;
        }
        return null;
    }

    public Object getData(int n) {
        switch (n) {
            case 0: {
                String string;
                String string2 = this.getDisplayName();
                int n2 = 0;
                if (this.error) {
                    n2 |= 1;
                }
                if (this.isModified()) {
                    n2 |= 4;
                }
                if ((string = this.getIcon()) != null) {
                    return new DecoratedTextWithIcon(string2, n2, string);
                }
                return DecoratedText.apply(string2, n2);
            }
            case 1: {
                return this.getType();
            }
        }
        return "";
    }

    public String getDisplayName() {
        String string = this.getName();
        if (string == null && this.getParent() instanceof NameGenerator) {
            string = ((NameGenerator)this.getParent()).generateName(this);
        }
        if (string == null) {
            string = "Unnamed #" + (1 + this.getParent().getChildIndex((TreeTableNode)this));
        }
        return string;
    }

    public abstract String getName();

    protected String getType() {
        return this.element.getName();
    }

    protected String getIcon() {
        return null;
    }

    protected boolean isModified() {
        return false;
    }

    public final void handleNodeRenamed(String string, String string2, Kind kind) {
        for (Property<?> object : this.properties) {
            if (!(object instanceof NodeReferenceProperty)) continue;
            ((NodeReferenceProperty)object).handleNodeRenamed(string, string2, kind);
        }
        for (ThemeTreeNode themeTreeNode : this.getChildren(ThemeTreeNode.class)) {
            themeTreeNode.handleNodeRenamed(string, string2, kind);
        }
    }

    public final ThemeTreeNode findNode(String string, Kind kind) {
        if (this.getKind() == kind && string.equals(this.getName())) {
            return this;
        }
        for (ThemeTreeNode themeTreeNode : this.getChildren(ThemeTreeNode.class)) {
            ThemeTreeNode themeTreeNode2 = themeTreeNode.findNode(string, kind);
            if (themeTreeNode2 == null) continue;
            return themeTreeNode2;
        }
        return null;
    }

    public final void collectNodes(String string, Kind kind, Collection<ThemeTreeNode> collection) {
        String string2 = this.getName();
        if (this.getKind() == kind && string2 != null && string2.startsWith(string)) {
            collection.add(this);
        }
        for (ThemeTreeNode themeTreeNode : this.getChildren(ThemeTreeNode.class)) {
            themeTreeNode.collectNodes(string, kind, collection);
        }
    }

    public Property<?>[] getProperties() {
        return this.properties.toArray(new Property[this.properties.size()]);
    }

    protected final void addProperty(Property<?> property) {
        this.themeFile.registerProperty(property);
        this.properties.add(property);
    }

    public String toString() {
        String string = this.getName();
        if (string != null) {
            return (Object)((Object)this.getKind()) + " " + string;
        }
        if (this.getParent() != null) {
            return this.getParent().toString() + "/" + this.element.getName();
        }
        return "<" + this.element.getName() + ">";
    }
}

