/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twlthemeeditor.datamodel;

import de.matthiasmann.twl.model.TreeTableNode;
import de.matthiasmann.twlthemeeditor.datamodel.DomXPPParser;
import de.matthiasmann.twlthemeeditor.datamodel.Kind;
import de.matthiasmann.twlthemeeditor.datamodel.ThemeFile;
import de.matthiasmann.twlthemeeditor.datamodel.ThemeTreeNode;
import de.matthiasmann.twlthemeeditor.datamodel.ThemeTreeOperation;
import de.matthiasmann.twlthemeeditor.datamodel.operations.CreateChildOperation;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.jdom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThemeTreeRootNode
extends ThemeTreeNode {
    public ThemeTreeRootNode(ThemeFile themeFile, TreeTableNode treeTableNode) {
        super(themeFile, treeTableNode, themeFile.getRootElement());
    }

    @Override
    public String getName() {
        String string = this.themeFile.getVirtualFileName();
        int n = string.lastIndexOf(47);
        return string.substring(n + 1);
    }

    @Override
    public void addChildren() throws IOException {
        this.themeFile.addChildren(this);
    }

    @Override
    public void addToXPP(DomXPPParser domXPPParser) {
        throw new IllegalStateException("Should not reach here");
    }

    @Override
    public Kind getKind() {
        return Kind.NONE;
    }

    @Override
    protected String getIcon() {
        return "themes";
    }

    @Override
    protected boolean isModified() {
        return this.themeFile.isModified();
    }

    @Override
    public boolean canPasteElement(Element element) {
        String string = element.getName();
        return "theme".equals(string);
    }

    @Override
    public boolean childrenNeedName() {
        return true;
    }

    @Override
    public List<ThemeTreeOperation> getOperations() {
        return Collections.emptyList();
    }

    @Override
    public List<CreateChildOperation> getCreateChildOperations() {
        List<CreateChildOperation> list = super.getCreateChildOperations();
        this.themeFile.addCreateOperations(list, this);
        return list;
    }
}

