/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twlthemeeditor.datamodel;

import de.matthiasmann.twl.model.TreeTableNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeTablePath
implements Comparable<TreeTablePath> {
    final TreeTableNode node;
    final TreeTablePath next;

    private TreeTablePath(TreeTableNode treeTableNode, TreeTablePath treeTablePath) {
        this.node = treeTableNode;
        this.next = treeTablePath;
    }

    static TreeTablePath create(TreeTableNode treeTableNode) {
        TreeTablePath treeTablePath = null;
        while (treeTableNode != null) {
            treeTablePath = new TreeTablePath(treeTableNode, treeTablePath);
            treeTableNode = treeTableNode.getParent();
        }
        return treeTablePath;
    }

    @Override
    public int compareTo(TreeTablePath treeTablePath) {
        TreeTablePath treeTablePath2 = this;
        while (treeTablePath2 != null && treeTablePath != null && treeTablePath2.node == treeTablePath.node) {
            treeTablePath2 = treeTablePath2.next;
            treeTablePath = treeTablePath.next;
        }
        if (treeTablePath2 == null) {
            return treeTablePath == null ? 0 : -1;
        }
        if (treeTablePath == null) {
            return 1;
        }
        return treeTablePath2.getIndexInParent() - treeTablePath.getIndexInParent();
    }

    @Override
    public int compareTo(TreeTableNode treeTableNode) {
        return this.compareTo(TreeTablePath.create(treeTableNode));
    }

    public boolean equals(Object object) {
        if (object != null && object.getClass() == this.getClass()) {
            TreeTablePath treeTablePath = (TreeTablePath)object;
            return this.getNode() == treeTablePath.getNode();
        }
        return false;
    }

    public int hashCode() {
        return System.identityHashCode(this.getNode());
    }

    public TreeTableNode getNode() {
        TreeTablePath treeTablePath = this;
        while (treeTablePath.next != null) {
            treeTablePath = treeTablePath.next;
        }
        return treeTablePath.node;
    }

    private int getIndexInParent() {
        TreeTableNode treeTableNode = this.node.getParent();
        return treeTableNode != null ? treeTableNode.getChildIndex(this.node) : 0;
    }
}

